/*
 * Decompiled with CFR 0.152.
 */
package Alerting.utils;

import java.io.Serializable;
import play.api.http.Status$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.ws.WSClient;
import play.api.libs.ws.WSResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class WSUtil$ {
    public static final WSUtil$ MODULE$ = new WSUtil$();
    private static final ExecutionContext context = ExecutionContext$.MODULE$.global();
    private static final Tuple2<String, String> authorization = new Tuple2((Object)"Authorization", (Object)System.getenv("APPLICATION_TOKEN"));

    public ExecutionContext context() {
        return context;
    }

    private Tuple2<String, String> authorization() {
        return authorization;
    }

    public <T> Option<T> response(Future<WSResponse> future, String url, Reads<T> reads) {
        WSResponse r = (WSResponse)Await$.MODULE$.result(future, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes());
        int n = r.status();
        if (Status$.MODULE$.OK() == n ? true : Status$.MODULE$.PARTIAL_CONTENT() == n) {
            JsResult jsResult = r.json().validate(reads);
            if (jsResult instanceof JsSuccess) {
                JsSuccess jsSuccess = (JsSuccess)jsResult;
                return new Some(jsSuccess.value());
            }
            if (jsResult instanceof JsError) {
                JsError jsError = (JsError)jsResult;
                Predef$.MODULE$.println((Object)jsError.toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)jsResult);
        }
        if (404 == n) {
            return None$.MODULE$;
        }
        Predef$.MODULE$.println((Object)new StringBuilder(40).append("Unexpected response received with url : ").append(url).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(3).append(r.status()).append(" : ").append(r.statusText()).toString());
        return None$.MODULE$;
    }

    public <T> Future<Either<T, Exception>> responseWithReads(Future<WSResponse> future, Reads<T> reads, String url) {
        return future.map((Function1 & Serializable)response -> {
            int n = response.status();
            if (Status$.MODULE$.OK() == n) {
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> response.json());
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    JsValue json = (JsValue)success.value();
                    JsResult jsResult = json.validate(reads);
                    if (jsResult instanceof JsSuccess) {
                        JsSuccess jsSuccess = (JsSuccess)jsResult;
                        return package$.MODULE$.Left().apply(jsSuccess.value());
                    }
                    if (jsResult instanceof JsError) {
                        JsError jsError = (JsError)jsResult;
                        return package$.MODULE$.Right().apply((Object)new Exception(jsError.toString()));
                    }
                    throw new MatchError((Object)jsResult);
                }
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable e = failure.exception();
                    Predef$.MODULE$.println((Object)new StringBuilder(39).append("ERROR : failed to read json with url : ").append(url).toString());
                    e.printStackTrace();
                    return package$.MODULE$.Right().apply((Object)new Exception(e));
                }
                throw new MatchError((Object)try_);
            }
            Predef$.MODULE$.println((Object)new StringBuilder(40).append("Unexpected response received with url : ").append(url).toString());
            return package$.MODULE$.Right().apply((Object)new Exception(new StringBuilder(13).append(response.status()).append(": ").append(response.statusText()).append(", with url ").append(url).toString()));
        }, this.context());
    }

    public <T> Future<Try<T>> responseTry(Future<WSResponse> future, Reads<T> reads) {
        return future.map((Function1 & Serializable)response -> {
            int n = response.status();
            if (Status$.MODULE$.OK() == n) {
                JsResult jsResult = response.json().validate(reads);
                if (jsResult instanceof JsSuccess) {
                    JsSuccess jsSuccess = (JsSuccess)jsResult;
                    return new Success(jsSuccess.value());
                }
                if (jsResult instanceof JsError) {
                    JsError jsError = (JsError)jsResult;
                    return new Failure((Throwable)new Exception(jsError.toString()));
                }
                throw new MatchError((Object)jsResult);
            }
            return new Failure((Throwable)new Exception(new StringBuilder(2).append(response.status()).append(": ").append(response.statusText()).toString()));
        }, this.context());
    }

    public <T> Option<T> simpleGet(String url, Reads<T> reads, WSClient ws) {
        return this.response((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), url, reads);
    }

    public <T> Future<Either<T, Exception>> simpleGetWithReads(String url, Reads<T> reads, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads, url);
    }

    public <T> Future<Either<T, Exception>> simplePostWithReads(String url, JsValue json, Reads<T> reads, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).post((Object)json, play.api.libs.ws.package$.MODULE$.writeableOf_JsValue()), reads, url);
    }

    public <T> Future<Try<T>> simpleGetTry(String url, Reads<T> reads, WSClient ws) {
        return this.responseTry((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public <T> Future<Try<T>> simpleGetWithAuthTry(String url, Reads<T> reads, WSClient ws) {
        return this.responseTry((Future<WSResponse>)ws.url(url).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.authorization()})).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads);
    }

    public <T> Future<Try<T>> simplePostTry(String url, JsValue json, Reads<T> reads, WSClient ws) {
        return this.responseTry((Future<WSResponse>)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).post((Object)json, play.api.libs.ws.package$.MODULE$.writeableOf_JsValue()), reads);
    }

    public <T> Option<T> getWithAuth(String url, Reads<T> reads, WSClient ws) {
        return this.getWithAuth(url, 4, reads, ws);
    }

    public <T> Option<T> getWithAuth(String url, int nb, Reads<T> reads, WSClient ws) {
        Option<T> option;
        while (true) {
            try {
                Option<T> resp = this.response((Future<WSResponse>)ws.url(url).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.authorization()})).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), url, reads);
                if (resp.isDefined()) {
                    option = resp;
                    break;
                }
                if (nb > 0) {
                    Thread.sleep(10000L);
                    option = this.getWithAuth(url, nb - 1, reads, ws);
                    break;
                }
                if (nb == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder(16).append(" Error on url  ").append(url).append(" ").append(nb).toString());
                    Thread.sleep(180000L);
                    option = this.getWithAuth(url, nb - 1, reads, ws);
                    break;
                }
                option = None$.MODULE$;
            }
            catch (Throwable e) {
                if (nb > 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder(17).append(" Error on appel ").append(url).append(" ").append(nb).toString());
                    Thread.sleep(10000L);
                    --nb;
                    continue;
                }
                if (nb == 0) {
                    Predef$.MODULE$.println((Object)new StringBuilder(16).append(" Error on url  ").append(url).append(" ").append(nb).toString());
                    Thread.sleep(180000L);
                    --nb;
                    continue;
                }
                option = None$.MODULE$;
            }
            break;
        }
        return option;
    }

    public <T> Option<T> postAqua6BO(String url, String body, Reads<T> reads, WSClient ws) {
        return this.response((Future<WSResponse>)ws.url(url).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{this.authorization()})).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).post((Object)body, play.api.libs.ws.package$.MODULE$.writeableOf_String()), url, reads);
    }

    public <T> Future<Either<T, Exception>> getWithAuthWithReads(String url, Reads<T> reads, Option<Tuple2<String, String>> auth, WSClient ws) {
        return this.responseWithReads((Future<WSResponse>)ws.url(url).withHeaders((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{(Tuple2)auth.getOrElse((Function0 & Serializable)() -> MODULE$.authorization())})).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), reads, url);
    }

    public <T> Option<Tuple2<String, String>> getWithAuthWithReads$default$3() {
        return None$.MODULE$;
    }

    public String getAsString(String url, WSClient ws) {
        return ((WSResponse)Await$.MODULE$.result((Awaitable)ws.url(url).withRequestTimeout((Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes()).get(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(20)).minutes())).body();
    }

    private WSUtil$() {
    }
}

