/*
 * Decompiled with CFR 0.152.
 */
package util;

import fr.aquasys.daeau.hydrometry.chronic.HydroChronicDao;
import fr.aquasys.daeau.iaeau.model.AquasysData;
import fr.aquasys.daeau.iaeau.model.IAEauModel;
import fr.aquasys.daeau.iaeau.model.PredMeasure;
import fr.aquasys.daeau.piezometry.itf.PiezometerMeasureDao;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.Hours;
import org.joda.time.Months;
import org.joda.time.ReadablePartial;
import org.joda.time.Weeks;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Try$;

public final class IAEauUtils$ {
    public static final IAEauUtils$ MODULE$ = new IAEauUtils$();

    public AquasysData getAquasysData(Seq<AquasysData> data, int id) {
        return (AquasysData)Try$.MODULE$.apply((Function0 & Serializable)() -> (AquasysData)data.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)IAEauUtils$.$anonfun$getAquasysData$2(id, d))).get()).toOption().getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(33).append("Aquasys data not found with id : ").append(id).toString());
        });
    }

    public AquasysData getAquasysData(Seq<AquasysData> data, String file) {
        return (AquasysData)Try$.MODULE$.apply((Function0 & Serializable)() -> data.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)IAEauUtils$.$anonfun$getAquasysData$5(file, d)))).toOption().flatten((.less.colon.less)$less$colon$less$.MODULE$.refl()).getOrElse((Function0 & Serializable)() -> {
            throw new Exception(new StringBuilder(35).append("Aquasys data not found with name : ").append(file).toString());
        });
    }

    public Option<AquasysData> getAquasysDataOption(Seq<AquasysData> data, int id) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (AquasysData)data.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)IAEauUtils$.$anonfun$getAquasysDataOption$2(id, d))).get()).toOption();
    }

    public Option<AquasysData> getAquasysDataOption(Seq<AquasysData> data, String file) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (AquasysData)data.find((Function1 & Serializable)d -> BoxesRunTime.boxToBoolean((boolean)IAEauUtils$.$anonfun$getAquasysDataOption$4(file, d))).get()).toOption();
    }

    public Seq<PredMeasure> applyHackOnCalculatedMeasures(Seq<PredMeasure> measures, IAEauModel model, PiezometerMeasureDao PiezometerMeasureDao2, HydroChronicDao HydroChronicDao2) {
        return (Seq)((IterableOps)measures.sortBy((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)IAEauUtils$.$anonfun$applyHackOnCalculatedMeasures$1(x$1)), (Ordering)Ordering.Long$.MODULE$)).headOption().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)IAEauUtils$.$anonfun$applyHackOnCalculatedMeasures$2(x$2))).map((Function1 & Serializable)first -> {
            Some some;
            Tuple2 tuple2;
            Option lastMeasureValueOptOpt;
            Option option;
            String string = StationTypeUtil$.MODULE$.StationType(model.stationType());
            String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                option = PiezometerMeasureDao2.getLastMeasures((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{first.idStation()})), first.typeId(), (Option)new Some((Object)first.date())).headOption().map((Function1 & Serializable)m -> new Tuple2((Object)m.date(), model.typeId() == -1 ? m.NGF().get() : m.value().get()));
            } else {
                String string4 = StationTypeUtil$.MODULE$.HYDROMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    option = HydroChronicDao2.getLastMeasures((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{model.idStation()})), (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{model.typeId()})), (Option)new Some((Object)first.date())).headOption().map((Function1 & Serializable)m -> new Tuple2((Object)m.date(), m.value().get()));
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Option option2 = lastMeasureValueOptOpt = option;
            if (None$.MODULE$.equals(option2)) {
                return measures;
            }
            if (option2 instanceof Some && (tuple2 = (Tuple2)(some = (Some)option2).value()) != null) {
                DateTime lastDate = (DateTime)tuple2._1();
                double lastValue = tuple2._2$mcD$sp();
                double gap = BoxesRunTime.unboxToDouble((Object)first.value().get()) - lastValue;
                return (Seq)measures.map((Function1 & Serializable)m -> {
                    DateTime x$1 = m.date().withTime(lastDate.toLocalTime());
                    Option x$2 = m.value().map((Function1)(JFunction1.mcDD.sp & Serializable)v -> v - gap);
                    Option x$32 = m.doubtMin().map((Function1)(JFunction1.mcDD.sp & Serializable)v -> v - gap);
                    Option x$4 = m.doubtMax().map((Function1)(JFunction1.mcDD.sp & Serializable)v -> v - gap);
                    Option x$5 = m.value().map((Function1)(JFunction1.mcDD.sp & Serializable)x$3 -> gap);
                    int x$6 = m.copy$default$1();
                    int x$7 = m.copy$default$2();
                    DateTime x$8 = m.copy$default$3();
                    String x$9 = m.copy$default$6();
                    Option x$10 = m.copy$default$7();
                    Option x$11 = m.copy$default$10();
                    DateTime x$12 = m.copy$default$11();
                    DateTime x$13 = m.copy$default$12();
                    String x$14 = m.copy$default$13();
                    Option x$15 = m.copy$default$15();
                    int x$16 = m.copy$default$16();
                    String x$17 = m.copy$default$17();
                    int x$18 = m.copy$default$18();
                    return m.copy(x$6, x$7, x$8, x$1, x$2, x$9, x$10, x$32, x$4, x$11, x$12, x$13, x$14, x$5, x$15, x$16, x$17, x$18);
                });
            }
            throw new MatchError((Object)option2);
        }).getOrElse((Function0 & Serializable)() -> (Seq)Nil$.MODULE$);
    }

    public int getHorizon(IAEauModel model, DateTime start, DateTime end) {
        String string = (String)model.horizonMode().get();
        switch (string == null ? 0 : string.hashCode()) {
            case -1068487181: {
                if (!"months".equals(string)) break;
                return Months.monthsBetween((ReadablePartial)start.toLocalDate(), (ReadablePartial)end.toLocalDate()).getMonths();
            }
            case 3076183: {
                if (!"days".equals(string)) break;
                return Days.daysBetween((ReadablePartial)start.toLocalDate(), (ReadablePartial)end.toLocalDate()).getDays();
            }
            case 99469071: {
                if (!"hours".equals(string)) break;
                return Hours.hoursBetween((ReadablePartial)start.toLocalDate(), (ReadablePartial)end.toLocalDate()).getHours();
            }
            case 113008383: {
                if (!"weeks".equals(string)) break;
                return Weeks.weeksBetween((ReadablePartial)start.toLocalDate(), (ReadablePartial)end.toLocalDate()).getWeeks();
            }
        }
        throw new MatchError((Object)string);
    }

    public static final /* synthetic */ boolean $anonfun$getAquasysData$2(int id$1, AquasysData d) {
        return d.id() == id$1;
    }

    public static final /* synthetic */ boolean $anonfun$getAquasysData$5(String file$1, AquasysData d) {
        return d.name().exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.contains(file$1)));
    }

    public static final /* synthetic */ boolean $anonfun$getAquasysDataOption$2(int id$2, AquasysData d) {
        return d.id() == id$2;
    }

    public static final /* synthetic */ boolean $anonfun$getAquasysDataOption$4(String file$2, AquasysData d) {
        return d.name().exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)s.contains(file$2)));
    }

    public static final /* synthetic */ long $anonfun$applyHackOnCalculatedMeasures$1(PredMeasure x$1) {
        return x$1.date().getMillis();
    }

    public static final /* synthetic */ boolean $anonfun$applyHackOnCalculatedMeasures$2(PredMeasure x$2) {
        return x$2.value().isDefined();
    }

    private IAEauUtils$() {
    }
}

