/*
 * Decompiled with CFR 0.152.
 */
package play.http;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.pekko.japi.pf.PFBuilder;
import org.apache.pekko.stream.Materializer;
import org.apache.pekko.stream.javadsl.Source;
import org.apache.pekko.util.ByteString;
import play.api.http.HttpChunk;
import play.api.http.HttpEntity;
import play.twirl.api.Content;
import play.twirl.api.Xml;
import scala.Option;
import scala.jdk.javaapi.OptionConverters;

public abstract class HttpEntity {
    public static final HttpEntity NO_ENTITY = new Strict(ByteString.emptyByteString(), Optional.empty());

    private HttpEntity() {
    }

    public abstract Optional<String> contentType();

    public abstract boolean isKnownEmpty();

    public abstract Optional<Long> contentLength();

    public abstract Source<ByteString, ?> dataStream();

    public abstract HttpEntity as(String var1);

    public CompletionStage<ByteString> consumeData(Materializer materializer) {
        return this.dataStream().runFold((Object)ByteString.emptyByteString(), ByteString::concat, materializer);
    }

    public abstract play.api.http.HttpEntity asScala();

    public static final HttpEntity fromContent(Content content, String string) {
        String string2 = content instanceof Xml ? content.body().trim() : content.body();
        return new Strict(ByteString.fromString((String)string2, (String)string), Optional.of(content.contentType() + "; charset=" + string));
    }

    public static final HttpEntity fromString(String string, String string2) {
        return new Strict(ByteString.fromString((String)string, (String)string2), Optional.of("text/plain; charset=" + string2));
    }

    public static final HttpEntity chunked(Source<ByteString, ?> source, Optional<String> optional) {
        return new Chunked(source.map(HttpChunk.Chunk::new), optional);
    }

    public static final class Chunked
    extends HttpEntity {
        private final Source<HttpChunk, ?> chunks;
        private final Optional<String> contentType;

        public Chunked(Source<HttpChunk, ?> source, Optional<String> optional) {
            this.chunks = source;
            this.contentType = optional;
        }

        public Source<HttpChunk, ?> chunks() {
            return this.chunks;
        }

        @Override
        public Optional<String> contentType() {
            return this.contentType;
        }

        @Override
        public boolean isKnownEmpty() {
            return false;
        }

        @Override
        public Optional<Long> contentLength() {
            return Optional.empty();
        }

        @Override
        public HttpEntity as(String string) {
            return new Chunked(this.chunks, Optional.ofNullable(string));
        }

        @Override
        public Source<ByteString, ?> dataStream() {
            return this.chunks.collect(new PFBuilder().match(HttpChunk.Chunk.class, HttpChunk.Chunk::data).build());
        }

        @Override
        public play.api.http.HttpEntity asScala() {
            return new HttpEntity.Chunked(this.chunks.asScala(), (Option<String>)OptionConverters.toScala(this.contentType));
        }
    }

    public static final class Streamed
    extends HttpEntity {
        private final Source<ByteString, ?> data;
        private final Optional<Long> contentLength;
        private final Optional<String> contentType;

        public Streamed(Source<ByteString, ?> source, Optional<Long> optional, Optional<String> optional2) {
            this.data = source;
            this.contentType = optional2;
            this.contentLength = optional;
        }

        public Source<ByteString, ?> data() {
            return this.data;
        }

        @Override
        public Optional<String> contentType() {
            return this.contentType;
        }

        @Override
        public boolean isKnownEmpty() {
            return false;
        }

        @Override
        public Optional<Long> contentLength() {
            return this.contentLength;
        }

        @Override
        public HttpEntity as(String string) {
            return new Streamed(this.data, this.contentLength, Optional.ofNullable(string));
        }

        @Override
        public Source<ByteString, ?> dataStream() {
            return this.data;
        }

        @Override
        public play.api.http.HttpEntity asScala() {
            return new HttpEntity.Streamed(this.data.asScala(), (Option<Object>)OptionConverters.toScala(this.contentLength), (Option<String>)OptionConverters.toScala(this.contentType));
        }
    }

    public static final class Strict
    extends HttpEntity {
        private final ByteString data;
        private final Optional<String> contentType;

        public Strict(ByteString byteString, Optional<String> optional) {
            this.data = byteString;
            this.contentType = optional;
        }

        public ByteString data() {
            return this.data;
        }

        @Override
        public Optional<String> contentType() {
            return this.contentType;
        }

        @Override
        public boolean isKnownEmpty() {
            return this.data.isEmpty();
        }

        @Override
        public Optional<Long> contentLength() {
            return Optional.of(Long.valueOf(this.data.length()));
        }

        @Override
        public HttpEntity as(String string) {
            return new Strict(this.data, Optional.ofNullable(string));
        }

        @Override
        public Source<ByteString, ?> dataStream() {
            return Source.single((Object)this.data);
        }

        @Override
        public play.api.http.HttpEntity asScala() {
            return new HttpEntity.Strict(this.data, (Option<String>)OptionConverters.toScala(this.contentType));
        }
    }
}

