/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import domain.output.FileOutput;
import domain.output.FileOutput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.File;
import java.io.Serializable;
import java.text.Normalizer;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.FolderUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005d\u0001\u0002\u000b\u0016\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006Y\u0001\t\u0005\u0006Y\u0001!\t!\f\u0005\bw\u0001\u0011\r\u0011\"\u0001=\u0011\u0019!\u0006\u0001)A\u0005{!9Q\u000b\u0001b\u0001\n\u00031\u0006BB,\u0001A\u0003%\u0011\nC\u0004Y\u0001\t\u0007I\u0011\u0001,\t\re\u0003\u0001\u0015!\u0003J\u0011\u001dQ\u0006A1A\u0005\u0002YCaa\u0017\u0001!\u0002\u0013I\u0005b\u0002/\u0001\u0005\u0004%\t!\u0018\u0005\u0007O\u0002\u0001\u000b\u0011\u00020\t\u000b!\u0004A\u0011A5\t\u000bm\u0004A\u0011\u0001?\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006!9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0001bBA \u0001\u0011\u0005\u0011\u0011\t\u0005\b\u0003\u0017\u0002A\u0011AA'\u0011\u001d\tI\u0006\u0001C\u0001\u00037\u0012qBR5mKN\u001cuN\u001c;s_2dWM\u001d\u0006\u0002-\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\r\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"!\t\u0016\u000e\u0003\tR!a\t\u0013\u0002\tU$\u0018\u000e\u001c\u0006\u0003K\u0019\n\u0001B]1cE&$X.\u001d\u0006\u0003O!\nq!Y9vCNL8OC\u0001*\u0003\t1'/\u0003\u0002,E\t9Aj\\4Vi&d\u0017A\u0002\u001fj]&$h\bF\u0001/)\ty\u0013\u0007\u0005\u00021\u00015\tQ\u0003C\u0003 \u0005\u0001\u000f\u0001\u0005\u000b\u0002\u0003gA\u0011A'O\u0007\u0002k)\u0011agN\u0001\u0007S:TWm\u0019;\u000b\u0003a\nQA[1wCbL!AO\u001b\u0003\r%s'.Z2u\u0003!1\u0017\u000e\\3SK\u0006$W#A\u001f\u0011\u0007y:\u0015*D\u0001@\u0015\t\u0001\u0015)\u0001\u0003kg>t'B\u0001\"D\u0003\u0011a\u0017NY:\u000b\u0005\u0011+\u0015aA1qS*\ta)\u0001\u0003qY\u0006L\u0018B\u0001%@\u0005\u0015\u0011V-\u00193t!\tQ\u0015K\u0004\u0002L\u001fB\u0011AjG\u0007\u0002\u001b*\u0011ajF\u0001\u0007yI|w\u000e\u001e \n\u0005A[\u0012A\u0002)sK\u0012,g-\u0003\u0002S'\n11\u000b\u001e:j]\u001eT!\u0001U\u000e\u0002\u0013\u0019LG.\u001a*fC\u0012\u0004\u0013\u0001\u00043je\u0016\u001cGo\u001c:z\u000b:4X#A%\u0002\u001b\u0011L'/Z2u_JLXI\u001c<!\u00039\u0001\u0018n\u0019;p\t&\u0014Xm\u0019;pef\fq\u0002]5di>$\u0015N]3di>\u0014\u0018\u0010I\u0001\fkJd\u0007+[2ukJ,7/\u0001\u0007ve2\u0004\u0016n\u0019;ve\u0016\u001c\b%A\bbY2|w/\u0012=uK:\u001c\u0018n\u001c8t+\u0005q\u0006cA0e\u0013:\u0011\u0001M\u0019\b\u0003\u0019\u0006L\u0011\u0001H\u0005\u0003Gn\tq\u0001]1dW\u0006<W-\u0003\u0002fM\n\u00191+Z9\u000b\u0005\r\\\u0012\u0001E1mY><X\t\u001f;f]NLwN\\:!\u0003!9W\r\u001e$jY\u0016\u001cH#B%k_^L\b\"B6\u000e\u0001\u0004a\u0017aB7fgN\fw-\u001a\t\u0003}5L!A\\ \u0003\u000f)\u001bh+\u00197vK\")\u0001/\u0004a\u0001c\u00069\u0001.Z1eKJ\u001c\b\u0003\u0002&s\u0013RL!a]*\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u001bk&\u0011ao\u0007\u0002\u0004\u0003:L\b\"\u0002=\u000e\u0001\u0004I\u0015AB7pIVdW\rC\u0003{\u001b\u0001\u0007\u0011*\u0001\u0003vg\u0016\u0014\u0018\u0001D4fi2\u000b7\u000f\u001e$jY\u0016\u001cHCB%~}~\f\t\u0001C\u0003l\u001d\u0001\u0007A\u000eC\u0003q\u001d\u0001\u0007\u0011\u000fC\u0003y\u001d\u0001\u0007\u0011\nC\u0003{\u001d\u0001\u0007\u0011*A\u0007hKR\u0004\u0016n\u0019;p\r&dWm\u001d\u000b\n\u0013\u0006\u001d\u0011\u0011BA\u0006\u0003\u001bAQa[\bA\u00021DQ\u0001]\bA\u0002EDQ\u0001_\bA\u0002%CQA_\bA\u0002%\u000b!bZ3u\u001fV$\b/\u001e;t)\u0019\t\u0019\"!\n\u0002<A!q\fZA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\taa\\;uaV$(BAA\u0010\u0003\u0019!w.\\1j]&!\u00111EA\r\u0005)1\u0015\u000e\\3PkR\u0004X\u000f\u001e\u0005\b\u0003O\u0001\u0002\u0019AA\u0015\u0003\u0011a\u0017n\u001d;\u0011\t}#\u00171\u0006\t\u0005\u0003[\t9$\u0004\u0002\u00020)!\u0011\u0011GA\u001a\u0003\tIwN\u0003\u0002\u00026\u0005!!.\u0019<b\u0013\u0011\tI$a\f\u0003\t\u0019KG.\u001a\u0005\u0007\u0003{\u0001\u0002\u0019A%\u0002\u0007U\u0014H.\u0001\nhKR|U\u000f\u001e9viN\fE\u000e\u001c$jY\u0016\u001cH\u0003CA\n\u0003\u0007\n)%!\u0013\t\u000f\u0005\u001d\u0012\u00031\u0001\u0002*!1\u0011qI\tA\u0002%\u000bq\u0001[3bI\u0012K'\u000f\u0003\u0004\u0002>E\u0001\r!S\u0001\u0015O\u0016$x*\u001e;qkR\u001c\b+[2u_\u001aKG.Z:\u0015\u0015\u0005M\u0011qJA)\u0003'\n9\u0006C\u0004\u0002(I\u0001\r!!\u000b\t\r\u0005\u001d#\u00031\u0001J\u0011\u0019\t)F\u0005a\u0001\u0013\u0006A\u0001/[2u_\u0012K'\u000f\u0003\u0004\u0002>I\u0001\r!S\u0001\bO\u0016$h*Y7f)\rI\u0015Q\f\u0005\u0007\u0003?\u001a\u0002\u0019A%\u0002\u00119\fW.\u001a$jY\u0016\u0004")
public class FilesController {
    private final LogUtil logUtil;
    private final Reads<String> fileRead;
    private final String directoryEnv;
    private final String pictoDirectory;
    private final String urlPictures;
    private final Seq<String> allowExtensions;

    public Reads<String> fileRead() {
        return this.fileRead;
    }

    public String directoryEnv() {
        return this.directoryEnv;
    }

    public String pictoDirectory() {
        return this.pictoDirectory;
    }

    public String urlPictures() {
        return this.urlPictures;
    }

    public Seq<String> allowExtensions() {
        return this.allowExtensions;
    }

    public String getFiles(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.fileRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get files :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> {
            String string = System.getenv(this.directoryEnv());
            String string2 = System.getenv(this.urlPictures());
            File directory = new File(string);
            Seq<File> listFiles = FolderUtil$.MODULE$.getAllListOfFilesWithExtensions(directory, this.allowExtensions());
            if (listFiles != null) {
                Seq<File> seq = FolderUtil$.MODULE$.getListOfFilesWithExpression(listFiles, (String)code);
                return Json$.MODULE$.toJson(this.getOutputs(seq, string2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
            }
            $this.logUtil.info(new StringBuilder(30).append("No files found in directory : ").append(directory).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson(this.getOutputs((Seq<File>)((Seq)Nil$.MODULE$), string2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
        });
    }

    public String getLastFiles(JsValue message, Map<String, Object> headers, String module, String user) {
        DateTime dateToGetFile;
        String string = System.getenv(this.directoryEnv());
        String string2 = System.getenv(this.urlPictures());
        File directory = new File(string);
        Seq<File> listFiles = FolderUtil$.MODULE$.getAllListOfFilesWithExtensions(directory, this.allowExtensions());
        Seq<File> seq = FolderUtil$.MODULE$.getListFromDate(listFiles, dateToGetFile = new DateTime().minusHours(48));
        if (seq != null) {
            this.logUtil.error(new StringBuilder(18).append("Files found since ").append(dateToGetFile).toString(), this.logUtil.error$default$2());
            return Json$.MODULE$.toJson(this.getOutputsAllFiles(seq, string, string2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
        }
        this.logUtil.error(new StringBuilder(21).append("No files found since ").append(dateToGetFile).toString(), this.logUtil.error$default$2());
        return Json$.MODULE$.toJson(this.getOutputsAllFiles(null, string, string2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
    }

    public String getPictoFiles(JsValue message, Map<String, Object> headers, String module, String user) {
        String string = System.getenv(this.directoryEnv());
        String string2 = System.getenv(this.pictoDirectory());
        String string3 = System.getenv(this.urlPictures());
        File directory = new File(string2);
        Seq<File> listFiles = FolderUtil$.MODULE$.getAllListOfFilesWithExtensions(directory, this.allowExtensions());
        Seq<File> seq = listFiles;
        if (seq != null) {
            this.logUtil.info(new StringBuilder(14).append("Files found : ").append(Json$.MODULE$.toJson(this.getOutputsPictoFiles(seq, string, string2, string3), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString()).toString(), this.logUtil.info$default$2());
            return Json$.MODULE$.toJson(this.getOutputsPictoFiles(seq, string, string2, string3), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
        }
        this.logUtil.info("Files not found", this.logUtil.info$default$2());
        return Json$.MODULE$.toJson(this.getOutputsPictoFiles(null, string, string2, string3), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), FileOutput$.MODULE$.fileOutputWrites())).toString();
    }

    public Seq<FileOutput> getOutputs(Seq<File> list, String url) {
        return (Seq)list.map((Function1 & Serializable)file -> {
            String normalizerName = Normalizer.normalize(file.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            String name = this.getName(normalizerName);
            String string = System.getenv(this.directoryEnv());
            String listPathEnv = file.getAbsolutePath().substring(string.length(), file.getAbsolutePath().length());
            if (!(listPathEnv = listPathEnv.replaceAll("\\\\", "/")).isEmpty()) {
                return new FileOutput(new StringBuilder(0).append(url).append(listPathEnv).toString(), name, file.length(), file.lastModified());
            }
            return new FileOutput(new StringBuilder(0).append(url).append(file.getName()).toString(), name, file.length(), file.lastModified());
        });
    }

    public Seq<FileOutput> getOutputsAllFiles(Seq<File> list, String headDir, String url) {
        if (list != null) {
            return (Seq)list.map((Function1 & Serializable)file -> {
                String string;
                String normalizerName = Normalizer.normalize(file.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
                String name = this.getName(normalizerName);
                boolean bl = file.getPath().contains(headDir);
                if (bl) {
                    String pathFileGet = "";
                    String headDirP = headDir;
                    headDirP = headDirP.replaceAll("\\\\", "/");
                    pathFileGet = file.getPath().substring(headDirP.length(), file.getPath().length());
                    string = pathFileGet = pathFileGet.replaceAll("\\\\", "/");
                } else if (!bl) {
                    string = file.getName();
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                String filePathName = string;
                return new FileOutput(new StringBuilder(0).append(url).append(filePathName).toString(), name, file.length(), file.lastModified());
            });
        }
        return (Seq)Nil$.MODULE$.map((Function1 & Serializable)f -> new FileOutput("", "", 0L, 0L));
    }

    public Seq<FileOutput> getOutputsPictoFiles(Seq<File> list, String headDir, String pictoDir, String url) {
        if (list != null) {
            return (Seq)list.map((Function1 & Serializable)file -> {
                String string;
                String normalizerName = Normalizer.normalize(file.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
                String name = this.getName(normalizerName);
                boolean bl = file.getPath().contains(pictoDir);
                if (bl) {
                    String pathFileGet = "";
                    String headDirP = headDir;
                    headDirP = headDirP.replaceAll("\\\\", "/");
                    pathFileGet = file.getPath().substring(headDirP.length(), file.getPath().length());
                    pathFileGet = pathFileGet.replaceAll("//", "/");
                    string = pathFileGet = pathFileGet.replaceAll("\\\\", "/");
                } else if (!bl) {
                    string = file.getName();
                } else {
                    throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                }
                String filePathName = string;
                return new FileOutput(new StringBuilder(0).append(url).append(filePathName).toString(), name, file.length(), file.lastModified());
            });
        }
        return (Seq)Nil$.MODULE$.map((Function1 & Serializable)f -> new FileOutput("", "", 0L, 0L));
    }

    public String getName(String nameFile) {
        String[] splitName = nameFile.split(".");
        if (splitName.length > 1) {
            String[] splitNameUnderscore = splitName[0].split("_");
            String[] splitNameSpace = splitName[0].split(" ");
            if (splitNameUnderscore.length > 1) {
                return splitNameUnderscore[1];
            }
            if (splitNameSpace.length > 1) {
                return splitNameSpace[1];
            }
            return nameFile;
        }
        return nameFile;
    }

    @Inject
    public FilesController(LogUtil logUtil) {
        this.logUtil = logUtil;
        this.fileRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
        this.directoryEnv = "UPLOAD_DIRECTORY";
        this.pictoDirectory = "PICTO_DIRECTORY";
        this.urlPictures = "URL_UTILS";
        this.allowExtensions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".doc", ".DOC", ".docx", ".DOCX", ".xls", ".XLS", ".xlsx", ".XLSX", ".pdf", ".PDF"}));
    }
}

