/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import dao.StationDao;
import domain.filter.FilterStationInput$;
import fr.aquasys.daeau.quality.itf.UserListDao;
import fr.aquasys.daeau.quality.model.UserList$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import javax.inject.Singleton;
import model.Station$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005m4A!\u0003\u0006\u0001\u001b!AA\u0003\u0001B\u0001B\u0003-Q\u0003\u0003\u0005\"\u0001\t\u0005\t\u0015a\u0003#\u0011!a\u0003A!A!\u0002\u0017i\u0003\"B\u001a\u0001\t\u0003!\u0004b\u0002#\u0001\u0005\u0004%\t!\u0012\u0005\u0007;\u0002\u0001\u000b\u0011\u0002$\t\u000by\u0003A\u0011A0\t\u000bE\u0004A\u0011\u0001:\u0003/\u0019KG\u000e^3s'R\fG/[8o\u0007>tGO]8mY\u0016\u0014(\"A\u0006\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VMZ\u0001\bY><W\u000b^5m!\t1r$D\u0001\u0018\u0015\tA\u0012$\u0001\u0003vi&d'B\u0001\u000e\u001c\u0003!\u0011\u0018M\u00192ji6\f(B\u0001\u000f\u001e\u0003\u001d\t\u0017/^1tsNT\u0011AH\u0001\u0003MJL!\u0001I\f\u0003\u000f1{w-\u0016;jY\u0006YQo]3s\u0019&\u001cH\u000fR1p!\t\u0019#&D\u0001%\u0015\t)c%A\u0002ji\u001aT!a\n\u0015\u0002\u000fE,\u0018\r\\5us*\u0011\u0011fG\u0001\u0006I\u0006,\u0017-^\u0005\u0003W\u0011\u00121\"V:fe2K7\u000f\u001e#b_\u0006Q1\u000f^1uS>tG)Y8\u0011\u00059\nT\"A\u0018\u000b\u0003A\n1\u0001Z1p\u0013\t\u0011tF\u0001\u0006Ti\u0006$\u0018n\u001c8EC>\fa\u0001P5oSRtD#A\u001b\u0015\tYB\u0014H\u000f\t\u0003o\u0001i\u0011A\u0003\u0005\u0006)\u0011\u0001\u001d!\u0006\u0005\u0006C\u0011\u0001\u001dA\t\u0005\u0006Y\u0011\u0001\u001d!\f\u0015\u0003\tq\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\r%t'.Z2u\u0015\u0005\t\u0015!\u00026bm\u0006D\u0018BA\"?\u0005\u0019IeN[3di\u00069\u0011\u000eZ:SK\u0006$W#\u0001$\u0011\u0007\u001d\u0003&+D\u0001I\u0015\tI%*\u0001\u0003kg>t'BA&M\u0003\u0011a\u0017NY:\u000b\u00055s\u0015aA1qS*\tq*\u0001\u0003qY\u0006L\u0018BA)I\u0005\u0015\u0011V-\u00193t!\t\u0019&L\u0004\u0002U1B\u0011Q\u000bE\u0007\u0002-*\u0011q\u000bD\u0001\u0007yI|w\u000e\u001e \n\u0005e\u0003\u0012A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\t\u0002\u0011%$7OU3bI\u0002\n!bZ3u\r&dG/\u001a:t)\u0015\u0011\u0006-Z7p\u0011\u0015\tw\u00011\u0001c\u0003\u001diWm]:bO\u0016\u0004\"aR2\n\u0005\u0011D%a\u0002&t-\u0006dW/\u001a\u0005\u0006M\u001e\u0001\raZ\u0001\bQ\u0016\fG-\u001a:t!\u0011\u0019\u0006N\u00156\n\u0005%d&aA'baB\u0011qb[\u0005\u0003YB\u00111!\u00118z\u0011\u0015qw\u00011\u0001S\u0003\u0019iw\u000eZ;mK\")\u0001o\u0002a\u0001%\u0006!Qo]3s\u000399W\r\u001e\"z/\u0006$XM]:iK\u0012$RAU:ukZDQ!\u0019\u0005A\u0002\tDQA\u001a\u0005A\u0002\u001dDQA\u001c\u0005A\u0002ICQ\u0001\u001d\u0005A\u0002IC#\u0001\u0001=\u0011\u0005uJ\u0018B\u0001>?\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class FilterStationController {
    private final LogUtil logUtil;
    private final UserListDao userListDao;
    private final StationDao stationDao;
    private final Reads<String> idsRead;

    public Reads<String> idsRead() {
        return this.idsRead;
    }

    public String getFilters(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(FilterStationInput$.MODULE$.filterStationReads()).fold((Function1 & Serializable)e -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to get station filters:\n").append(JsError$.MODULE$.toJson(e).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)filter -> Json$.MODULE$.toJson((Object)$this.userListDao.findByLogin(filter.login(), filter.module()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UserList$.MODULE$.writes())).toString());
    }

    public String getByWatershed(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(38).append("Error while reading watershed input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> Json$.MODULE$.toJson($this.stationDao.getByWatershed((String)input), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Station$.MODULE$.stationWrites())).toString());
    }

    @Inject
    public FilterStationController(LogUtil logUtil, UserListDao userListDao, StationDao stationDao) {
        this.logUtil = logUtil;
        this.userListDao = userListDao;
        this.stationDao = stationDao;
        this.idsRead = JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.StringReads());
    }
}

