/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import dao.searchAnalysis.itf.OperationDao;
import dao.searchAnalysis.itf.SampleDao;
import fr.aquasys.daeau.quality.operation.QualityOperation;
import fr.aquasys.daeau.quality.operation.QualityOperation$;
import fr.aquasys.rabbitmq.api.LogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005%a\u0001\u0002\u0006\f\u00019A\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006YA\u0006\u0005\tA\u0001\u0011\t\u0011)A\u0006C!AA\u0005\u0001B\u0001B\u0003-Q\u0005C\u00032\u0001\u0011\u0005!\u0007C\u0004C\u0001\t\u0007I\u0011A\"\t\re\u0003\u0001\u0015!\u0003E\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015A\b\u0001\"\u0001z\u0011\u0015q\b\u0001\"\u0001\u0000\u0005My\u0005/\u001a:bi&|gnQ8oiJ|G\u000e\\3s\u0015\u0005a\u0011aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001a\u0005\u0002\u0001\u001fA\u0011\u0001cE\u0007\u0002#)\t!#A\u0003tG\u0006d\u0017-\u0003\u0002\u0015#\t1\u0011I\\=SK\u001a\fAb\u001c9fe\u0006$\u0018n\u001c8EC>\u0004\"a\u0006\u0010\u000e\u0003aQ!!\u0007\u000e\u0002\u0007%$hM\u0003\u0002\u001c9\u0005q1/Z1sG\"\fe.\u00197zg&\u001c(\"A\u000f\u0002\u0007\u0011\fw.\u0003\u0002 1\taq\n]3sCRLwN\u001c#b_\u0006I1/Y7qY\u0016$\u0015m\u001c\t\u0003/\tJ!a\t\r\u0003\u0013M\u000bW\u000e\u001d7f\t\u0006|\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003M=j\u0011a\n\u0006\u0003Q%\nA!\u001e;jY*\u0011!fK\u0001\te\u0006\u0014'-\u001b;nc*\u0011A&L\u0001\bCF,\u0018m]=t\u0015\u0005q\u0013A\u00014s\u0013\t\u0001tEA\u0004M_\u001e,F/\u001b7\u0002\rqJg.\u001b;?)\u0005\u0019D\u0003\u0002\u001b7oa\u0002\"!\u000e\u0001\u000e\u0003-AQ!\u0006\u0003A\u0004YAQ\u0001\t\u0003A\u0004\u0005BQ\u0001\n\u0003A\u0004\u0015B#\u0001\u0002\u001e\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014AB5oU\u0016\u001cGOC\u0001@\u0003\u0015Q\u0017M^1y\u0013\t\tEH\u0001\u0004J]*,7\r^\u0001\u000f_B,'/\u0019;j_:\u0014V-\u00193t+\u0005!\u0005cA#O!6\taI\u0003\u0002H\u0011\u0006!!n]8o\u0015\tI%*\u0001\u0003mS\n\u001c(BA&M\u0003\r\t\u0007/\u001b\u0006\u0002\u001b\u0006!\u0001\u000f\\1z\u0013\tyeIA\u0003SK\u0006$7\u000f\u0005\u0003\u0011#N3\u0016B\u0001*\u0012\u0005\u0019!V\u000f\u001d7feA\u0011\u0001\u0003V\u0005\u0003+F\u00111!\u00138u!\t\u0001r+\u0003\u0002Y#\t1Ai\\;cY\u0016\fqb\u001c9fe\u0006$\u0018n\u001c8SK\u0006$7\u000fI\u0001\rO\u0016$x\n]3sCRLwN\u001c\u000b\u00069\u001edGO\u001e\t\u0003;\u0012t!A\u00182\u0011\u0005}\u000bR\"\u00011\u000b\u0005\u0005l\u0011A\u0002\u001fs_>$h(\u0003\u0002d#\u00051\u0001K]3eK\u001aL!!\u001a4\u0003\rM#(/\u001b8h\u0015\t\u0019\u0017\u0003C\u0003i\u000f\u0001\u0007\u0011.A\u0004nKN\u001c\u0018mZ3\u0011\u0005\u0015S\u0017BA6G\u0005\u001dQ5OV1mk\u0016DQ!\\\u0004A\u00029\fq\u0001[3bI\u0016\u00148\u000f\u0005\u0003^_r\u000b\u0018B\u00019g\u0005\ri\u0015\r\u001d\t\u0003!IL!a]\t\u0003\u0007\u0005s\u0017\u0010C\u0003v\u000f\u0001\u0007A,\u0001\u0004n_\u0012,H.\u001a\u0005\u0006o\u001e\u0001\r\u0001X\u0001\u0005kN,'/\u0001\u0004hKR\fE\u000e\u001c\u000b\u00069j\\H0 \u0005\u0006Q\"\u0001\r!\u001b\u0005\u0006[\"\u0001\rA\u001c\u0005\u0006k\"\u0001\r\u0001\u0018\u0005\u0006o\"\u0001\r\u0001X\u0001\u000eO\u0016$\u0018\t\u001c7XSRD\u0017\nZ:\u0015\u0013q\u000b\t!a\u0001\u0002\u0006\u0005\u001d\u0001\"\u00025\n\u0001\u0004I\u0007\"B7\n\u0001\u0004q\u0007\"B;\n\u0001\u0004a\u0006\"B<\n\u0001\u0004a\u0006")
public class OperationController {
    private final OperationDao operationDao;
    private final Reads<Tuple2<Object, Object>> operationReads;

    public Reads<Tuple2<Object, Object>> operationReads() {
        return this.operationReads;
    }

    public String getOperation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.operationReads()).fold((Function1 & Serializable)error -> {
            LogUtil$.MODULE$.error(new StringBuilder(39).append("Error validate Json to get operation :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)operation -> {
            Option<QualityOperation> option = $this.operationDao.find(operation._1$mcI$sp(), operation._2$mcD$sp());
            if (option instanceof Some) {
                Some some = (Some)option;
                QualityOperation operationResult = (QualityOperation)some.value();
                LogUtil$.MODULE$.info(new StringBuilder(29).append("Operation ").append(operation._1$mcI$sp()).append(" found for station ").append(operation._2$mcD$sp()).toString(), LogUtil$.MODULE$.info$default$2());
                return Json$.MODULE$.toJson((Object)operationResult, (Writes)QualityOperation$.MODULE$.format()).toString();
            }
            if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.error(new StringBuilder(21).append("Operation ").append(operation._1$mcI$sp()).append(" not found ").append(operation._2$mcD$sp()).toString(), LogUtil$.MODULE$.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        });
    }

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.operationDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualityOperation$.MODULE$.format())).toString();
    }

    public String getAllWithIds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)CommonReadUtil$.MODULE$.idsRead()).fold((Function1 & Serializable)error -> {
            LogUtil$.MODULE$.error(new StringBuilder(41).append("Error validate Json to get station ids :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)ids -> Json$.MODULE$.toJson($this.operationDao.getAll((Seq<Object>)((Seq)ids.map((Function1)(JFunction1.mcDI.sp & Serializable)x$1 -> x$1))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualityOperation$.MODULE$.format())).toString());
    }

    @Inject
    public OperationController(OperationDao operationDao, SampleDao sampleDao, LogUtil logUtil) {
        this.operationDao = operationDao;
        this.operationReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.DoubleReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

