/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import domain.output.PictureOutput;
import domain.output.PictureOutput$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.File;
import java.io.Serializable;
import java.text.Normalizer;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.FolderUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001db\u0001\u0002\t\u0012\u0001QA\u0001b\u0007\u0001\u0003\u0002\u0003\u0006Y\u0001\b\u0005\u0006Q\u0001!\t!\u000b\u0005\bo\u0001\u0011\r\u0011\"\u00019\u0011\u0019\u0001\u0006\u0001)A\u0005s!9\u0011\u000b\u0001b\u0001\n\u0003\u0011\u0006BB*\u0001A\u0003%Q\tC\u0004U\u0001\t\u0007I\u0011\u0001*\t\rU\u0003\u0001\u0015!\u0003F\u0011\u001d1\u0006A1A\u0005\u0002ICaa\u0016\u0001!\u0002\u0013)\u0005b\u0002-\u0001\u0005\u0004%\t!\u0017\u0005\u0007G\u0002\u0001\u000b\u0011\u0002.\t\u000b\u0011\u0004A\u0011A3\t\u000b]\u0004A\u0011\u0001=\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\t\u0011\u0002+[2ukJ,7oQ8oiJ|G\u000e\\3s\u0015\u0005\u0011\u0012aC2p]R\u0014x\u000e\u001c7feN\u001c\u0001a\u0005\u0002\u0001+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t1\u0011I\\=SK\u001a\fq\u0001\\8h+RLG\u000e\u0005\u0002\u001eM5\taD\u0003\u0002 A\u0005!Q\u000f^5m\u0015\t\t#%\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\t\u0019C%A\u0004bcV\f7/_:\u000b\u0003\u0015\n!A\u001a:\n\u0005\u001dr\"a\u0002'pOV#\u0018\u000e\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003)\"\"aK\u0017\u0011\u00051\u0002Q\"A\t\t\u000bm\u0011\u00019\u0001\u000f)\u0005\ty\u0003C\u0001\u00196\u001b\u0005\t$B\u0001\u001a4\u0003\u0019IgN[3di*\tA'A\u0003kCZ\f\u00070\u0003\u00027c\t1\u0011J\u001c6fGR\f1\u0002]5diV\u0014XMU3bIV\t\u0011\bE\u0002;\u0007\u0016k\u0011a\u000f\u0006\u0003yu\nAA[:p]*\u0011ahP\u0001\u0005Y&\u00147O\u0003\u0002A\u0003\u0006\u0019\u0011\r]5\u000b\u0003\t\u000bA\u0001\u001d7bs&\u0011Ai\u000f\u0002\u0006%\u0016\fGm\u001d\t\u0003\r6s!aR&\u0011\u0005!;R\"A%\u000b\u0005)\u001b\u0012A\u0002\u001fs_>$h(\u0003\u0002M/\u00051\u0001K]3eK\u001aL!AT(\u0003\rM#(/\u001b8h\u0015\tau#\u0001\u0007qS\u000e$XO]3SK\u0006$\u0007%\u0001\u0007eSJ,7\r^8ss\u0016sg/F\u0001F\u00035!\u0017N]3di>\u0014\u00180\u00128wA\u0005qA-\u001b:QS\u000e$XO]3t\u000b:4\u0018a\u00043jeBK7\r^;sKN,eN\u001e\u0011\u0002\u0017U\u0014H\u000eU5diV\u0014Xm]\u0001\rkJd\u0007+[2ukJ,7\u000fI\u0001\u0010C2dwn^#yi\u0016t7/[8ogV\t!\fE\u0002\\A\u0016s!\u0001\u00180\u000f\u0005!k\u0016\"\u0001\r\n\u0005};\u0012a\u00029bG.\fw-Z\u0005\u0003C\n\u00141aU3r\u0015\tyv#\u0001\tbY2|w/\u0012=uK:\u001c\u0018n\u001c8tA\u0005Yq-\u001a;QS\u000e$XO]3t)\u0015)em[:v\u0011\u00159W\u00021\u0001i\u0003\u001diWm]:bO\u0016\u0004\"AO5\n\u0005)\\$a\u0002&t-\u0006dW/\u001a\u0005\u0006Y6\u0001\r!\\\u0001\bQ\u0016\fG-\u001a:t!\u00111e.\u00129\n\u0005=|%aA'baB\u0011a#]\u0005\u0003e^\u00111!\u00118z\u0011\u0015!X\u00021\u0001F\u0003\u0019iw\u000eZ;mK\")a/\u0004a\u0001\u000b\u0006!Qo]3s\u0003)9W\r^(viB,Ho\u001d\u000b\u0006s\u0006\u0015\u00111\u0004\t\u00047\u0002T\bcA>\u0002\u00025\tAP\u0003\u0002~}\u00061q.\u001e;qkRT\u0011a`\u0001\u0007I>l\u0017-\u001b8\n\u0007\u0005\rAPA\u0007QS\u000e$XO]3PkR\u0004X\u000f\u001e\u0005\b\u0003\u000fq\u0001\u0019AA\u0005\u0003\u0011a\u0017n\u001d;\u0011\tm\u0003\u00171\u0002\t\u0005\u0003\u001b\t9\"\u0004\u0002\u0002\u0010)!\u0011\u0011CA\n\u0003\tIwN\u0003\u0002\u0002\u0016\u0005!!.\u0019<b\u0013\u0011\tI\"a\u0004\u0003\t\u0019KG.\u001a\u0005\u0007\u0003;q\u0001\u0019A#\u0002\u0007U\u0014H.A\u0004hKRt\u0015-\\3\u0015\u0007\u0015\u000b\u0019\u0003\u0003\u0004\u0002&=\u0001\r!R\u0001\t]\u0006lWMR5mK\u0002")
public class PicturesController {
    private final LogUtil logUtil;
    private final Reads<String> pictureRead;
    private final String directoryEnv;
    private final String dirPicturesEnv;
    private final String urlPictures;
    private final Seq<String> allowExtensions;

    public Reads<String> pictureRead() {
        return this.pictureRead;
    }

    public String directoryEnv() {
        return this.directoryEnv;
    }

    public String dirPicturesEnv() {
        return this.dirPicturesEnv;
    }

    public String urlPictures() {
        return this.urlPictures;
    }

    public Seq<String> allowExtensions() {
        return this.allowExtensions;
    }

    public String getPictures(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.pictureRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to get pictures :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> {
            String string = System.getenv(this.dirPicturesEnv());
            String string2 = System.getenv(this.urlPictures());
            File directory = new File(string);
            Seq<File> listFiles = FolderUtil$.MODULE$.getListOfFilesWithExtensions(directory, this.allowExtensions());
            if (listFiles != null) {
                Seq<File> seq = FolderUtil$.MODULE$.getListOfFilesWithExpression(listFiles, (String)code);
                return Json$.MODULE$.toJson(this.getOutputs(seq, string2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), PictureOutput$.MODULE$.pictureOutputWrites())).toString();
            }
            $this.logUtil.info(new StringBuilder(30).append("No files found in directory : ").append(directory).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson(this.getOutputs((Seq<File>)((Seq)Nil$.MODULE$), string2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), PictureOutput$.MODULE$.pictureOutputWrites())).toString();
        });
    }

    public Seq<PictureOutput> getOutputs(Seq<File> list, String url) {
        return (Seq)list.map((Function1 & Serializable)file -> {
            $this.logUtil.info(new StringBuilder(7).append("File : ").append(file.getAbsolutePath()).toString(), $this.logUtil.info$default$2());
            String normalizerName = Normalizer.normalize(file.getName().toLowerCase(), Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "");
            String name = this.getName(normalizerName);
            String string = System.getenv(this.directoryEnv());
            String listPathEnv = file.getAbsolutePath().substring(string.length(), file.getAbsolutePath().length());
            listPathEnv = listPathEnv.replaceAll("\\\\", "/");
            if (!listPathEnv.isEmpty()) {
                return new PictureOutput(new StringBuilder(0).append(url).append(listPathEnv).toString(), name, file.length(), file.lastModified());
            }
            return new PictureOutput(new StringBuilder(0).append(url).append(file.getName()).toString(), name, file.length(), file.lastModified());
        });
    }

    public String getName(String nameFile) {
        String[] splitName = nameFile.split(".");
        if (splitName.length > 1) {
            String[] splitNameUnderscore = splitName[0].split("_");
            String[] splitNameSpace = splitName[0].split(" ");
            if (splitNameUnderscore.length > 1) {
                return splitNameUnderscore[1];
            }
            if (splitNameSpace.length > 1) {
                return splitNameSpace[1];
            }
            return nameFile;
        }
        return nameFile;
    }

    @Inject
    public PicturesController(LogUtil logUtil) {
        this.logUtil = logUtil;
        this.pictureRead = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
        this.directoryEnv = "UPLOAD_DIRECTORY";
        this.dirPicturesEnv = "PICTURES_DIRECTORY";
        this.urlPictures = "URL_UTILS";
        this.allowExtensions = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".jpg", ".JPG", ".jpeg", ".JPEG", ".png", ".PNG", ".gif", ".GIF", ".img", ".IMG", ".jpe", ".JPE", ".bmp", ".BMP", ".tif", ".TIF"}));
    }
}

