/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import controllers.PiezometerController$;
import fr.aquasys.constants.StationTypeConstants$;
import fr.aquasys.daeau.piezometry.domain.PiezometerLinks;
import fr.aquasys.daeau.piezometry.domain.PiezometerLinks$;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks;
import fr.aquasys.daeau.piezometry.domain.PiezometerWithLinks$;
import fr.aquasys.daeau.piezometry.domain.input.ContributorLinkInput$;
import fr.aquasys.daeau.piezometry.itf.PiezometerControl;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.piezometry.itf.PiezometerSituationDao;
import fr.aquasys.daeau.piezometry.model.Piezometer;
import fr.aquasys.daeau.piezometry.model.Piezometer$;
import fr.aquasys.daeau.piezometry.model.PiezometerCode$;
import fr.aquasys.daeau.piezometry.model.PiezometerGeo$;
import fr.aquasys.daeau.piezometry.model.situation.PiezoChronicSituation;
import fr.aquasys.daeau.quality.domain.Station;
import fr.aquasys.daeau.quality.domain.Station$;
import fr.aquasys.daeau.quality.domain.output.StationOutput$;
import fr.aquasys.daeau.station.domain.input.GetAllQueryParams;
import fr.aquasys.daeau.station.domain.input.GetAllQueryParams$;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities$;
import fr.aquasys.daeau.station.links.accessibilities.StationAccessibilitiesDao;
import fr.aquasys.daeau.station.links.altimetrySystem.AltimetrySystem$;
import fr.aquasys.daeau.station.links.altimetrySystem.StationAltimetrySystemDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink$;
import fr.aquasys.daeau.station.links.landmark.Landmark$;
import fr.aquasys.daeau.station.links.landmark.StationLandmarkDao;
import fr.aquasys.daeau.station.links.watermass.StationWatermassCoordinates;
import fr.aquasys.daeau.station.links.watermass.StationWatermassDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.api.LogUtil$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.api.application.constants.StatisticEventTypeConstants$;
import fr.aquasys.rabbitmq.api.application.constants.StatisticModuleConstants$;
import fr.aquasys.rabbitmq.api.application.utils.SwaggerUtil;
import fr.aquasys.rabbitmq.api.application.utils.SwaggerUtil$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.rabbitmq.util.StatUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsNumber;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.math.BigDecimal$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\rUf\u0001\u0002\u001d:\u0001qB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006Y\u0001\u0015\u0005\t9\u0002\u0011\t\u0011)A\u0006;\"A1\r\u0001B\u0001B\u0003-A\r\u0003\u0005k\u0001\t\u0005\t\u0015a\u0003l\u0011!\u0019\bA!A!\u0002\u0017!\b\u0002\u0003>\u0001\u0005\u0003\u0005\u000b1B>\t\u0015\u0005\u0015\u0001A!A!\u0002\u0017\t9\u0001\u0003\u0006\u0002\u000e\u0001\u0011\t\u0011)A\u0006\u0003\u001fA\u0011\"a\u0007\u0001\u0005\u0003\u0005\u000b1\u0002;\t\u0015\u0005u\u0001A!A!\u0002\u0017\ty\u0002\u0003\u0006\u0002&\u0001\u0011\t\u0011)A\u0006\u0003OA!\"!\f\u0001\u0005\u0003\u0005\u000b1BA\u0018\u0011)\tY\u0004\u0001B\u0001B\u0003-\u0011Q\b\u0005\b\u0003\u0007\u0002A\u0011AA#\u0011%\tI\b\u0001b\u0001\n\u0003\tY\b\u0003\u0005\u00020\u0002\u0001\u000b\u0011BA?\u0011%\t\t\f\u0001b\u0001\n\u0003\t\u0019\f\u0003\u0005\u0002>\u0002\u0001\u000b\u0011BA[\u0011%\ty\f\u0001b\u0001\n\u0003\t\t\r\u0003\u0005\u0002j\u0002\u0001\u000b\u0011BAb\u0011%\tY\u000f\u0001b\u0001\n\u0003\ti\u000f\u0003\u0005\u0002r\u0002\u0001\u000b\u0011BAx\u0011%\t\u0019\u0010\u0001b\u0001\n\u0003\t)\u0010\u0003\u0005\u0003,\u0001\u0001\u000b\u0011BA|\u0011%\u0011i\u0003\u0001b\u0001\n\u0003\u0011y\u0003\u0003\u0005\u0003H\u0001\u0001\u000b\u0011\u0002B\u0019\u0011%\u0011I\u0005\u0001b\u0001\n\u0003\u0011Y\u0005\u0003\u0005\u0003\\\u0001\u0001\u000b\u0011\u0002B'\u0011%\u0011i\u0006\u0001b\u0001\n\u0003\u0011y\u0006\u0003\u0005\u0003n\u0001\u0001\u000b\u0011\u0002B1\u0011\u001d\u0011y\u0007\u0001C\u0001\u0005cBqAa%\u0001\t\u0003\u0011)\nC\u0004\u0003 \u0002!\tA!)\t\u000f\t-\u0006\u0001\"\u0001\u0003.\"9!q\u0017\u0001\u0005\u0002\te\u0006b\u0002Bc\u0001\u0011\u0005!q\u0019\u0005\b\u0005#\u0004A\u0011\u0001Bj\u0011\u001d\u0011i\u000e\u0001C\u0001\u0005?DqA!;\u0001\t\u0003\u0011Y\u000fC\u0004\u0003v\u0002!\tAa>\t\u000f\r\u0005\u0001\u0001\"\u0001\u0004\u0004!91Q\u0002\u0001\u0005\u0002\r=\u0001bBB\r\u0001\u0011\u000511\u0004\u0005\b\u0007K\u0001A\u0011AB\u0014\u0011\u001d\u0019\t\u0004\u0001C\u0001\u0007gAqa!\u0010\u0001\t\u0003\u0019y\u0004C\u0004\u0004J\u0001!\taa\u0013\t\u000f\rU\u0003\u0001\"\u0001\u0004X!91\u0011\r\u0001\u0005\u0002\r\r\u0004bBB7\u0001\u0011\u00051q\u000e\u0005\b\u0007s\u0002A\u0011AB>\u0011\u001d\u0019)\t\u0001C\u0001\u0007\u000fCqa!%\u0001\t\u0003\u0019\u0019\nC\u0004\u0004\u001e\u0002!\taa(\t\u000f\r%\u0006\u0001\"\u0001\u0004,\n!\u0002+[3{_6,G/\u001a:D_:$(o\u001c7mKJT\u0011AO\u0001\fG>tGO]8mY\u0016\u00148o\u0001\u0001\u0014\u0007\u0001i4\t\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0004B]f\u0014VM\u001a\t\u0003\t6k\u0011!\u0012\u0006\u0003\r\u001e\u000b1!\u00199j\u0015\tA\u0015*\u0001\u0005sC\n\u0014\u0017\u000e^7r\u0015\tQ5*A\u0004bcV\f7/_:\u000b\u00031\u000b!A\u001a:\n\u00059+%\u0001\u0003)s_\u0012,8-\u001a:\u0002%\u0005dG/[7fiJL8+_:uK6$\u0015m\u001c\t\u0003#jk\u0011A\u0015\u0006\u0003'R\u000bq\"\u00197uS6,GO]=TsN$X-\u001c\u0006\u0003+Z\u000bQ\u0001\\5oWNT!a\u0016-\u0002\u000fM$\u0018\r^5p]*\u0011\u0011,S\u0001\u0006I\u0006,\u0017-^\u0005\u00037J\u0013\u0011d\u0015;bi&|g.\u00117uS6,GO]=TsN$X-\u001c#b_\u0006\t\u0012mY2fgNL'-\u001b7ji\u0016\u001cH)Y8\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0016aD1dG\u0016\u001c8/\u001b2jY&$\u0018.Z:\n\u0005\t|&!G*uCRLwN\\!dG\u0016\u001c8/\u001b2jY&$\u0018.Z:EC>\f1\u0002\\1oI6\f'o\u001b#b_B\u0011Q\r[\u0007\u0002M*\u0011q\rV\u0001\tY\u0006tG-\\1sW&\u0011\u0011N\u001a\u0002\u0013'R\fG/[8o\u0019\u0006tG-\\1sW\u0012\u000bw.A\bqS\u0016Tx.\\3uKJ$\u0015-Z1v!\ta\u0017/D\u0001n\u0015\tqw.A\u0002ji\u001aT!\u0001\u001d-\u0002\u0015ALWM_8nKR\u0014\u00180\u0003\u0002s[\ny\u0001+[3{_6,G/\u001a:EC\u0016\fW/\u0001\u000fqS\u0016Tx.\\3uKJ\u001cuN\u001c;sS\n,Ho\u001c:MS:\\G)Y8\u0011\u0005UDX\"\u0001<\u000b\u0005]$\u0016aC2p]R\u0014\u0018NY;u_JL!!\u001f<\u0003+M#\u0018\r^5p]\u000e{g\u000e\u001e:jEV$xN\u001d#b_\u00069Qo]3s\t\u0006|\u0007c\u0001?\u0002\u00025\tQP\u0003\u0002o}*\u0011q\u0010W\u0001\u0005kN,'/C\u0002\u0002\u0004u\u0014q!V:fe\u0012\u000bw.\u0001\bvg\u0016\u00148\u000b^1uS>tG)Y8\u0011\u0007q\fI!C\u0002\u0002\fu\u0014a\"V:feN#\u0018\r^5p]\u0012\u000bw.A\u000bxCR,'/T1tg2Kgn\u001b)jKj|G)Y8\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006U\u0003%9\u0018\r^3s[\u0006\u001c8/\u0003\u0003\u0002\u001a\u0005M!aE*uCRLwN\\,bi\u0016\u0014X.Y:t\t\u0006|\u0017!F:uCRLwN\\\"p]R\u0014\u0018NY;u_J$\u0015m\\\u0001\u0017!&,'p\\7fi\u0016\u00148+\u001b;vCRLwN\u001c#b_B\u0019A.!\t\n\u0007\u0005\rRN\u0001\fQS\u0016Tx.\\3uKJ\u001c\u0016\u000e^;bi&|g\u000eR1p\u0003E\u0001\u0016.\u001a>p[\u0016$XM]\"p]R\u0014x\u000e\u001c\t\u0004Y\u0006%\u0012bAA\u0016[\n\t\u0002+[3{_6,G/\u001a:D_:$(o\u001c7\u0002\u000f1|w-\u0016;jYB!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026\u001d\u000bA!\u001e;jY&!\u0011\u0011HA\u001a\u0005\u001daunZ+uS2\f\u0001b\u001d;biV#\u0018\u000e\u001c\t\u0005\u0003c\ty$\u0003\u0003\u0002B\u0005M\"\u0001C*uCR,F/\u001b7\u0002\rqJg.\u001b;?)\t\t9\u0005\u0006\u000f\u0002J\u00055\u0013qJA)\u0003'\n)&a\u0016\u0002Z\u0005m\u0013QLA0\u0003C\n\u0019'!\u001a\u0011\u0007\u0005-\u0003!D\u0001:\u0011\u0015ye\u0002q\u0001Q\u0011\u0015af\u0002q\u0001^\u0011\u0015\u0019g\u0002q\u0001e\u0011\u0015Qg\u0002q\u0001l\u0011\u0015\u0019h\u0002q\u0001u\u0011\u0015Qh\u0002q\u0001|\u0011\u001d\t)A\u0004a\u0002\u0003\u000fAq!!\u0004\u000f\u0001\b\ty\u0001\u0003\u0004\u0002\u001c9\u0001\u001d\u0001\u001e\u0005\b\u0003;q\u00019AA\u0010\u0011\u001d\t)C\u0004a\u0002\u0003OAq!!\f\u000f\u0001\b\ty\u0003C\u0004\u0002<9\u0001\u001d!!\u0010)\u00079\tI\u0007\u0005\u0003\u0002l\u0005UTBAA7\u0015\u0011\ty'!\u001d\u0002\r%t'.Z2u\u0015\t\t\u0019(A\u0003kCZ\f\u00070\u0003\u0003\u0002x\u00055$AB%oU\u0016\u001cG/A\nvg\u0016\u0014(+Z1eg^KG\u000f['pIVdW-\u0006\u0002\u0002~A1\u0011qPAH\u0003'k!!!!\u000b\t\u0005\r\u0015QQ\u0001\u0005UN|gN\u0003\u0003\u0002\b\u0006%\u0015\u0001\u00027jENT1ARAF\u0015\t\ti)\u0001\u0003qY\u0006L\u0018\u0002BAI\u0003\u0003\u0013QAU3bIN\u0004rAPAK\u00033\u000bI*C\u0002\u0002\u0018~\u0012a\u0001V;qY\u0016\u0014\u0004\u0003BAN\u0003SsA!!(\u0002&B\u0019\u0011qT \u000e\u0005\u0005\u0005&bAARw\u00051AH]8pizJ1!a*@\u0003\u0019\u0001&/\u001a3fM&!\u00111VAW\u0005\u0019\u0019FO]5oO*\u0019\u0011qU \u0002)U\u001cXM\u001d*fC\u0012\u001cx+\u001b;i\u001b>$W\u000f\\3!\u0003E\u0001\u0018.\u001a>p[\u0016$XM]%e%\u0016\fGm]\u000b\u0003\u0003k\u0003b!a \u0002\u0010\u0006]\u0006c\u0001 \u0002:&\u0019\u00111X \u0003\u0007%sG/\u0001\nqS\u0016Tx.\\3uKJLEMU3bIN\u0004\u0013A\u00059jKj|W.\u001a;fe&#7OU3bIN,\"!a1\u0011\r\u0005}\u0014qRAc!-q\u0014qYAM\u0003\u0017\fi.!'\n\u0007\u0005%wH\u0001\u0004UkBdW\r\u000e\t\u0007\u0003\u001b\f9.a.\u000f\t\u0005=\u00171\u001b\b\u0005\u0003?\u000b\t.C\u0001A\u0013\r\t)nP\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\tI.a7\u0003\u0007M+\u0017OC\u0002\u0002V~\u0002RAPAp\u0003GL1!!9@\u0005\u0019y\u0005\u000f^5p]B\u0019a(!:\n\u0007\u0005\u001dxHA\u0004C_>dW-\u00198\u0002'ALWM_8nKR,'/\u00133t%\u0016\fGm\u001d\u0011\u0002'ALWM_8nKR,'oQ8eKJ+\u0017\rZ:\u0016\u0005\u0005=\bCBA@\u0003\u001f\u000bI*\u0001\u000bqS\u0016Tx.\\3uKJ\u001cu\u000eZ3SK\u0006$7\u000fI\u0001\u0016a&,'p\\7fi\u0016\u0014\u0018\nZ+tKJ\u0014V-\u00193t+\t\t9\u0010\u0005\u0004\u0002z\n}!Q\u0005\b\u0005\u0003w\u0014IB\u0004\u0003\u0002~\nMa\u0002BA\u0000\u0005\u001fqAA!\u0001\u0003\u000e9!!1\u0001B\u0006\u001d\u0011\u0011)A!\u0003\u000f\t\u0005}%qA\u0005\u0002\u0019&\u0011!jS\u0005\u0003\u0011&K!AR$\n\u0007\tEQ)A\u0006baBd\u0017nY1uS>t\u0017\u0002\u0002B\u000b\u0005/\tQ!\u001e;jYNT1A!\u0005F\u0013\u0011\u0011YB!\b\u0002\u0017M;\u0018mZ4feV#\u0018\u000e\u001c\u0006\u0005\u0005+\u00119\"\u0003\u0003\u0003\"\t\r\"\u0001D*xC\u001e<WM\u001d*fC\u0012\u001c(\u0002\u0002B\u000e\u0005;\u0001\u0012B\u0010B\u0014\u00033\u000b9,!'\n\u0007\t%rH\u0001\u0004UkBdWmM\u0001\u0017a&,'p\\7fi\u0016\u0014\u0018\nZ+tKJ\u0014V-\u00193tA\u0005I\u0002/[3{_6,G/\u001a:QCJ\fWn]+tKJ\u0014V-\u00193t+\t\u0011\t\u0004\u0005\u0004\u0002z\n}!1\u0007\t\n}\t\u001d\u0012\u0011\u0014B\u001b\u00033\u0003RAPAp\u0005o\u0001BA!\u000f\u0003D5\u0011!1\b\u0006\u0005\u0005{\u0011y$A\u0003j]B,HOC\u0002\u0003BY\u000ba\u0001Z8nC&t\u0017\u0002\u0002B#\u0005w\u0011\u0011cR3u\u00032d\u0017+^3ssB\u000b'/Y7t\u0003i\u0001\u0018.\u001a>p[\u0016$XM\u001d)be\u0006l7/V:feJ+\u0017\rZ:!\u0003%a\u0017N\\6t%\u0016\fG-\u0006\u0002\u0003NA1\u0011qPAH\u0005\u001f\u0002rAPAK\u00033\u0013\t\u0006\u0005\u0003\u0003T\t]SB\u0001B+\u0015\r\u0011\te\\\u0005\u0005\u00053\u0012)FA\bQS\u0016Tx.\\3uKJd\u0015N\\6t\u0003)a\u0017N\\6t%\u0016\fG\rI\u0001\u001fa&,'p\\7fi\u0016\u0014\u0018iY2fgNL'-\u001b7ji&,7OU3bIN,\"A!\u0019\u0011\r\u0005}\u0014q\u0012B2!\u001dq\u0014QSA\\\u0005K\u0002b!!4\u0002X\n\u001d\u0004c\u00010\u0003j%\u0019!1N0\u0003\u001f\u0005\u001b7-Z:tS\nLG.\u001b;jKN\fq\u0004]5fu>lW\r^3s\u0003\u000e\u001cWm]:jE&d\u0017\u000e^5fgJ+\u0017\rZ:!\u000359W\r\u001e)jKj|W.\u001a;feRQ\u0011\u0011\u0014B:\u0005{\u0012iI!%\t\u000f\tUt\u00041\u0001\u0003x\u00059Q.Z:tC\u001e,\u0007\u0003BA@\u0005sJAAa\u001f\u0002\u0002\n9!j\u001d,bYV,\u0007b\u0002B@?\u0001\u0007!\u0011Q\u0001\bQ\u0016\fG-\u001a:t!!\tYJa!\u0002\u001a\n\u001d\u0015\u0002\u0002BC\u0003[\u00131!T1q!\rq$\u0011R\u0005\u0004\u0005\u0017{$aA!os\"9!qR\u0010A\u0002\u0005e\u0015AB7pIVdW\r\u0003\u0004\u0000?\u0001\u0007\u0011\u0011T\u0001\u0014O\u0016$\b+[3{_6,G/\u001a:t\u0005fLEm\u001d\u000b\u000b\u00033\u00139J!'\u0003\u001c\nu\u0005b\u0002B;A\u0001\u0007!q\u000f\u0005\b\u0005\u007f\u0002\u0003\u0019\u0001BA\u0011\u001d\u0011y\t\ta\u0001\u00033Caa \u0011A\u0002\u0005e\u0015aE4fiBKWM_8nKR,'oV5uQ&#GCCAM\u0005G\u0013)Ka*\u0003*\"9!QO\u0011A\u0002\t]\u0004b\u0002B@C\u0001\u0007!\u0011\u0011\u0005\b\u0005\u001f\u000b\u0003\u0019AAM\u0011\u0019y\u0018\u00051\u0001\u0002\u001a\u00061r-\u001a;BY2\u001cuN\u001c;sS\n,Ho\u001c:MS:\\7\u000f\u0006\u0006\u0002\u001a\n=&\u0011\u0017BZ\u0005kCqA!\u001e#\u0001\u0004\u00119\bC\u0004\u0003\u0000\t\u0002\rA!!\t\u000f\t=%\u00051\u0001\u0002\u001a\"1qP\ta\u0001\u00033\u000b\u0011cZ3u\u00032d\u0007+[3{_6,G/\u001a:t))\tIJa/\u0003>\n}&1\u0019\u0005\b\u0005k\u001a\u0003\u0019\u0001B<\u0011\u001d\u0011yh\ta\u0001\u0005\u0003CqA!1$\u0001\u0004\tI*A\u0004n_\u0012,H.\u001a\u001a\t\r}\u001c\u0003\u0019AAM\u0003e9W\r\u001e)jKj|W.\u001a;fe2K7\u000f^*qK\u000eLg-[2\u0015\u0015\u0005e%\u0011\u001aBf\u0005\u001b\u0014y\rC\u0004\u0003v\u0011\u0002\rAa\u001e\t\u000f\t}D\u00051\u0001\u0003\u0002\"9!q\u0012\u0013A\u0002\u0005e\u0005BB@%\u0001\u0004\tI*\u0001\u0010hKR\fE\u000e\u001c)jKj|W.\u001a;feN<\u0016\u000e\u001e5HK>|U\u000f\u001e9viRQ\u0011\u0011\u0014Bk\u0005/\u0014INa7\t\u000f\tUT\u00051\u0001\u0003x!9!qP\u0013A\u0002\t\u0005\u0005b\u0002BHK\u0001\u0007\u0011\u0011\u0014\u0005\u0007\u007f\u0016\u0002\r!!'\u0002+\u001d,G/\u00117m!&,'p\\7fi\u0016\u00148i\u001c3fgRQ\u0011\u0011\u0014Bq\u0005G\u0014)Oa:\t\u000f\tUd\u00051\u0001\u0003x!9!q\u0010\u0014A\u0002\t\u0005\u0005b\u0002BHM\u0001\u0007\u0011\u0011\u0014\u0005\u0007\u007f\u001a\u0002\r!!'\u0002!\r\u0014X-\u0019;f!&,'p\\7fi\u0016\u0014HCCAM\u0005[\u0014yO!=\u0003t\"9!QO\u0014A\u0002\t]\u0004b\u0002B@O\u0001\u0007!\u0011\u0011\u0005\b\u0005\u001f;\u0003\u0019AAM\u0011\u0019yx\u00051\u0001\u0002\u001a\u0006\u0001R\u000f\u001d3bi\u0016\u0004\u0016.\u001a>p[\u0016$XM\u001d\u000b\u000b\u00033\u0013IPa?\u0003~\n}\bb\u0002B;Q\u0001\u0007!q\u000f\u0005\b\u0005\u007fB\u0003\u0019\u0001BA\u0011\u001d\u0011y\t\u000ba\u0001\u00033Caa \u0015A\u0002\u0005e\u0015!F;qI\u0006$X\rU5fu>lW\r^3s\u0019&t7n\u001d\u000b\u000b\u00033\u001b)aa\u0002\u0004\n\r-\u0001b\u0002B;S\u0001\u0007!q\u000f\u0005\b\u0005\u007fJ\u0003\u0019\u0001BA\u0011\u001d\u0011y)\u000ba\u0001\u00033Caa`\u0015A\u0002\u0005e\u0015\u0001\u00053fY\u0016$X\rU5fu>lW\r^3s))\tIj!\u0005\u0004\u0014\rU1q\u0003\u0005\b\u0005kR\u0003\u0019\u0001B<\u0011\u001d\u0011yH\u000ba\u0001\u0005\u0003CqAa$+\u0001\u0004\tI\n\u0003\u0004\u0000U\u0001\u0007\u0011\u0011T\u0001\u0015I\u0016dW\r^3QS\u0016Tx.\\3uKJ$\u0015\r^1\u0015\u0015\u0005e5QDB\u0010\u0007C\u0019\u0019\u0003C\u0004\u0003v-\u0002\rAa\u001e\t\u000f\t}4\u00061\u0001\u0003\u0002\"9!qR\u0016A\u0002\u0005e\u0005BB@,\u0001\u0004\tI*\u0001\rhKR\u0004\u0016.\u001a>p[\u0016$XM\u001d\"z/\u0006$XM]*iK\u0012$\"\"!'\u0004*\r-2QFB\u0018\u0011\u001d\u0011)\b\fa\u0001\u0005oBqAa -\u0001\u0004\u0011\t\tC\u0004\u0003\u00102\u0002\r!!'\t\r}d\u0003\u0019AAM\u0003a9W\r\u001e)jKj|W.\u001a;fe\nKx+\u0019;fe6\f7o\u001d\u000b\u000b\u00033\u001b)da\u000e\u0004:\rm\u0002b\u0002B;[\u0001\u0007!q\u000f\u0005\b\u0005\u007fj\u0003\u0019\u0001BA\u0011\u001d\u0011y)\fa\u0001\u00033Caa`\u0017A\u0002\u0005e\u0015AE4fi\u0006cG/[7fiJL8+_:uK6$\"\"!'\u0004B\r\r3QIB$\u0011\u001d\u0011)H\fa\u0001\u0005oBqAa /\u0001\u0004\u0011\t\tC\u0004\u0003\u0010:\u0002\r!!'\t\r}t\u0003\u0019AAM\u0003U9W\r^!mY\u0006\u001b7-Z:tS\nLG.\u001b;jKN$\"\"!'\u0004N\r=3\u0011KB*\u0011\u001d\u0011)h\fa\u0001\u0005oBqAa 0\u0001\u0004\u0011\t\tC\u0004\u0003\u0010>\u0002\r!!'\t\r}|\u0003\u0019AAM\u0003E9W\r^!dG\u0016\u001c8/\u001b2jY&$Xm\u001d\u000b\u000b\u00033\u001bIfa\u0017\u0004^\r}\u0003b\u0002B;a\u0001\u0007!q\u000f\u0005\b\u0005\u007f\u0002\u0004\u0019\u0001BA\u0011\u001d\u0011y\t\ra\u0001\u00033Caa \u0019A\u0002\u0005e\u0015!F;qI\u0006$X-Q2dKN\u001c\u0018NY5mSRLWm\u001d\u000b\u000b\u00033\u001b)ga\u001a\u0004j\r-\u0004b\u0002B;c\u0001\u0007!q\u000f\u0005\b\u0005\u007f\n\u0004\u0019\u0001BA\u0011\u001d\u0011y)\ra\u0001\u00033Caa`\u0019A\u0002\u0005e\u0015!F2sK\u0006$X-Q2dKN\u001c\u0018NY5mSRLWm\u001d\u000b\u000b\u00033\u001b\tha\u001d\u0004v\r]\u0004b\u0002B;e\u0001\u0007!q\u000f\u0005\b\u0005\u007f\u0012\u0004\u0019\u0001BA\u0011\u001d\u0011yI\ra\u0001\u00033Caa \u001aA\u0002\u0005e\u0015aC4fi2\u000bg\u000eZ7be.$\"\"!'\u0004~\r}4\u0011QBB\u0011\u001d\u0011)h\ra\u0001\u0005oBqAa 4\u0001\u0004\u0011\t\tC\u0004\u0003\u0010N\u0002\r!!'\t\r}\u001c\u0004\u0019AAM\u00035)\b\u000fZ1uK\u000e{g\u000e^1diRQ\u0011\u0011TBE\u0007\u0017\u001biia$\t\u000f\tUD\u00071\u0001\u0003x!9!q\u0010\u001bA\u0002\t\u0005\u0005b\u0002BHi\u0001\u0007\u0011\u0011\u0014\u0005\u0007\u007fR\u0002\r!!'\u0002-M,G/\u00117m\u0007>tGO]5ckR|'\u000fT5oWN$\"\"!'\u0004\u0016\u000e]5\u0011TBN\u0011\u001d\u0011)(\u000ea\u0001\u0005oBqAa 6\u0001\u0004\u0011\t\tC\u0004\u0003\u0010V\u0002\r!!'\t\r},\u0004\u0019AAM\u0003Y\u0019'/Z1uK\u000e{g\u000e\u001e:jEV$xN\u001d'j].\u001cHCCAM\u0007C\u001b\u0019k!*\u0004(\"9!Q\u000f\u001cA\u0002\t]\u0004b\u0002B@m\u0001\u0007!\u0011\u0011\u0005\b\u0005\u001f3\u0004\u0019AAM\u0011\u0019yh\u00071\u0001\u0002\u001a\u0006\u0011R\u000f\u001d3bi\u0016dunY1mSN\fG/[8o))\tIj!,\u00040\u000eE61\u0017\u0005\b\u0005k:\u0004\u0019\u0001B<\u0011\u001d\u0011yh\u000ea\u0001\u0005\u0003CqAa$8\u0001\u0004\tI\n\u0003\u0004\u0000o\u0001\u0007\u0011\u0011\u0014")
public class PiezometerController
implements Producer {
    private final StationAltimetrySystemDao altimetrySystemDao;
    private final StationAccessibilitiesDao accessibilitesDao;
    private final StationLandmarkDao landmarkDao;
    private final PiezometerDaeau piezometerDaeau;
    private final UserStationDao userStationDao;
    private final StationWatermassDao waterMassLinkPiezoDao;
    private final StationContributorDao stationContributorDao;
    private final PiezometerSituationDao PiezometerSituationDao;
    private final PiezometerControl PiezometerControl;
    private final LogUtil logUtil;
    private final StatUtil statUtil;
    private final Reads<Tuple2<String, String>> userReadsWithModule;
    private final Reads<Object> piezometerIdReads;
    private final Reads<Tuple4<String, Seq<Object>, Option<Object>, String>> piezometerIdsReads;
    private final Reads<String> piezometerCodeReads;
    private final SwaggerUtil.SwaggerReads<Tuple3<String, Object, String>> piezometerIdUserReads;
    private final SwaggerUtil.SwaggerReads<Tuple3<String, Option<GetAllQueryParams>, String>> piezometerParamsUserReads;
    private final Reads<Tuple2<String, PiezometerLinks>> linksRead;
    private final Reads<Tuple2<Object, Seq<Accessibilities>>> piezometerAccessibilitiesReads;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        PiezometerController piezometerController = this;
        synchronized (piezometerController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Reads<Tuple2<String, String>> userReadsWithModule() {
        return this.userReadsWithModule;
    }

    public Reads<Object> piezometerIdReads() {
        return this.piezometerIdReads;
    }

    public Reads<Tuple4<String, Seq<Object>, Option<Object>, String>> piezometerIdsReads() {
        return this.piezometerIdsReads;
    }

    public Reads<String> piezometerCodeReads() {
        return this.piezometerCodeReads;
    }

    public SwaggerUtil.SwaggerReads<Tuple3<String, Object, String>> piezometerIdUserReads() {
        return this.piezometerIdUserReads;
    }

    public SwaggerUtil.SwaggerReads<Tuple3<String, Option<GetAllQueryParams>, String>> piezometerParamsUserReads() {
        return this.piezometerParamsUserReads;
    }

    public Reads<Tuple2<String, PiezometerLinks>> linksRead() {
        return this.linksRead;
    }

    public Reads<Tuple2<Object, Seq<Accessibilities>>> piezometerAccessibilitiesReads() {
        return this.piezometerAccessibilitiesReads;
    }

    public String getPiezometer(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Station$.MODULE$.reads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String code = ((Station)jsSuccess.get()).code().toUpperCase();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.piezometerDaeau.getWithLinks(code));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                this.logUtil.printError(e);
                LogUtil x$1 = this.logUtil;
                String x$2 = e.getMessage();
                String x$3 = "ERROR";
                int x$4 = ErrorUtil$.MODULE$.getJsonError$default$3();
                boolean x$5 = ErrorUtil$.MODULE$.getJsonError$default$5();
                return ErrorUtil$.MODULE$.getJsonError(x$1, x$2, x$4, "ERROR", x$5);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Option option = (Option)success.value();
                Option option2 = option;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    PiezometerWithLinks piezometer = (PiezometerWithLinks)some.value();
                    return Json$.MODULE$.toJson((Object)piezometer, (Writes)PiezometerWithLinks$.MODULE$.format()).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    this.logUtil.error(new StringBuilder(31).append("Piezometer with code ").append(code).append(" not found").toString(), this.logUtil.error$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)try_);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.error(new StringBuilder(40).append("Error validate Json to get piezometer :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getPiezometersByIds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerIdsReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validate Json to get all piezometers :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple4 tuple4 = params;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            String user = (String)tuple4._1();
            Seq piezometerIds = (Seq)tuple4._2();
            Option withLinks = (Option)tuple4._3();
            String module = (String)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)user, (Object)piezometerIds, (Object)withLinks, (Object)module);
            String user2 = (String)tuple42._1();
            Seq piezometerIds2 = (Seq)tuple42._2();
            Option withLinks2 = (Option)tuple42._3();
            String module2 = (String)tuple42._4();
            if (piezometerIds2.nonEmpty()) {
                Seq allowStations = $this.userStationDao.getAvailableStation(user2, StationTypeConstants$.MODULE$.TYPE_STATION_PIEZO(), module2);
                String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
                String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    return "[]";
                }
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    if (withLinks2.isDefined() && BoxesRunTime.unboxToBoolean((Object)withLinks2.get())) {
                        return Json$.MODULE$.toJson((Object)$this.piezometerDaeau.getAllWithLinks((Option)new Some((Object)piezometerIds2)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PiezometerWithLinks$.MODULE$.format())).toString();
                    }
                    return Json$.MODULE$.toJson((Object)$this.piezometerDaeau.getAll((Option)new Some((Object)piezometerIds2)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Piezometer$.MODULE$.piezometerWrites())).toString();
                }
                Seq allowStationsIds = (Seq)allowStations.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$2))));
                Some filteredPiezometerIds = new Some(piezometerIds2.filter((Function1)(JFunction1.mcZI.sp & Serializable)id -> allowStationsIds.contains((Object)BoxesRunTime.boxToInteger((int)id))));
                if (withLinks2.isDefined() && BoxesRunTime.unboxToBoolean((Object)withLinks2.get())) {
                    return Json$.MODULE$.toJson((Object)$this.piezometerDaeau.getAllWithLinks((Option)filteredPiezometerIds), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PiezometerWithLinks$.MODULE$.format())).toString();
                }
                return Json$.MODULE$.toJson((Object)$this.piezometerDaeau.getAll((Option)filteredPiezometerIds), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Piezometer$.MODULE$.piezometerWrites())).toString();
            }
            return Json$.MODULE$.toJson((Object)scala.package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Piezometer$.MODULE$.piezometerWrites())).toString();
        });
    }

    public String getPiezometerWithId(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerIdUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to get Piezometer :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.piezometerDaeau.getWithLinks(BoxesRunTime.unboxToInt((Object)id._2())));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                $this.logUtil.printError(e);
                LogUtil x$1 = $this.logUtil;
                String x$2 = e.getMessage();
                String x$3 = "ERROR";
                int x$4 = ErrorUtil$.MODULE$.getJsonError$default$3();
                boolean x$5 = ErrorUtil$.MODULE$.getJsonError$default$5();
                return ErrorUtil$.MODULE$.getJsonError(x$1, x$2, x$4, "ERROR", x$5);
            }
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                Option option = (Option)success.value();
                Option option2 = option;
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    PiezometerWithLinks piezometer = (PiezometerWithLinks)some.value();
                    String code = piezometer.designation().isDefined() ? new StringBuilder(1).append(piezometer.code().get()).append("/").append(piezometer.designation().get()).toString() : (String)piezometer.code().getOrElse((Function0 & Serializable)() -> "");
                    String name = piezometer.name().isDefined() ? new StringBuilder(3).append(" - ").append(piezometer.name().get()).toString() : "";
                    $this.statUtil.createStat((String)id._1(), StatisticEventTypeConstants$.MODULE$.STATION(), StatisticModuleConstants$.MODULE$.PIEZOMETRY(), (String)id._3(), (Option)new Some((Object)new StringBuilder(0).append(code).append(name).toString()));
                    Seq situ = $this.PiezometerSituationDao.getPiezometerTypeMeasuresSituation((Seq)new .colon.colon((Object)new Piezometer(BoxesRunTime.unboxToInt((Object)id._2()), code, Piezometer$.MODULE$.apply$default$3(), Piezometer$.MODULE$.apply$default$4(), Piezometer$.MODULE$.apply$default$5(), Piezometer$.MODULE$.apply$default$6(), Piezometer$.MODULE$.apply$default$7(), Piezometer$.MODULE$.apply$default$8(), Piezometer$.MODULE$.apply$default$9(), Piezometer$.MODULE$.apply$default$10(), Piezometer$.MODULE$.apply$default$11(), Piezometer$.MODULE$.apply$default$12(), Piezometer$.MODULE$.apply$default$13(), Piezometer$.MODULE$.apply$default$14(), Piezometer$.MODULE$.apply$default$15(), Piezometer$.MODULE$.apply$default$16(), Piezometer$.MODULE$.apply$default$17(), Piezometer$.MODULE$.apply$default$18(), Piezometer$.MODULE$.apply$default$19(), Piezometer$.MODULE$.apply$default$20(), Piezometer$.MODULE$.apply$default$21(), Piezometer$.MODULE$.apply$default$22(), Piezometer$.MODULE$.apply$default$23(), Piezometer$.MODULE$.apply$default$24(), Piezometer$.MODULE$.apply$default$25(), Piezometer$.MODULE$.apply$default$26(), Piezometer$.MODULE$.apply$default$27(), Piezometer$.MODULE$.apply$default$28(), Piezometer$.MODULE$.apply$default$29()), (List)Nil$.MODULE$), new DateTime(), 0, (Seq)Nil$.MODULE$, -1, $this.PiezometerSituationDao.getPiezometerTypeMeasuresSituation$default$6());
                    PiezometerWithLinks piezoWithControl = situ.nonEmpty() ? $this.PiezometerControl.checkControlErrors(piezometer, (PiezoChronicSituation)situ.head(), $this.PiezometerControl.checkControlErrors$default$3(), $this.PiezometerControl.checkControlErrors$default$4()) : piezometer;
                    return Json$.MODULE$.toJson((Object)piezoWithControl, (Writes)PiezometerWithLinks$.MODULE$.format()).toString();
                }
                if (None$.MODULE$.equals(option2)) {
                    $this.logUtil.error(new StringBuilder(21).append("Piezometer ").append(id).append(" not found").toString(), $this.logUtil.error$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)try_);
        });
    }

    public String getAllContributorLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userReadsWithModule()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(62).append("Error validate Json to get all piezometers contributor links:\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Seq seq;
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            String module = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)module);
            String user2 = (String)tuple22._1();
            String module2 = (String)tuple22._2();
            Seq allowStations = $this.userStationDao.getAvailableStation(user2, StationTypeConstants$.MODULE$.TYPE_STATION_PIEZO(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    seq = $this.stationContributorDao.getAll("piezometry");
                } else {
                    Seq ids = (Seq)allowStations.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4))));
                    seq = (Seq)$this.stationContributorDao.getAll("piezometry").filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ids.contains((Object)BoxesRunTime.boxToInteger((int)((int)p.idStation())))));
                }
            }
            Seq result = seq;
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationContributorLink$.MODULE$.qualitometereContributorLinkFormat())).toString();
        });
    }

    public String getAllPiezometers(JsValue message, Map<String, Object> headers, String module2, String user) {
        return (String)message.validate(this.piezometerParamsUserReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validate Json to get all piezometers :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Left result;
            Object object;
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String user = (String)tuple3._1();
            Option queryParams = (Option)tuple3._2();
            String module = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)user, (Object)queryParams, (Object)module);
            String user2 = (String)tuple32._1();
            Option queryParams2 = (Option)tuple32._2();
            String module2 = (String)tuple32._3();
            boolean lightMode = queryParams2.isDefined() && ((GetAllQueryParams)queryParams2.get()).lightMode().isDefined() && BoxesRunTime.unboxToBoolean((Object)((GetAllQueryParams)queryParams2.get()).lightMode().get());
            Seq allowStations = $this.userStationDao.getAvailableStation(user2, StationTypeConstants$.MODULE$.TYPE_STATION_PIEZO(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                object = lightMode ? scala.package$.MODULE$.Left().apply((Object)Nil$.MODULE$) : scala.package$.MODULE$.Right().apply((Object)Nil$.MODULE$);
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    object = lightMode ? scala.package$.MODULE$.Left().apply((Object)$this.piezometerDaeau.getAllLightWithParams(queryParams2, $this.piezometerDaeau.getAllLightWithParams$default$2())) : scala.package$.MODULE$.Right().apply((Object)$this.piezometerDaeau.getAllWithParams(queryParams2, $this.piezometerDaeau.getAllWithParams$default$2()));
                } else {
                    Seq ids = (Seq)allowStations.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$6))));
                    object = lightMode ? scala.package$.MODULE$.Left().apply((Object)$this.piezometerDaeau.getAllLightWithParams(queryParams2, (Option)new Some((Object)ids))) : scala.package$.MODULE$.Right().apply((Object)$this.piezometerDaeau.getAllWithParams(queryParams2, (Option)new Some((Object)ids)));
                }
            }
            Left left = result = object;
            if (left instanceof Left) {
                Left left2 = left;
                Seq piezosLight = (Seq)left2.value();
                return new StringBuilder(2).append("[").append(((IterableOnceOps)piezosLight.map((Function1 & Serializable)p -> p.toStringLight())).mkString(",")).append("]").toString();
            }
            if (left instanceof Right) {
                Right right = (Right)left;
                Seq piezos = (Seq)right.value();
                return Json$.MODULE$.toJson((Object)piezos, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Piezometer$.MODULE$.piezometerWrites())).toString();
            }
            throw new MatchError((Object)left);
        });
    }

    public String getPiezometerListSpecific(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userReadsWithModule()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(20).append("Error validate user ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Seq seq;
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            String module = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)module);
            String user2 = (String)tuple22._1();
            String module2 = (String)tuple22._2();
            Seq allowStations = $this.userStationDao.getAvailableStation(user2, StationTypeConstants$.MODULE$.TYPE_STATION_PIEZO(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                seq = (Seq)Nil$.MODULE$;
            } else {
                String string4 = StationTypeConstants$.MODULE$.ALL();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    seq = $this.piezometerDaeau.getPiezometerListSpecific($this.piezometerDaeau.getPiezometerListSpecific$default$1());
                } else {
                    Seq ids = (Seq)allowStations.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$8))));
                    seq = $this.piezometerDaeau.getPiezometerListSpecific((Option)new Some((Object)ids));
                }
            }
            Seq result = seq;
            return new StringBuilder(2).append("[").append(((IterableOnceOps)result.map((Function1 & Serializable)p -> p.toStringLight())).mkString(",")).append("]").toString();
        });
    }

    public String getAllPiezometersWithGeoOutput(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userReadsWithModule()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(45).append("Error validate Json to get all piezometers :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            String module = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)module);
            String user2 = (String)tuple22._1();
            String module2 = (String)tuple22._2();
            Seq allowStations = $this.userStationDao.getAvailableStation(user2, StationTypeConstants$.MODULE$.TYPE_STATION_PIEZO(), module2);
            String string = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string2 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return Json$.MODULE$.toJson((Object)scala.package$.MODULE$.Seq().empty(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Piezometer$.MODULE$.piezometerWrites())).toString();
            }
            String string4 = StationTypeConstants$.MODULE$.ALL();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return Json$.MODULE$.toJson((Object)$this.piezometerDaeau.getAllWithGeoOutput(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PiezometerGeo$.MODULE$.piezometerCodeFormat())).toString();
            }
            return Json$.MODULE$.toJson((Object)$this.piezometerDaeau.getAllWithGeoOutputByIds((Option)new Some(allowStations.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$10)))))), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PiezometerGeo$.MODULE$.piezometerCodeFormat())).toString();
        });
    }

    public String getAllPiezometerCodes(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.piezometerDaeau.getAllCodes(this.piezometerDaeau.getAllCodes$default$1()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PiezometerCode$.MODULE$.piezometerCodeFormat())).toString();
    }

    public String createPiezometer(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)PiezometerWithLinks$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate piezometer object from json input.", 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)piezometerInput -> {
            Option option = $this.piezometerDaeau.find((String)piezometerInput.code().getOrElse((Function0 & Serializable)() -> "null"));
            if (option instanceof Some) {
                return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "BSS code already exist", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
            }
            if (None$.MODULE$.equals(option)) {
                if (piezometerInput.updateLogin().isEmpty()) {
                    return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "updateLogin is Empty", 400, ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
                }
                Option option2 = $this.piezometerDaeau.insert(piezometerInput, (String)piezometerInput.updateLogin().get());
                if (None$.MODULE$.equals(option2)) {
                    return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Error during piezometer database insertion", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
                }
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    Tuple2 couple = (Tuple2)some.value();
                    Tuple2 tuple2 = couple;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int result = tuple2._1$mcI$sp();
                    double id = tuple2._2$mcD$sp();
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(result, id);
                    int result2 = sp2._1$mcI$sp();
                    double id2 = sp2._2$mcD$sp();
                    $this.userStationDao.addUserRightsCreation(Option$.MODULE$.apply((Object)user), (int)id2, StationTypeConstants$.MODULE$.TYPE_STATION_PIEZO());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id2), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)option);
        });
    }

    public String updatePiezometer(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)PiezometerWithLinks$.MODULE$.format()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(51).append("Can't validate piezometer object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            if (input.id().isDefined() && input.updateLogin().isDefined()) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.piezometerDaeau.update(input, (String)input.updateLogin().get())), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            return ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate piezometer object from json input : id or updateLogin is missing", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
        });
    }

    public String updatePiezometerLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.linksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(51).append("Can't validate piezometer object from json input : ").append(error).toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)input -> {
            Tuple2 tuple2 = input;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String user = (String)tuple2._1();
            PiezometerLinks links = (PiezometerLinks)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)user, (Object)links);
            String user2 = (String)tuple22._1();
            PiezometerLinks links2 = (PiezometerLinks)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.piezometerDaeau.updateLinks(links2, user2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deletePiezometer(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerIdReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get id from json input.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)id -> PiezometerController.$anonfun$deletePiezometer$2(this, BoxesRunTime.unboxToInt((Object)id)));
    }

    public String deletePiezometerData(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerCodeReads()).fold((Function1 & Serializable)x$13 -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get id from json input.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)code -> {
            Option option = $this.piezometerDaeau.find(code);
            if (None$.MODULE$.equals(option)) {
                return ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(30).append("Code ").append((String)code).append(" not found in piezometers").toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getPiezometerByWaterShed(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Piezometer$.MODULE$.piezometerWaterShedReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Seq piezometerList = this.piezometerDaeau.getByWaterShed(BoxesRunTime.unboxToDouble((Object)jsSuccess.get()));
            Seq stationList = (Seq)piezometerList.map((Function1 & Serializable)p -> StationOutput$.MODULE$.toStationOutput(p));
            return Json$.MODULE$.toJson((Object)stationList, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), StationOutput$.MODULE$.stationOutputWrites())).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.error(new StringBuilder(59).append("Error validate Json to get piezometers by watershed code :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getPiezometerByWatermass(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate((Reads)CommonReadUtil$.MODULE$.codeReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Seq piezometerList = (Seq)this.waterMassLinkPiezoDao.getAllWithCode("piezometry", (String)jsSuccess.get()).map((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)PiezometerController.$anonfun$getPiezometerByWatermass$1(p)));
            return Json$.MODULE$.toJson((Object)this.piezometerDaeau.getAll((Option)new Some((Object)piezometerList)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Piezometer$.MODULE$.piezometerWrites())).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            this.logUtil.error(new StringBuilder(59).append("Error validate Json to get piezometers by watermass code :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getAltimetrySystem(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Station$.MODULE$.reads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String code = ((Station)jsSuccess.get()).code().toUpperCase();
            Option option = this.piezometerDaeau.find(code);
            if (option instanceof Some) {
                Some some = (Some)option;
                Piezometer piezometer = (Piezometer)some.value();
                return Json$.MODULE$.toJson((Object)this.altimetrySystemDao.getAltimetrySystems("piezometry", (double)piezometer.id()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)AltimetrySystem$.MODULE$.format())).toString();
            }
            if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.error(new StringBuilder(21).append("Piezometer ").append(code).append(" not found").toString(), LogUtil$.MODULE$.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            LogUtil$.MODULE$.error(new StringBuilder(46).append("Error validate Json to get altymetry system :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getAllAccessibilities(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.accessibilitesDao.getAll(StationTypeUtil$.MODULE$.PIEZOMETRY()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Accessibilities$.MODULE$.accessibilitesWrites())).toString();
    }

    public String getAccessibilites(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Station$.MODULE$.reads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String code = ((Station)jsSuccess.get()).code().toUpperCase();
            Option option = this.piezometerDaeau.find(code);
            if (option instanceof Some) {
                Some some = (Some)option;
                Piezometer piezometer = (Piezometer)some.value();
                return Json$.MODULE$.toJson((Object)this.accessibilitesDao.getAccessibilities(StationTypeUtil$.MODULE$.PIEZOMETRY(), (double)piezometer.id()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Accessibilities$.MODULE$.accessibilitesWrites())).toString();
            }
            if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.error(new StringBuilder(21).append("Piezometer ").append(code).append(" not found").toString(), LogUtil$.MODULE$.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            LogUtil$.MODULE$.error(new StringBuilder(44).append("Error validate Json to get accessibilites :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String updateAccessibilities(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerAccessibilitiesReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(48).append("Error validate Json to update accessibilities :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            Seq accessibilities = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)accessibilities);
            int id2 = tuple22._1$mcI$sp();
            Seq accessibilities2 = (Seq)tuple22._2();
            Option option = $this.piezometerDaeau.find(id2);
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.accessibilitesDao.setAccessibilities(StationTypeUtil$.MODULE$.PIEZOMETRY(), id2, accessibilities2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.error(new StringBuilder(21).append("Piezometer ").append(id2).append(" not found").toString(), LogUtil$.MODULE$.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String createAccessibilities(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.piezometerAccessibilitiesReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(48).append("Error validate Json to create accessibilities :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int id = tuple2._1$mcI$sp();
            Seq accessibilities = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id), (Object)accessibilities);
            int id2 = tuple22._1$mcI$sp();
            Seq accessibilities2 = (Seq)tuple22._2();
            Option option = $this.piezometerDaeau.find(id2);
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.accessibilitesDao.setAccessibilities(StationTypeUtil$.MODULE$.PIEZOMETRY(), id2, accessibilities2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.error(new StringBuilder(21).append("Piezometer ").append(id2).append(" not found").toString(), LogUtil$.MODULE$.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError((Object)option);
        });
    }

    public String getLandmark(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(Station$.MODULE$.reads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String code = ((Station)jsSuccess.get()).code().toUpperCase();
            Option option = this.piezometerDaeau.find(code);
            if (option instanceof Some) {
                Some some = (Some)option;
                Piezometer piezometer = (Piezometer)some.value();
                return Json$.MODULE$.toJson((Object)this.landmarkDao.getLandmarks("piezometry", (double)piezometer.id()), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Landmark$.MODULE$.format())).toString();
            }
            throw new MatchError((Object)option);
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            LogUtil$.MODULE$.error(new StringBuilder(39).append("Error validate Json to get landmarks :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String updateContact(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Piezometer$.MODULE$.piezometerContactReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(43).append("Error validate Json to get piezometer id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String user = (String)tuple3._1();
            int id = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Option contactCode = (Option)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)user, (Object)BoxesRunTime.boxToInteger((int)id), (Object)contactCode);
            String user2 = (String)tuple32._1();
            int id2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Option contactCode2 = (Option)tuple32._3();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.piezometerDaeau.updateContact(user2, id2, contactCode2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String setAllContributorLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ContributorLinkInput$.MODULE$.contributorLinksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate contributor links from json input.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String createContributorLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(ContributorLinkInput$.MODULE$.contributorLinksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate contributor link object from json input.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String updateLocalisation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(Piezometer$.MODULE$.piezometerLocalisationReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(68).append("Error validate Json to get piezometer station id and localisation :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple5 tuple5 = read;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            String user = (String)tuple5._1();
            int id = BoxesRunTime.unboxToInt((Object)tuple5._2());
            double x = BoxesRunTime.unboxToDouble((Object)tuple5._3());
            double y = BoxesRunTime.unboxToDouble((Object)tuple5._4());
            int projection = BoxesRunTime.unboxToInt((Object)tuple5._5());
            Tuple5 tuple52 = new Tuple5((Object)user, (Object)BoxesRunTime.boxToInteger((int)id), (Object)BoxesRunTime.boxToDouble((double)x), (Object)BoxesRunTime.boxToDouble((double)y), (Object)BoxesRunTime.boxToInteger((int)projection));
            String user2 = (String)tuple52._1();
            int id2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
            double x2 = BoxesRunTime.unboxToDouble((Object)tuple52._3());
            double y2 = BoxesRunTime.unboxToDouble((Object)tuple52._4());
            int projection2 = BoxesRunTime.unboxToInt((Object)tuple52._5());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.piezometerDaeau.updateLocalisation(user2, id2, x2, y2, projection2)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$deletePiezometer$2(PiezometerController $this, int id) {
        Option option = $this.piezometerDaeau.find(id);
        if (None$.MODULE$.equals(option)) {
            return ErrorUtil$.MODULE$.getJsonError($this.logUtil, new StringBuilder(28).append("id ").append(id).append(" not found in piezometers").toString(), ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5());
        }
        if (option instanceof Some) {
            Some some = (Some)option;
            Piezometer piezometer = (Piezometer)some.value();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.piezometerDaeau.delete(id, piezometer.code())), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ int $anonfun$getPiezometerByWatermass$1(StationWatermassCoordinates p) {
        return (int)p.idStation();
    }

    @Inject
    public PiezometerController(StationAltimetrySystemDao altimetrySystemDao, StationAccessibilitiesDao accessibilitesDao, StationLandmarkDao landmarkDao, PiezometerDaeau piezometerDaeau, StationContributorDao piezometerContributorLinkDao, UserDao userDao, UserStationDao userStationDao, StationWatermassDao waterMassLinkPiezoDao, StationContributorDao stationContributorDao, PiezometerSituationDao PiezometerSituationDao2, PiezometerControl PiezometerControl2, LogUtil logUtil, StatUtil statUtil) {
        this.altimetrySystemDao = altimetrySystemDao;
        this.accessibilitesDao = accessibilitesDao;
        this.landmarkDao = landmarkDao;
        this.piezometerDaeau = piezometerDaeau;
        this.userStationDao = userStationDao;
        this.waterMassLinkPiezoDao = waterMassLinkPiezoDao;
        this.stationContributorDao = stationContributorDao;
        this.PiezometerSituationDao = PiezometerSituationDao2;
        this.PiezometerControl = PiezometerControl2;
        this.logUtil = logUtil;
        this.statUtil = statUtil;
        Producer.$init$((Producer)this);
        this.userReadsWithModule = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.piezometerIdReads = JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads());
        this.piezometerIdsReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("piezometerIds").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("withLinks").readNullable((Reads)Reads$.MODULE$.BooleanReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.piezometerCodeReads = JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads());
        SwaggerUtil.SwaggerPath qual$1 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("user"));
        String x$1 = qual$1.read$default$1();
        JsValue x$2 = qual$1.read$default$2();
        Option x$3 = qual$1.read$default$3();
        SwaggerUtil.SwaggerPath qual$2 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("id"));
        String x$4 = "Id du pi\u00e9zom\u00e8tre";
        JsNumber x$5 = new JsNumber(BigDecimal$.MODULE$.int2bigDecimal(14));
        Option x$6 = qual$2.read$default$3();
        SwaggerUtil.SwaggerPath qual$3 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("platform"));
        String x$7 = qual$3.read$default$1();
        JsValue x$8 = qual$3.read$default$2();
        Option x$9 = qual$3.read$default$3();
        this.piezometerIdUserReads = SwaggerUtil$.MODULE$.SwaggerReads2Ops(SwaggerUtil$.MODULE$.SwaggerReads1Ops(qual$1.read(x$1, x$2, x$3, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType())).and(qual$2.read("Id du pi\u00e9zom\u00e8tre", (JsValue)x$5, x$6, (Reads)Reads$.MODULE$.IntReads(), SwaggerUtil.SwaggerType$.MODULE$.intType()))).and(qual$3.read(x$7, x$8, x$9, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType()));
        SwaggerUtil.SwaggerPath qual$4 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("user"));
        String x$10 = qual$4.read$default$1();
        JsValue x$11 = qual$4.read$default$2();
        Option x$12 = qual$4.read$default$3();
        SwaggerUtil.SwaggerPath qual$5 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("queryParams"));
        String x$13 = qual$5.readNullable$default$1();
        JsValue x$14 = qual$5.readNullable$default$2();
        Option x$15 = qual$5.readNullable$default$3();
        JavaUniverse $u = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PiezometerController.class.getClassLoader());
        SwaggerUtil.SwaggerPath qual$6 = new SwaggerUtil.SwaggerPath(JsPath$.MODULE$.$bslash("module"));
        String x$16 = qual$6.read$default$1();
        JsValue x$17 = qual$6.read$default$2();
        Option x$18 = qual$6.read$default$3();
        JavaUniverse $u2 = scala.reflect.runtime.package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = scala.reflect.runtime.package$.MODULE$.universe().runtimeMirror(PiezometerController.class.getClassLoader());
        public final class Controllers_PiezometerController$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("fr.aquasys.daeau.station.domain.input.GetAllQueryParams").asType().toTypeConstructor();
            }

            public Controllers_PiezometerController$$typecreator4$1(PiezometerController $outer) {
            }
        }
        public final class Controllers_PiezometerController$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("fr.aquasys.daeau.station.domain.input.GetAllQueryParams").asType().toTypeConstructor(), (List)Nil$.MODULE$));
            }

            public Controllers_PiezometerController$$typecreator6$1(PiezometerController $outer) {
            }
        }
        this.piezometerParamsUserReads = SwaggerUtil$.MODULE$.SwaggerReads2Ops(SwaggerUtil$.MODULE$.SwaggerReads1Ops(qual$4.read(x$10, x$11, x$12, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType())).and(qual$5.readNullable(x$13, x$14, x$15, (Reads)GetAllQueryParams$.MODULE$.format(), SwaggerUtil.SwaggerType$.MODULE$.caseClassType(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Controllers_PiezometerController$$typecreator4$1(null)))))).and(qual$6.read(x$16, x$17, x$18, (Reads)Reads$.MODULE$.StringReads(), SwaggerUtil.SwaggerType$.MODULE$.stringType()).withHttpBodyType(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Controllers_PiezometerController$$typecreator6$1(null))));
        this.linksRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("links").read((Reads)PiezometerLinks$.MODULE$.format())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.piezometerAccessibilitiesReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("idPiezo").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("accessibilities").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Accessibilities$.MODULE$.accessibilitesWrites()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

