/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import dao.ReferencialDao;
import dao.StationDao;
import domain.referencial.MinMaxLevelStat$;
import domain.referencial.ReferentialLinkName$;
import domain.referencial.StationContributorLink;
import domain.referencial.StationContributorLink$;
import fr.aquasys.daeau.hydrometry.itf.HydrologicalStationDao;
import fr.aquasys.daeau.installation.itf.InstallationDao;
import fr.aquasys.daeau.piezometry.itf.PiezometerDaeau;
import fr.aquasys.daeau.pluviometry.itf.PluviometerDao;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.referentials.contact.input.ContactInput;
import fr.aquasys.daeau.referentials.contact.input.ContactInput$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import fr.aquasys.utils.StringUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import model.Station$;
import play.api.db.Database;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015a\u0001\u0002\u000e\u001c\u0001yA\u0001\"\n\u0001\u0003\u0002\u0003\u0006YA\n\u0005\te\u0001\u0011\t\u0011)A\u0006g!AQ\b\u0001B\u0001B\u0003-a\b\u0003\u0005G\u0001\t\u0005\t\u0015a\u0003H\u0011!q\u0005A!A!\u0002\u0017y\u0005\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u0011y\u0003!\u0011!Q\u0001\f}C\u0001\"\u001a\u0001\u0003\u0002\u0003\u0006YA\u001a\u0005\tS\u0002\u0011\t\u0011)A\u0006U\"A\u0011\u000f\u0001B\u0001B\u0003-!\u000fC\u0003|\u0001\u0011\u0005A\u0010C\u0005\u0002(\u0001\u0011\r\u0011\"\u0001\u0002*!A\u0011\u0011\u000e\u0001!\u0002\u0013\tY\u0003C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005E\u0005\u0001\"\u0001\u0002\u0014\"I\u0011Q\u0014\u0001C\u0002\u0013\u0005\u0011q\u0014\u0005\t\u0003w\u0003\u0001\u0015!\u0003\u0002\"\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAe\u0001\u0011\u0005\u00111\u001a\u0005\n\u0003+\u0004!\u0019!C\u0001\u0003/D\u0001\"!9\u0001A\u0003%\u0011\u0011\u001c\u0005\b\u0003G\u0004A\u0011AAs\u0011%\ty\u000f\u0001b\u0001\n\u0003\t\t\u0010\u0003\u0005\u0002x\u0002\u0001\u000b\u0011BAz\u0011\u001d\tI\u0010\u0001C\u0001\u0003w\u0014QCU3gKJ,gnY5bY\u000e{g\u000e\u001e:pY2,'OC\u0001\u001d\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001a\b\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0002\u000f1|w-\u0016;jYB\u0011q\u0005M\u0007\u0002Q)\u0011\u0011FK\u0001\u0005kRLGN\u0003\u0002,Y\u0005A!/\u00192cSRl\u0017O\u0003\u0002.]\u00059\u0011-];bgf\u001c(\"A\u0018\u0002\u0005\u0019\u0014\u0018BA\u0019)\u0005\u001daunZ+uS2\f!bY8oi\u0006\u001cG\u000fR1p!\t!4(D\u00016\u0015\t1t'A\u0004d_:$\u0018m\u0019;\u000b\u0005aJ\u0014\u0001\u0004:fM\u0016\u0014XM\u001c;jC2\u001c(B\u0001\u001e-\u0003\u0015!\u0017-Z1v\u0013\taTG\u0001\u0006D_:$\u0018m\u0019;EC>\fq\u0002]5fu>lW\r^3s\t\u0006,\u0017-\u001e\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b1!\u001b;g\u0015\t\u0019\u0015(\u0001\u0006qS\u0016Tx.\\3uefL!!\u0012!\u0003\u001fAKWM_8nKR,'\u000fR1fCV\fq\"];bY&$x.\\3uKJ$\u0015m\u001c\t\u0003\u00112k\u0011!\u0013\u0006\u0003\u0003*S!aS\u001d\u0002\u000fE,\u0018\r\\5us&\u0011Q*\u0013\u0002\u0010#V\fG.\u001b;p[\u0016$XM\u001d#b_\u0006y\u0011N\\:uC2d\u0017\r^5p]\u0012\u000bw\u000e\u0005\u0002Q)6\t\u0011K\u0003\u0002B%*\u00111+O\u0001\rS:\u001cH/\u00197mCRLwN\\\u0005\u0003+F\u0013q\"\u00138ti\u0006dG.\u0019;j_:$\u0015m\\\u0001\u0017Qf$'o\u001c7pO&\u001c\u0017\r\\*uCRLwN\u001c#b_B\u0011\u0001\fX\u0007\u00023*\u0011\u0011I\u0017\u0006\u00037f\n!\u0002[=ee>lW\r\u001e:z\u0013\ti\u0016L\u0001\fIs\u0012\u0014x\u000e\\8hS\u000e\fGn\u0015;bi&|g\u000eR1p\u00039\u0011XMZ3sK:\u001c\u0017.\u00197EC>\u0004\"\u0001Y2\u000e\u0003\u0005T\u0011AY\u0001\u0004I\u0006|\u0017B\u00013b\u00059\u0011VMZ3sK:\u001c\u0017.\u00197EC>\f!b\u001d;bi&|g\u000eR1p!\t\u0001w-\u0003\u0002iC\nQ1\u000b^1uS>tG)Y8\u0002\u001dAdWO^5p[\u0016$XM\u001d#b_B\u00111n\\\u0007\u0002Y*\u0011\u0011)\u001c\u0006\u0003]f\n1\u0002\u001d7vm&|W.\u001a;ss&\u0011\u0001\u000f\u001c\u0002\u000f!2,h/[8nKR,'\u000fR1p\u0003\t!'\r\u0005\u0002ts6\tAO\u0003\u0002rk*\u0011ao^\u0001\u0004CBL'\"\u0001=\u0002\tAd\u0017-_\u0005\u0003uR\u0014\u0001\u0002R1uC\n\f7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u$RC`A\u0001\u0003\u0007\t)!a\u0002\u0002\n\u0005-\u0011QBA\b\u0003#\t\u0019\u0002\u0005\u0002\u0000\u00015\t1\u0004C\u0003&\u0017\u0001\u000fa\u0005C\u00033\u0017\u0001\u000f1\u0007C\u0003>\u0017\u0001\u000fa\bC\u0003G\u0017\u0001\u000fq\tC\u0003O\u0017\u0001\u000fq\nC\u0003W\u0017\u0001\u000fq\u000bC\u0003_\u0017\u0001\u000fq\fC\u0003f\u0017\u0001\u000fa\rC\u0003j\u0017\u0001\u000f!\u000eC\u0003r\u0017\u0001\u000f!\u000fK\u0002\f\u0003/\u0001B!!\u0007\u0002$5\u0011\u00111\u0004\u0006\u0005\u0003;\ty\"\u0001\u0004j]*,7\r\u001e\u0006\u0003\u0003C\tQA[1wCbLA!!\n\u0002\u001c\t1\u0011J\u001c6fGR\f1c\u001d;bi&|gnQ8oi\u0006\u001cGOU3bIN,\"!a\u000b\u0011\r\u00055\u0012qGA\u001e\u001b\t\tyC\u0003\u0003\u00022\u0005M\u0012\u0001\u00026t_:T1!!\u000ev\u0003\u0011a\u0017NY:\n\t\u0005e\u0012q\u0006\u0002\u0006%\u0016\fGm\u001d\t\fA\u0005u\u0012\u0011IA,\u0003\u0003\ni&C\u0002\u0002@\u0005\u0012a\u0001V;qY\u0016$\u0004\u0003BA\"\u0003#rA!!\u0012\u0002NA\u0019\u0011qI\u0011\u000e\u0005\u0005%#bAA&;\u00051AH]8pizJ1!a\u0014\"\u0003\u0019\u0001&/\u001a3fM&!\u00111KA+\u0005\u0019\u0019FO]5oO*\u0019\u0011qJ\u0011\u0011\u0007\u0001\nI&C\u0002\u0002\\\u0005\u00121!\u00138u!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA2k\u0005)\u0011N\u001c9vi&!\u0011qMA1\u00051\u0019uN\u001c;bGRLe\u000e];u\u0003Q\u0019H/\u0019;j_:\u001cuN\u001c;bGR\u0014V-\u00193tA\u0005!3M]3bi\u0016\u001cuN\u001c;bGR\fe\u000eZ+qI\u0006$Xm\u0015;bi&|gnQ8oi\u0006\u001cG\u000f\u0006\u0006\u0002B\u0005=\u0014\u0011PAE\u0003\u001bCq!!\u001d\u000f\u0001\u0004\t\u0019(A\u0004nKN\u001c\u0018mZ3\u0011\t\u00055\u0012QO\u0005\u0005\u0003o\nyCA\u0004KgZ\u000bG.^3\t\u000f\u0005md\u00021\u0001\u0002~\u00059\u0001.Z1eKJ\u001c\b\u0003CA\"\u0003\u007f\n\t%a!\n\t\u0005\u0005\u0015Q\u000b\u0002\u0004\u001b\u0006\u0004\bc\u0001\u0011\u0002\u0006&\u0019\u0011qQ\u0011\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\f:\u0001\r!!\u0011\u0002\r5|G-\u001e7f\u0011\u001d\tyI\u0004a\u0001\u0003\u0003\nA!^:fe\u0006\u0001r-\u001a;Qk\nd\u0017nY*uCRLwN\u001c\u000b\u000b\u0003\u0003\n)*a&\u0002\u001a\u0006m\u0005bBA9\u001f\u0001\u0007\u00111\u000f\u0005\b\u0003wz\u0001\u0019AA?\u0011\u001d\tYi\u0004a\u0001\u0003\u0003Bq!a$\u0010\u0001\u0004\t\t%A\u0005mS:\\7OU3bIV\u0011\u0011\u0011\u0015\t\u0007\u0003[\t9$a)\u0011\u000f\u0001\n)+!+\u0002B%\u0019\u0011qU\u0011\u0003\rQ+\b\u000f\\33!\u0019\tY+!.\u0002X9!\u0011QVAY\u001d\u0011\t9%a,\n\u0003\tJ1!a-\"\u0003\u001d\u0001\u0018mY6bO\u0016LA!a.\u0002:\n\u00191+Z9\u000b\u0007\u0005M\u0016%\u0001\u0006mS:\\7OU3bI\u0002\n!dZ3u/\u0006$XM]7bgNd\u0015N\\6t/&$\bNT1nKN$\"\"!\u0011\u0002B\u0006\r\u0017QYAd\u0011\u001d\t\tH\u0005a\u0001\u0003gBq!a\u001f\u0013\u0001\u0004\ti\bC\u0004\u0002\fJ\u0001\r!!\u0011\t\u000f\u0005=%\u00031\u0001\u0002B\u0005Ar-\u001a;BcVLg-\u001a:MS:\\7oV5uQ:\u000bW.Z:\u0015\u0015\u0005\u0005\u0013QZAh\u0003#\f\u0019\u000eC\u0004\u0002rM\u0001\r!a\u001d\t\u000f\u0005m4\u00031\u0001\u0002~!9\u00111R\nA\u0002\u0005\u0005\u0003bBAH'\u0001\u0007\u0011\u0011I\u0001\ngR\fGo\u001d*fC\u0012,\"!!7\u0011\r\u00055\u0012qGAn!%\u0001\u0013Q\\AU\u0003\u0003\n9&C\u0002\u0002`\u0006\u0012a\u0001V;qY\u0016\u001c\u0014AC:uCR\u001c(+Z1eA\u0005\u0019r-\u001a;NS:l\u0015\r\u001f'fm\u0016d7\u000b^1ugRQ\u0011\u0011IAt\u0003S\fY/!<\t\u000f\u0005Ed\u00031\u0001\u0002t!9\u00111\u0010\fA\u0002\u0005u\u0004bBAF-\u0001\u0007\u0011\u0011\t\u0005\b\u0003\u001f3\u0002\u0019AA!\u0003A\u0019wN\u001c;sS\n,Ho\u001c:t%\u0016\fG-\u0006\u0002\u0002tB1\u0011QFA\u001c\u0003k\u0004r\u0001IAS\u0003\u0003\n9&A\td_:$(/\u001b2vi>\u00148OU3bI\u0002\nacZ3u'R\fG/[8o\u0007>tGO]5ckR|'o\u001d\u000b\u000b\u0003\u0003\ni0a@\u0003\u0002\t\r\u0001bBA93\u0001\u0007\u00111\u000f\u0005\b\u0003wJ\u0002\u0019AA?\u0011\u001d\tY)\u0007a\u0001\u0003\u0003Bq!a$\u001a\u0001\u0004\t\t\u0005")
public class ReferencialController {
    private final LogUtil logUtil;
    private final ContactDao contactDao;
    private final PiezometerDaeau piezometerDaeau;
    private final QualitometerDao qualitometerDao;
    private final InstallationDao installationDao;
    private final HydrologicalStationDao hydrologicalStationDao;
    private final ReferencialDao referencialDao;
    private final StationDao stationDao;
    private final PluviometerDao pluviometerDao;
    private final Database db;
    private final Reads<Tuple4<String, Object, String, ContactInput>> stationContactReads;
    private final Reads<Tuple2<Seq<Object>, String>> linksRead;
    private final Reads<Tuple3<Seq<Object>, String, Object>> statsRead;
    private final Reads<Tuple2<String, Object>> contributorsRead;

    public Reads<Tuple4<String, Object, String, ContactInput>> stationContactReads() {
        return this.stationContactReads;
    }

    public String createContactAndUpdateStationContact(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.stationContactReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(60).append("Error validate Json to create and update station contact : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            int n;
            Tuple4 tuple4 = read;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            String user = (String)tuple4._1();
            int id = BoxesRunTime.unboxToInt((Object)tuple4._2());
            String stationType = (String)tuple4._3();
            ContactInput contact = (ContactInput)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)user, (Object)BoxesRunTime.boxToInteger((int)id), (Object)stationType, (Object)contact);
            String user2 = (String)tuple42._1();
            int id2 = BoxesRunTime.unboxToInt((Object)tuple42._2());
            String stationType2 = (String)tuple42._3();
            ContactInput contact2 = (ContactInput)tuple42._4();
            Tuple2 tuple2 = $this.contactDao.create(contact2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int result = tuple2._1$mcI$sp();
            int contactCode = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(result, contactCode);
            int result2 = sp2._1$mcI$sp();
            int contactCode2 = sp2._2$mcI$sp();
            String string = StationTypeUtil$.MODULE$.StationType(stationType2);
            String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                n = $this.piezometerDaeau.updateContact(user2, id2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)contactCode2)));
            } else {
                String string4 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    n = $this.pluviometerDao.updateContact(user2, (double)id2, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)contactCode2)));
                } else {
                    String string6 = StationTypeUtil$.MODULE$.QUALITY();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        n = $this.qualitometerDao.updateContact(user2, (double)id2, (Option)new Some((Object)BoxesRunTime.boxToDouble((double)contactCode2)));
                    } else {
                        String string8 = StationTypeUtil$.MODULE$.HYDROMETRY();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            n = $this.hydrologicalStationDao.updateContact(user2, (double)id2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)contactCode2)));
                        } else {
                            String string10 = StationTypeUtil$.MODULE$.INSTALLATION();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                n = $this.installationDao.updateContact(user2, (long)id2, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)contactCode2)));
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
            int update = n;
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)update), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)result2), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getPublicStation(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.stationDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), Station$.MODULE$.stationWrites())).toString();
    }

    public Reads<Tuple2<Seq<Object>, String>> linksRead() {
        return this.linksRead;
    }

    public String getWatermassLinksWithNames(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.linksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(12).append("Bad input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Tuple2 tuple2;
            String stationType;
            Seq ids;
            block10: {
                block9: {
                    Tuple2 tuple22 = input;
                    if (tuple22 == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    Seq ids2 = (Seq)tuple22._1();
                    String stationType2 = (String)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)ids2, (Object)stationType2);
                    ids = (Seq)tuple23._1();
                    stationType = (String)tuple23._2();
                    if (ids.isEmpty()) break block9;
                    String string = StationTypeUtil$.MODULE$.StationType(stationType);
                    String string2 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                    if (string != null ? !string.equals(string2) : string2 != null) break block10;
                }
                return "[]";
            }
            String string = StationTypeUtil$.MODULE$.StationType(stationType);
            String string3 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string4 = string;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tuple2 = new Tuple2((Object)"codepiezometre", (Object)"lien_piezo_masse_eau");
            } else {
                String string5 = StationTypeUtil$.MODULE$.HYDROMETRY();
                String string6 = string;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    tuple2 = new Tuple2((Object)"codestation", (Object)"lien_hydro_masse_eau");
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Tuple2 tuple24 = tuple2;
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            String code = (String)tuple24._1();
            String table = (String)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)code, (Object)table);
            String code2 = (String)tuple25._1();
            String table2 = (String)tuple25._2();
            String req = new StringBuilder(204).append("\n                    select ").append(code2).append("::integer, l.code_me, masses_eaux.libelle from ").append(table2).append(" l\n                    left join masses_eaux on masses_eaux.code_me = l.code_me\n                    where ").append(code2).append(" in (").append(StringUtil$.MODULE$.inList(ids)).append(")\n                ").toString();
            List res = (List)$this.db.withConnection((Function1 & Serializable)c -> {
                ParameterValue[] parameterValueArray = new ParameterValue[1];
                ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
                Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)req, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"#", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(ReferentialLinkName$.MODULE$.parser().$times(), c);
            });
            return Json$.MODULE$.toJson((Object)res, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ReferentialLinkName$.MODULE$.format())).toString();
        });
    }

    public String getAquiferLinksWithNames(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.linksRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(12).append("Bad input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            String stationType;
            Seq ids;
            block7: {
                block6: {
                    Tuple2 tuple2 = input;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    Seq ids2 = (Seq)tuple2._1();
                    String stationType2 = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)ids2, (Object)stationType2);
                    ids = (Seq)tuple22._1();
                    stationType = (String)tuple22._2();
                    if (ids.isEmpty()) break block6;
                    String string = StationTypeUtil$.MODULE$.StationType(stationType);
                    String string2 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                    if (string != null ? !string.equals(string2) : string2 != null) break block7;
                }
                return "[]";
            }
            String string = StationTypeUtil$.MODULE$.StationType(stationType);
            String string3 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string4 = string;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                String req = new StringBuilder(297).append("\n                            select l.codepiezometre::integer, aquiferes.libelle, aquiferes.libelle from lien_piezo_aquifere l\n                            left join aquiferes on l.codeaquifere = aquiferes.codeaquifere\n                            where codepiezometre in (").append(StringUtil$.MODULE$.inList(ids)).append(")\n                        ").toString();
                List res = (List)$this.db.withConnection((Function1 & Serializable)c -> {
                    ParameterValue[] parameterValueArray = new ParameterValue[1];
                    ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
                    Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)req, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                    return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"#", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(ReferentialLinkName$.MODULE$.parser().$times(), c);
                });
                return Json$.MODULE$.toJson((Object)res, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ReferentialLinkName$.MODULE$.format())).toString();
            }
            String string5 = StationTypeUtil$.MODULE$.HYDROMETRY();
            String string6 = string;
            if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                String req = new StringBuilder(97).append("select codestation::integer, nomcourseau, nomcourseau from stations_hydro where codestation in (").append(StringUtil$.MODULE$.inList(ids)).append(")").toString();
                List res = (List)$this.db.withConnection((Function1 & Serializable)c -> {
                    ParameterValue[] parameterValueArray = new ParameterValue[1];
                    ToStatementPriority0.stringToStatement$ x$7 = ToStatement$.MODULE$.stringToStatement();
                    Null$ x$8 = ToParameterValue$.MODULE$.apply$default$1();
                    parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)req, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$7));
                    return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"#", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(ReferentialLinkName$.MODULE$.parser().$times(), c);
                });
                return Json$.MODULE$.toJson((Object)res, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), ReferentialLinkName$.MODULE$.format())).toString();
            }
            throw new MatchError((Object)string);
        });
    }

    public Reads<Tuple3<Seq<Object>, String, Object>> statsRead() {
        return this.statsRead;
    }

    public String getMinMaxLevelStats(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.statsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(12).append("Bad input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Tuple4 tuple4;
            int typeid;
            String stationType;
            Seq ids;
            block10: {
                block9: {
                    Tuple3 tuple3 = input;
                    if (tuple3 == null) {
                        throw new MatchError((Object)tuple3);
                    }
                    Seq ids2 = (Seq)tuple3._1();
                    String stationType2 = (String)tuple3._2();
                    int typeid2 = BoxesRunTime.unboxToInt((Object)tuple3._3());
                    Tuple3 tuple32 = new Tuple3((Object)ids2, (Object)stationType2, (Object)BoxesRunTime.boxToInteger((int)typeid2));
                    ids = (Seq)tuple32._1();
                    stationType = (String)tuple32._2();
                    typeid = BoxesRunTime.unboxToInt((Object)tuple32._3());
                    if (ids.isEmpty()) break block9;
                    String string = StationTypeUtil$.MODULE$.StationType(stationType);
                    String string2 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                    if (string != null ? !string.equals(string2) : string2 != null) break block10;
                }
                return "[]";
            }
            String string = StationTypeUtil$.MODULE$.StationType(stationType);
            String string3 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string4 = string;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                tuple4 = new Tuple4((Object)"chroniques_brutes", (Object)"codepiezometre", (Object)"valeurngfcorrigee, valeurngf, valeurmesurecorrigee, valeurmesure", (Object)" AND qualificationmesure = 1 AND statutmesure IN (2, 3)");
            } else {
                String string5 = StationTypeUtil$.MODULE$.HYDROMETRY();
                String string6 = string;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    tuple4 = new Tuple4((Object)"chroniques_hydro", (Object)"codestation", (Object)"valeurmesurecorrigee, valeurmesure", (Object)"");
                } else {
                    throw new MatchError((Object)string);
                }
            }
            Tuple4 tuple42 = tuple4;
            if (tuple42 == null) {
                throw new MatchError((Object)tuple42);
            }
            String table = (String)tuple42._1();
            String code = (String)tuple42._2();
            String values = (String)tuple42._3();
            String validOnly = (String)tuple42._4();
            Tuple4 tuple43 = new Tuple4((Object)table, (Object)code, (Object)values, (Object)validOnly);
            String table2 = (String)tuple43._1();
            String code2 = (String)tuple43._2();
            String values2 = (String)tuple43._3();
            String validOnly2 = (String)tuple43._4();
            String req = new StringBuilder(1865).append("\n                        select mintable.").append(code2).append(", datemin, minv, datemax, maxv, lastv, case when maxv = minv then 100 else round(((lastv-minv)*100/(maxv-minv))::numeric, 2) end tauxremplissage from (\n                                                                  select distinct ").append(code2).append(", max(datemesure) datemin, min(coalesce(").append(values2).append(")) minv from ").append(table2).append(" where typeid = ").append(typeid).append(" and (").append(code2).append(", coalesce(").append(values2).append(")) in (\n                                                                      select ").append(code2).append(", min(coalesce(").append(values2).append(")) minv\n                                                                      from ").append(table2).append(" where typeid = ").append(typeid).append("\n                                                                                               and ").append(code2).append(" in (").append(StringUtil$.MODULE$.inList(ids)).append(") ").append(validOnly2).append("\n                                                                      group by ").append(code2).append("\n                                                                  ) group by ").append(code2).append("\n                                                              ) mintable\n                    left join (\n                        select distinct ").append(code2).append(", max(datemesure) datemax, min(coalesce(").append(values2).append(")) maxv from ").append(table2).append(" where typeid = ").append(typeid).append(" and (").append(code2).append(", coalesce(").append(values2).append(")) in (\n                            select ").append(code2).append(", max(coalesce(").append(values2).append(")) maxv\n                            from ").append(table2).append(" where typeid = ").append(typeid).append("\n                                                     and ").append(code2).append(" in (").append(StringUtil$.MODULE$.inList(ids)).append(") ").append(validOnly2).append("\n                            group by ").append(code2).append("\n                        ) group by ").append(code2).append("\n                    ) maxtable on mintable.").append(code2).append(" = maxtable.").append(code2).append("\n                    left join (\n                        select distinct ").append(code2).append(", max(datemesure) datelast, min(coalesce(").append(values2).append(")) lastv from ").append(table2).append(" where typeid = ").append(typeid).append(" and (").append(code2).append(", datemesure) in (\n                            select ").append(code2).append(", max(datemesure) datelast\n                            from ").append(table2).append(" where typeid = ").append(typeid).append("\n                                                     and ").append(code2).append(" in (").append(StringUtil$.MODULE$.inList(ids)).append(") ").append(validOnly2).append("\n                            group by ").append(code2).append("\n                        ) group by ").append(code2).append("\n                    ) lasttable on mintable.").append(code2).append(" = lasttable.").append(code2).append("\n                    ").toString();
            List res = (List)$this.db.withConnection((Function1 & Serializable)c -> {
                ParameterValue[] parameterValueArray = new ParameterValue[1];
                ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
                Null$ x$4 = ToParameterValue$.MODULE$.apply$default$1();
                parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)req, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                return (List)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"#", ""}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(MinMaxLevelStat$.MODULE$.parser().$times(), c);
            });
            return Json$.MODULE$.toJson((Object)res, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), MinMaxLevelStat$.MODULE$.format())).toString();
        });
    }

    public Reads<Tuple2<String, Object>> contributorsRead() {
        return this.contributorsRead;
    }

    public String getStationContributors(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.contributorsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.jsonError(new StringBuilder(12).append("Bad input : ").append(error.toString()).toString(), 400, ErrorUtil$.MODULE$.jsonError$default$3(), ErrorUtil$.MODULE$.jsonError$default$4(), $this.logUtil), (Function1 & Serializable)input -> {
            Seq<StationContributorLink> seq;
            block7: {
                Tuple2 tuple2 = input;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                String stationType = (String)tuple2._1();
                int contributorType = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)stationType, (Object)BoxesRunTime.boxToInteger((int)contributorType));
                String stationType2 = (String)tuple22._1();
                int contributorType2 = tuple22._2$mcI$sp();
                String string = stationType2;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1520726014: {
                        if (!"piezometry".equals(string)) break;
                        seq = $this.referencialDao.getPiezometerContributors(contributorType2);
                        break block7;
                    }
                    case 651215103: {
                        if (!"quality".equals(string)) break;
                        seq = $this.referencialDao.getQualitometerContributors(contributorType2);
                        break block7;
                    }
                    case 943976499: {
                        if (!"hydrometry".equals(string)) break;
                        seq = $this.referencialDao.getHydrometerContributors(contributorType2);
                        break block7;
                    }
                    case 1310932864: {
                        if (!"pluviometry".equals(string)) break;
                        seq = $this.referencialDao.getPluviometerContributors(contributorType2);
                        break block7;
                    }
                }
                seq = (Seq<StationContributorLink>)Nil$.MODULE$;
            }
            Seq<StationContributorLink> contributors = seq;
            return Json$.MODULE$.toJson(contributors, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), StationContributorLink$.MODULE$.writeContributor())).toString();
        });
    }

    @Inject
    public ReferencialController(LogUtil logUtil, ContactDao contactDao, PiezometerDaeau piezometerDaeau, QualitometerDao qualitometerDao, InstallationDao installationDao, HydrologicalStationDao hydrologicalStationDao, ReferencialDao referencialDao, StationDao stationDao, PluviometerDao pluviometerDao, Database db) {
        this.logUtil = logUtil;
        this.contactDao = contactDao;
        this.piezometerDaeau = piezometerDaeau;
        this.qualitometerDao = qualitometerDao;
        this.installationDao = installationDao;
        this.hydrologicalStationDao = hydrologicalStationDao;
        this.referencialDao = referencialDao;
        this.stationDao = stationDao;
        this.pluviometerDao = pluviometerDao;
        this.db = db;
        this.stationContactReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("contact").read((Reads)ContactInput$.MODULE$.writeContact())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.linksRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.statsRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("typeId").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.contributorsRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("contributorType").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

