/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Envelope;
import dao.searchAnalysis.itf.AnalysisDao;
import dao.searchAnalysis.itf.SampleDao;
import domain.output.AnalysisOutput;
import domain.output.AnalysisOutput$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.rabbitmq.api.LogUtil$;
import fr.aquasys.rabbitmq.api.Producer;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u0006\r\u0001=A\u0001B\t\u0001\u0003\u0002\u0003\u0006Ia\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!A\u0011\u0007\u0001B\u0001B\u0003%!\u0007C\u0003<\u0001\u0011\u0005A\bC\u0004L\u0001\t\u0007I\u0011\u0001'\t\r\u0005\u0004\u0001\u0015!\u0003N\u0011\u001d\u0011\u0007A1A\u0005\u0002\rDaA\u001d\u0001!\u0002\u0013!\u0007\"B:\u0001\t\u0003!\bbBA\u000f\u0001\u0011\u0005\u0011q\u0004\u0002\u0019'\u0016\f'o\u00195B]\u0006d\u0017p]5t\u0007>tGO]8mY\u0016\u0014(\"A\u0007\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0002\u0001'\r\u0001\u0001C\u0006\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005]\u0001S\"\u0001\r\u000b\u0005eQ\u0012aA1qS*\u00111\u0004H\u0001\te\u0006\u0014'-\u001b;nc*\u0011QDH\u0001\bCF,\u0018m]=t\u0015\u0005y\u0012A\u00014s\u0013\t\t\u0003D\u0001\u0005Qe>$WoY3s\u0003-\tg.\u00197zg&\u001cH)Y8\u0011\u0005\u0011ZS\"A\u0013\u000b\u0005\u0019:\u0013aA5uM*\u0011\u0001&K\u0001\u000fg\u0016\f'o\u00195B]\u0006d\u0017p]5t\u0015\u0005Q\u0013a\u00013b_&\u0011A&\n\u0002\f\u0003:\fG._:jg\u0012\u000bw.A\u0005tC6\u0004H.\u001a#b_B\u0011AeL\u0005\u0003a\u0015\u0012\u0011bU1na2,G)Y8\u0002\u001fE,\u0018\r\\5u_6,G/\u001a:EC>\u0004\"aM\u001d\u000e\u0003QR!AJ\u001b\u000b\u0005Y:\u0014aB9vC2LG/\u001f\u0006\u0003qq\tQ\u0001Z1fCVL!A\u000f\u001b\u0003\u001fE+\u0018\r\\5u_6,G/\u001a:EC>\fa\u0001P5oSRtD\u0003B\u001f@\u0001\u0006\u0003\"A\u0010\u0001\u000e\u00031AQA\t\u0003A\u0002\rBQ!\f\u0003A\u00029BQ!\r\u0003A\u0002IB#\u0001B\"\u0011\u0005\u0011KU\"A#\u000b\u0005\u0019;\u0015AB5oU\u0016\u001cGOC\u0001I\u0003\u0015Q\u0017M^1y\u0013\tQUI\u0001\u0004J]*,7\r^\u0001\u000f_B,'/\u0019;j_:\u0014V-\u00193t+\u0005i\u0005c\u0001(W16\tqJ\u0003\u0002Q#\u0006!!n]8o\u0015\t\u00116+\u0001\u0003mS\n\u001c(BA\rU\u0015\u0005)\u0016\u0001\u00029mCfL!aV(\u0003\u000bI+\u0017\rZ:\u0011\tEI6LX\u0005\u00035J\u0011a\u0001V;qY\u0016\u0014\u0004CA\t]\u0013\ti&CA\u0002J]R\u0004\"!E0\n\u0005\u0001\u0014\"A\u0002#pk\ndW-A\bpa\u0016\u0014\u0018\r^5p]J+\u0017\rZ:!\u0003My\u0007/\u001a:bi&|gn\u0012:pkB\u0014V-\u00193t+\u0005!\u0007c\u0001(WKB!\u0011#\u00174_!\r9wn\u0017\b\u0003Q6t!!\u001b7\u000e\u0003)T!a\u001b\b\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0019\u0012B\u00018\u0013\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001]9\u0003\u0007M+\u0017O\u0003\u0002o%\u0005!r\u000e]3sCRLwN\\$s_V\u0004(+Z1eg\u0002\n\u0011d]3be\u000eD\u0017I\\1msNL7o\u00144Pa\u0016\u0014\u0018\r^5p]RAQ/`A\u0003\u0003+\tI\u0002\u0005\u0002wu:\u0011q\u000f\u001f\t\u0003SJI!!\u001f\n\u0002\rA\u0013X\rZ3g\u0013\tYHP\u0001\u0004TiJLgn\u001a\u0006\u0003sJAQA`\u0005A\u0002}\fq!\\3tg\u0006<W\rE\u0002O\u0003\u0003I1!a\u0001P\u0005\u001dQ5OV1mk\u0016Dq!a\u0002\n\u0001\u0004\tI!A\u0004iK\u0006$WM]:\u0011\rY\fY!^A\b\u0013\r\ti\u0001 \u0002\u0004\u001b\u0006\u0004\bcA\t\u0002\u0012%\u0019\u00111\u0003\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0004\u0002\u0018%\u0001\r!^\u0001\u0007[>$W\u000f\\3\t\r\u0005m\u0011\u00021\u0001v\u0003\u0011)8/\u001a:\u0002;\u001d,G/\u00117m\u0003:\fG._:f\u0005f<%o\\;q\u001fB,'/\u0019;j_:$\u0012\"^A\u0011\u0003G\t)#a\n\t\u000byT\u0001\u0019A@\t\u000f\u0005\u001d!\u00021\u0001\u0002\n!1\u0011q\u0003\u0006A\u0002UDa!a\u0007\u000b\u0001\u0004)\bf\u0001\u0001\u0002,A\u0019A)!\f\n\u0007\u0005=RIA\u0005TS:<G.\u001a;p]\u0002")
public class SearchAnalysisController
implements Producer {
    private final AnalysisDao analysisDao;
    private final SampleDao sampleDao;
    private final QualitometerDao qualitometerDao;
    private final Reads<Tuple2<Object, Object>> operationReads;
    private final Reads<Tuple2<Seq<Object>, Object>> operationGroupReads;
    private LogUtil logsUtil;
    private volatile boolean bitmap$0;

    public void sendTopic(String exchangeName, String routingKey, String queueName, String message) {
        Producer.sendTopic$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message);
    }

    public void sendTopic(String routingKey, String message) {
        Producer.sendTopic$((Producer)this, (String)routingKey, (String)message);
    }

    @Deprecated
    public void sendRPC(String exchangeName, String routingKey, String queueName, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)exchangeName, (String)routingKey, (String)queueName, (String)message, consumerFn);
    }

    @Deprecated
    public void sendRPC(String routingKey, String message, Function4<String, Envelope, AMQP.BasicProperties, byte[], BoxedUnit> consumerFn) {
        Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, consumerFn);
    }

    public <A> A sendRPC(String routingKey, String message, Duration timeout, Reads<A> rds, ClassTag<A> m) throws TimeoutException {
        return (A)Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Duration)timeout, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Connection connection, Channel channel, String replyQueueName, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, (Connection)connection, (Channel)channel, (String)replyQueueName, rds, m);
    }

    public <A> Future<A> sendRPC(String routingKey, String message, Reads<A> rds, ClassTag<A> m) {
        return Producer.sendRPC$((Producer)this, (String)routingKey, (String)message, rds, m);
    }

    private LogUtil logsUtil$lzycompute() {
        SearchAnalysisController searchAnalysisController = this;
        synchronized (searchAnalysisController) {
            if (!this.bitmap$0) {
                this.logsUtil = Producer.logsUtil$((Producer)this);
                this.bitmap$0 = true;
            }
        }
        return this.logsUtil;
    }

    public LogUtil logsUtil() {
        if (!this.bitmap$0) {
            return this.logsUtil$lzycompute();
        }
        return this.logsUtil;
    }

    public Reads<Tuple2<Object, Object>> operationReads() {
        return this.operationReads;
    }

    public Reads<Tuple2<Seq<Object>, Object>> operationGroupReads() {
        return this.operationGroupReads;
    }

    public String searchAnalysisOfOperation(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(this.operationReads());
        if (jsResult instanceof JsSuccess) {
            Seq seq;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            Tuple2 param = (Tuple2)jsSuccess.get();
            int idStation = (int)param._2$mcD$sp();
            Option option = this.qualitometerDao.get(idStation);
            if (option instanceof Some) {
                Some some = (Some)option;
                Qualitometer qualitometer = (Qualitometer)some.value();
                LogUtil$.MODULE$.info(new StringBuilder(46).append("Qualitometer with id ").append(qualitometer.id()).append(" found research analysis ").toString(), LogUtil$.MODULE$.info$default$2());
                String bssCode = qualitometer.code();
                seq = (Seq)this.sampleDao.find(param._1$mcI$sp(), param._2$mcD$sp()).flatMap((Function1 & Serializable)s -> {
                    double sampleId = s.id();
                    Seq<AnalysisOutput> allAnalysis = $this.analysisDao.findBySample(sampleId, param._2$mcD$sp(), bssCode);
                    return allAnalysis;
                });
            } else if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.info(new StringBuilder(51).append("No Qualitometer found for id ").append(param._2$mcD$sp()).append(" on research analysis ").toString(), LogUtil$.MODULE$.info$default$2());
                seq = null;
            } else {
                throw new MatchError((Object)option);
            }
            Seq result = seq;
            if (result != null) {
                return Json$.MODULE$.toJson(result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), AnalysisOutput$.MODULE$.analysisOutputWrites())).toString();
            }
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        if (jsResult instanceof JsError) {
            JsError jsError = (JsError)jsResult;
            LogUtil$.MODULE$.error(new StringBuilder(39).append("Error validate Json to get operation :\n").append(JsError$.MODULE$.toJson(jsError).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public String getAllAnalyseByGroupOperation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.operationGroupReads()).fold((Function1 & Serializable)error -> {
            LogUtil$.MODULE$.error(new StringBuilder(42).append("Error validate Json to get all analysis :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), LogUtil$.MODULE$.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Seq seq;
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq ids = (Seq)tuple2._1();
            double idStation = tuple2._2$mcD$sp();
            Tuple2 tuple22 = new Tuple2((Object)ids, (Object)BoxesRunTime.boxToDouble((double)idStation));
            Seq ids2 = (Seq)tuple22._1();
            double idStation2 = tuple22._2$mcD$sp();
            Option option = $this.qualitometerDao.get((int)idStation2);
            if (option instanceof Some) {
                Some some = (Some)option;
                Qualitometer qualito = (Qualitometer)some.value();
                String bssCode = qualito.code();
                seq = (Seq)$this.sampleDao.getAllByOperationGroup((Seq<Object>)ids2, idStation2).flatMap((Function1 & Serializable)s -> {
                    Seq<AnalysisOutput> allAnalysis = $this.analysisDao.findBySample(s.id(), idStation2, bssCode);
                    return allAnalysis;
                });
            } else if (None$.MODULE$.equals(option)) {
                LogUtil$.MODULE$.info(new StringBuilder(51).append("No Qualitometer found for id ").append(idStation2).append(" on research analysis ").toString(), LogUtil$.MODULE$.info$default$2());
                seq = (Seq)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Seq result = seq;
            return Json$.MODULE$.toJson((Object)result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), AnalysisOutput$.MODULE$.analysisOutputWrites())).toString();
        });
    }

    @Inject
    public SearchAnalysisController(AnalysisDao analysisDao, SampleDao sampleDao, QualitometerDao qualitometerDao) {
        this.analysisDao = analysisDao;
        this.sampleDao = sampleDao;
        this.qualitometerDao = qualitometerDao;
        Producer.$init$((Producer)this);
        this.operationReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.DoubleReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.operationGroupReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("ids").read(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.DoubleReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

