/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.inject.Inject;
import fr.aquasys.daeau.distribution_unit.domain.DistributionUnitEvent$;
import fr.aquasys.daeau.hydrometry.domain.HydrologicalEvent$;
import fr.aquasys.daeau.installation.domain.InstallationEvent$;
import fr.aquasys.daeau.piezometry.model.PiezometryEvent$;
import fr.aquasys.daeau.pluviometry.model.PluviometryEvent$;
import fr.aquasys.daeau.production_unit.domain.ProductionUnitEvent$;
import fr.aquasys.daeau.quality.domain.output.QualitometerEventOutput$;
import fr.aquasys.daeau.station.domain.StationRights;
import fr.aquasys.daeau.station.links.accessibilities.Accessibilities$;
import fr.aquasys.daeau.station.links.accessibilities.StationAccessibilitiesDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink$;
import fr.aquasys.daeau.station.links.pointprel.PointPrelDao;
import fr.aquasys.daeau.station.links.stationlink.StationLink$;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDao;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed;
import fr.aquasys.daeau.station.links.stationlink.StationLinkDetailed$;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.Tuple7;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tea\u0001\u0002\u000f\u001e\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006Y\u0001\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0006s!Aq\b\u0001B\u0001B\u0003-\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015a\u0003H\u0011!y\u0005A!A!\u0002\u0017\u0001\u0006\u0002\u0003,\u0001\u0005\u0003\u0005\u000b1B,\t\u000b}\u0003A\u0011\u00011\t\u000fU\u0004!\u0019!C\u0001m\"9\u0011Q\u0002\u0001!\u0002\u00139\b\"CA\b\u0001\t\u0007I\u0011AA\t\u0011!\t\u0019\u0005\u0001Q\u0001\n\u0005M\u0001bBA#\u0001\u0011\u0005\u0011q\t\u0005\b\u0003S\u0002A\u0011AA6\u0011\u001d\t)\b\u0001C\u0001\u0003oBq!a&\u0001\t\u0003\tI\nC\u0004\u0002$\u0002!\t!!*\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u00111\u0018\u0001\u0005\u0002\u0005u\u0006\"CAd\u0001\t\u0007I\u0011AAe\u0011!\t\u0019\u000e\u0001Q\u0001\n\u0005-\u0007bBAk\u0001\u0011\u0005\u0011q\u001b\u0005\n\u0003C\u0004!\u0019!C\u0001\u0003GD\u0001\"!=\u0001A\u0003%\u0011Q\u001d\u0005\b\u0003g\u0004A\u0011AA{\u0011%\ty\u0010\u0001b\u0001\n\u0003\u0011\t\u0001\u0003\u0005\u0003\f\u0001\u0001\u000b\u0011\u0002B\u0002\u0011\u001d\u0011i\u0001\u0001C\u0001\u0005\u001f\u0011Qc\u0015;bi&|g\u000eT5oW\u000e{g\u000e\u001e:pY2,'OC\u0001\u001f\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001!\t\t\u0003E\u0015j\u0011a\t\u0006\u0002I\u0005)1oY1mC&\u0011ae\t\u0002\u0007\u0003:L(+\u001a4\u0002\u001dM$\u0018\r^5p]2Kgn\u001b#b_B\u0011\u0011FN\u0007\u0002U)\u00111\u0006L\u0001\fgR\fG/[8oY&t7N\u0003\u0002.]\u0005)A.\u001b8lg*\u0011q\u0006M\u0001\bgR\fG/[8o\u0015\t\t$'A\u0003eC\u0016\fWO\u0003\u00024i\u00059\u0011-];bgf\u001c(\"A\u001b\u0002\u0005\u0019\u0014\u0018BA\u001c+\u00059\u0019F/\u0019;j_:d\u0015N\\6EC>\fQc\u001d;bi&|gnQ8oiJL'-\u001e;pe\u0012\u000bw\u000e\u0005\u0002;{5\t1H\u0003\u0002=Y\u0005Y1m\u001c8ue&\u0014W\u000f^8s\u0013\tq4HA\u000bTi\u0006$\u0018n\u001c8D_:$(/\u001b2vi>\u0014H)Y8\u00023M$\u0018\r^5p]\u0006\u001b7-Z:tS\nLG.\u001b;jKN$\u0015m\u001c\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u00072\nq\"Y2dKN\u001c\u0018NY5mSRLWm]\u0005\u0003\u000b\n\u0013\u0011d\u0015;bi&|g.Q2dKN\u001c\u0018NY5mSRLWm\u001d#b_\u0006qQo]3s'R\fG/[8o\t\u0006|\u0007C\u0001%N\u001b\u0005I%B\u0001&L\u0003\rIGO\u001a\u0006\u0003\u0019B\nA!^:fe&\u0011a*\u0013\u0002\u000f+N,'o\u0015;bi&|g\u000eR1p\u00031\u0001v.\u001b8u!J,G\u000eR1p!\t\tF+D\u0001S\u0015\t\u0019F&A\u0005q_&tG\u000f\u001d:fY&\u0011QK\u0015\u0002\r!>Lg\u000e\u001e)sK2$\u0015m\\\u0001\bY><W\u000b^5m!\tAV,D\u0001Z\u0015\tQ6,\u0001\u0003vi&d'B\u0001/3\u0003!\u0011\u0018M\u00192ji6\f\u0018B\u00010Z\u0005\u001daunZ+uS2\fa\u0001P5oSRtD#A1\u0015\u000f\t$WMZ4iSB\u00111\rA\u0007\u0002;!)qe\u0002a\u0002Q!)\u0001h\u0002a\u0002s!)qh\u0002a\u0002\u0001\")ai\u0002a\u0002\u000f\")qj\u0002a\u0002!\")ak\u0002a\u0002/\"\u0012qa\u001b\t\u0003YNl\u0011!\u001c\u0006\u0003]>\fa!\u001b8kK\u000e$(B\u00019r\u0003\u00199wn\\4mK*\t!/A\u0002d_6L!\u0001^7\u0003\r%s'.Z2u\u0003=\u0019H/\u0019;j_:$\u0016\u0010]3SK\u0006$W#A<\u0011\u000ba\f\u0019!a\u0002\u000e\u0003eT!A_>\u0002\t)\u001cxN\u001c\u0006\u0003yv\fA\u0001\\5cg*\u0011ap`\u0001\u0004CBL'BAA\u0001\u0003\u0011\u0001H.Y=\n\u0007\u0005\u0015\u0011PA\u0003SK\u0006$7\u000fE\u0002#\u0003\u0013I1!a\u0003$\u0005\rIe\u000e^\u0001\u0011gR\fG/[8o)f\u0004XMU3bI\u0002\n\u0001c\u001d;bi&|g\u000eT5oWJ+\u0017\rZ:\u0016\u0005\u0005M\u0001#\u0002=\u0002\u0004\u0005U\u0001#\u0004\u0012\u0002\u0018\u0005m\u00111DA\u0019\u0003o\tY\"C\u0002\u0002\u001a\r\u0012a\u0001V;qY\u0016,\u0004\u0003BA\u000f\u0003WqA!a\b\u0002(A\u0019\u0011\u0011E\u0012\u000e\u0005\u0005\r\"bAA\u0013?\u00051AH]8pizJ1!!\u000b$\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011F\u0012\u0011\u0007\t\n\u0019$C\u0002\u00026\r\u0012A\u0001T8oOB)!%!\u000f\u0002>%\u0019\u00111H\u0012\u0003\r=\u0003H/[8o!\r\u0011\u0013qH\u0005\u0004\u0003\u0003\u001a#a\u0002\"p_2,\u0017M\\\u0001\u0012gR\fG/[8o\u0019&t7NU3bIN\u0004\u0013AD4fiN#\u0018\r^5p]2Kgn\u001b\u000b\u000b\u00037\tI%a\u0015\u0002d\u0005\u001d\u0004bBA&\u0019\u0001\u0007\u0011QJ\u0001\b[\u0016\u001c8/Y4f!\rA\u0018qJ\u0005\u0004\u0003#J(a\u0002&t-\u0006dW/\u001a\u0005\b\u0003+b\u0001\u0019AA,\u0003\u001dAW-\u00193feN\u0004\u0002\"!\b\u0002Z\u0005m\u0011QL\u0005\u0005\u00037\nyCA\u0002NCB\u00042AIA0\u0013\r\t\tg\t\u0002\u0004\u0003:L\bbBA3\u0019\u0001\u0007\u00111D\u0001\u0007[>$W\u000f\\3\t\r1c\u0001\u0019AA\u000e\u0003Q9W\r\u001e#fKB,'o\u0015;bi&|g\u000eT5oWRQ\u00111DA7\u0003_\n\t(a\u001d\t\u000f\u0005-S\u00021\u0001\u0002N!9\u0011QK\u0007A\u0002\u0005]\u0003bBA3\u001b\u0001\u0007\u00111\u0004\u0005\u0007\u00196\u0001\r!a\u0007\u00027\u0019LG\u000e^3s\u0019&t7n],ji\"\f5mY3tgJKw\r\u001b;t)!\tI(!%\u0002\u0014\u0006U\u0005CBA>\u0003\u000b\u000bYI\u0004\u0003\u0002~\u0005\u0005e\u0002BA\u0011\u0003\u007fJ\u0011\u0001J\u0005\u0004\u0003\u0007\u001b\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003\u000f\u000bIIA\u0002TKFT1!a!$!\rI\u0013QR\u0005\u0004\u0003\u001fS#aE*uCRLwN\u001c'j].$U\r^1jY\u0016$\u0007B\u0002'\u000f\u0001\u0004\tY\u0002\u0003\u0004.\u001d\u0001\u0007\u0011\u0011\u0010\u0005\b\u0003Kr\u0001\u0019AA\u000e\u00039\tG\rZ*uCRLwN\u001c'j].$\"\"a\u0007\u0002\u001c\u0006u\u0015qTAQ\u0011\u001d\tYe\u0004a\u0001\u0003\u001bBq!!\u0016\u0010\u0001\u0004\t9\u0006C\u0004\u0002f=\u0001\r!a\u0007\t\r1{\u0001\u0019AA\u000e\u0003E!W\r\\3uKN#\u0018\r^5p]2Kgn\u001b\u000b\u000b\u00037\t9+!+\u0002,\u00065\u0006bBA&!\u0001\u0007\u0011Q\n\u0005\b\u0003+\u0002\u0002\u0019AA,\u0011\u001d\t)\u0007\u0005a\u0001\u00037Aa\u0001\u0014\tA\u0002\u0005m\u0011AF4fi\u0006cGnQ8oiJL'-\u001e;pe2Kgn[:\u0015\u0015\u0005m\u00111WA[\u0003o\u000bI\fC\u0004\u0002LE\u0001\r!!\u0014\t\u000f\u0005U\u0013\u00031\u0001\u0002X!9\u0011QM\tA\u0002\u0005m\u0001B\u0002'\u0012\u0001\u0004\tY\"A\rhKR\fE\u000e\\!dG\u0016\u001c8/\u001b2mSRLWm\u001d'j].\u001cHCCA\u000e\u0003\u007f\u000b\t-a1\u0002F\"9\u00111\n\nA\u0002\u00055\u0003bBA+%\u0001\u0007\u0011q\u000b\u0005\b\u0003K\u0012\u0002\u0019AA\u000e\u0011\u0019a%\u00031\u0001\u0002\u001c\u000512m\u001c3f\u0003:$7\u000b^1uS>tG+\u001f9f%\u0016\fG-\u0006\u0002\u0002LB)\u00010a\u0001\u0002NB9!%a4\u0002\u001c\u0005\u001d\u0011bAAiG\t1A+\u001e9mKJ\nqcY8eK\u0006sGm\u0015;bi&|g\u000eV=qKJ+\u0017\r\u001a\u0011\u0002-\u001d,G\u000fT5oW\u0016$7\u000b^1uS>tWI^3oiN$\"\"a\u0007\u0002Z\u0006m\u0017Q\\Ap\u0011\u001d\tY%\u0006a\u0001\u0003\u001bBq!!\u0016\u0016\u0001\u0004\t9\u0006C\u0004\u0002fU\u0001\r!a\u0007\t\r1+\u0002\u0019AA\u000e\u0003=9W\r^!mYB\u0013x\u000e\u001a*fC\u0012\u001cXCAAs!\u0015A\u00181AAt!-\u0011\u0013\u0011^A\u0004\u0003[\fY\"a\u0007\n\u0007\u0005-8E\u0001\u0004UkBdW\r\u000e\t\u0006E\u0005e\u0012q\u001e\t\u0007\u0003w\n))a\u0002\u0002!\u001d,G/\u00117m!J|GMU3bIN\u0004\u0013AE4fi\u0006cGn\u0015;bi&|g\u000eT5oWN$\"\"a\u0007\u0002x\u0006e\u00181`A\u007f\u0011\u001d\tY\u0005\u0007a\u0001\u0003\u001bBq!!\u0016\u0019\u0001\u0004\t9\u0006C\u0004\u0002fa\u0001\r!a\u0007\t\r1C\u0002\u0019AA\u000e\u00039\u0001(/\u001a7ECR\fW\t_5tiN,\"Aa\u0001\u0011\u000ba\f\u0019A!\u0002\u0011\u0013\t\u00129!a\u0007\u0002\b\u0005\u001d\u0011b\u0001B\u0005G\t1A+\u001e9mKN\nq\u0002\u001d:fY\u0012\u000bG/Y#ySN$8\u000fI\u0001\u0015m\u0016\u0014\u0018NZ=Qe\u0016dG)\u0019;b\u000bbL7\u000f^:\u0015\u0015\u0005m!\u0011\u0003B\n\u0005+\u00119\u0002C\u0004\u0002Lm\u0001\r!!\u0014\t\u000f\u0005U3\u00041\u0001\u0002X!9\u0011QM\u000eA\u0002\u0005m\u0001B\u0002'\u001c\u0001\u0004\tY\u0002")
public class StationLinkController {
    private final StationLinkDao stationLinkDao;
    private final StationContributorDao stationContributorDao;
    private final StationAccessibilitiesDao stationAccessibilitiesDao;
    private final UserStationDao userStationDao;
    private final PointPrelDao PointPrelDao;
    private final LogUtil logUtil;
    private final Reads<Object> stationTypeRead;
    private final Reads<Tuple5<String, String, Object, Option<Object>, String>> stationLinkReads;
    private final Reads<Tuple2<String, Object>> codeAndStationTypeRead;
    private final Reads<Tuple4<Object, Option<Seq<Object>>, String, String>> getAllProdReads;
    private final Reads<Tuple3<String, Object, Object>> prelDataExists;

    public Reads<Object> stationTypeRead() {
        return this.stationTypeRead;
    }

    public Reads<Tuple5<String, String, Object, Option<Object>, String>> stationLinkReads() {
        return this.stationLinkReads;
    }

    public String getStationLink(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.stationLinkReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't read id and stationType from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple5 tuple5 = params;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            String user = (String)tuple5._1();
            String code = (String)tuple5._2();
            long stationType = BoxesRunTime.unboxToLong((Object)tuple5._3());
            Option lightMode = (Option)tuple5._4();
            String module = (String)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)user, (Object)code, (Object)BoxesRunTime.boxToLong((long)stationType), (Object)lightMode, (Object)module);
            String user2 = (String)tuple52._1();
            String code2 = (String)tuple52._2();
            long stationType2 = BoxesRunTime.unboxToLong((Object)tuple52._3());
            Option lightMode2 = (Option)tuple52._4();
            String module2 = (String)tuple52._5();
            Seq allLinks = $this.stationLinkDao.get(code2, stationType2);
            Seq<StationLinkDetailed> links = this.filterLinksWithAccessRights(user2, (Seq<StationLinkDetailed>)allLinks, module2);
            if (lightMode2.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)links.map((Function1 & Serializable)l -> l.toStringLight())).mkString(",")).append("]").toString();
            }
            return Json$.MODULE$.toJson(links, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationLinkDetailed$.MODULE$.format())).toString();
        });
    }

    public String getDeeperStationLink(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.stationLinkReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't read id and stationType from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple5 tuple5 = params;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            String user = (String)tuple5._1();
            String code = (String)tuple5._2();
            long stationType = BoxesRunTime.unboxToLong((Object)tuple5._3());
            Option lightMode = (Option)tuple5._4();
            String module = (String)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)user, (Object)code, (Object)BoxesRunTime.boxToLong((long)stationType), (Object)lightMode, (Object)module);
            String user2 = (String)tuple52._1();
            String code2 = (String)tuple52._2();
            long stationType2 = BoxesRunTime.unboxToLong((Object)tuple52._3());
            Option lightMode2 = (Option)tuple52._4();
            String module2 = (String)tuple52._5();
            Seq allLinks = $this.stationLinkDao.getDeeper(code2, stationType2);
            Seq<StationLinkDetailed> links = this.filterLinksWithAccessRights(user2, (Seq<StationLinkDetailed>)allLinks, module2);
            if (lightMode2.contains((Object)BoxesRunTime.boxToBoolean((boolean)true))) {
                return new StringBuilder(2).append("[").append(((IterableOnceOps)links.map((Function1 & Serializable)l -> l.toStringLight())).mkString(",")).append("]").toString();
            }
            return Json$.MODULE$.toJson(links, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationLinkDetailed$.MODULE$.format())).toString();
        });
    }

    public Seq<StationLinkDetailed> filterLinksWithAccessRights(String user, Seq<StationLinkDetailed> links, String module) {
        return (Seq)links.groupBy((Function1 & Serializable)x$3 -> x$3.typeName()).values().toSeq().flatMap((Function1 & Serializable)listStations -> {
            Seq ids;
            Seq seq;
            String string = StationTypeUtil$.MODULE$.StationType(((StationLinkDetailed)listStations.head()).typeName());
            String string2 = StationTypeUtil$.MODULE$.QUALITY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                seq = (Seq)CommonReadUtil$.MODULE$.getAllowedQualitometerIds(user, (Seq)listStations.map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)x$4.stationLinkedId())), module, $this.userStationDao).map((Function1)(JFunction1.mcJD.sp & Serializable)x$5 -> (int)x$5);
            } else {
                String string4 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    seq = (Seq)CommonReadUtil$.MODULE$.getAllowedPiezoIds(user, (Seq)listStations.map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToInteger((int)StationLinkController.$anonfun$filterLinksWithAccessRights$5(x$6))), module, $this.userStationDao).map((Function1)(JFunction1.mcJI.sp & Serializable)x$7 -> x$7);
                } else {
                    String string6 = StationTypeUtil$.MODULE$.HYDROMETRY();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        seq = (Seq)CommonReadUtil$.MODULE$.getAllowedHydroIds(user, (Seq)listStations.map((Function1 & Serializable)x$8 -> BoxesRunTime.boxToInteger((int)StationLinkController.$anonfun$filterLinksWithAccessRights$7(x$8))), module, $this.userStationDao).map((Function1)(JFunction1.mcJI.sp & Serializable)x$9 -> x$9);
                    } else {
                        String string8 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            seq = (Seq)CommonReadUtil$.MODULE$.getAllowedPluvioIds(user, (Seq)listStations.map((Function1 & Serializable)x$10 -> BoxesRunTime.boxToInteger((int)StationLinkController.$anonfun$filterLinksWithAccessRights$9(x$10))), module, $this.userStationDao).map((Function1)(JFunction1.mcJI.sp & Serializable)x$11 -> x$11);
                        } else {
                            String string10 = StationTypeUtil$.MODULE$.INSTALLATION();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                seq = CommonReadUtil$.MODULE$.getAllowedInstallationIds(user, (Seq)listStations.map((Function1 & Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.stationLinkedId())), module, $this.userStationDao);
                            } else {
                                String string12 = StationTypeUtil$.MODULE$.PRODUCTION();
                                String string13 = string;
                                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                    seq = (Seq)CommonReadUtil$.MODULE$.getAllowedProductionUnitIds(user, (Seq)listStations.map((Function1 & Serializable)x$13 -> BoxesRunTime.boxToInteger((int)StationLinkController.$anonfun$filterLinksWithAccessRights$12(x$13))), module, $this.userStationDao).map((Function1)(JFunction1.mcJI.sp & Serializable)x$14 -> x$14);
                                } else {
                                    String string14 = StationTypeUtil$.MODULE$.DISTRIBUTION();
                                    String string15 = string;
                                    if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                        seq = (Seq)CommonReadUtil$.MODULE$.getAllowedUDIIds(user, (Seq)listStations.map((Function1 & Serializable)x$15 -> BoxesRunTime.boxToInteger((int)StationLinkController.$anonfun$filterLinksWithAccessRights$14(x$15))), module, $this.userStationDao).map((Function1)(JFunction1.mcJI.sp & Serializable)x$16 -> x$16);
                                    } else {
                                        String string16 = StationTypeUtil$.MODULE$.RESOURCE();
                                        String string17 = string;
                                        seq = !(string16 != null ? !string16.equals(string17) : string17 != null) ? (Seq)CommonReadUtil$.MODULE$.getAllowedResourceIds(user, (Seq)listStations.map((Function1 & Serializable)x$17 -> BoxesRunTime.boxToInteger((int)StationLinkController.$anonfun$filterLinksWithAccessRights$16(x$17))), module, $this.userStationDao).map((Function1)(JFunction1.mcJI.sp & Serializable)x$18 -> x$18) : (ids = (Seq)listStations.map((Function1 & Serializable)x$19 -> BoxesRunTime.boxToLong((long)x$19.stationLinkedId())));
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (ids.length() == listStations.length()) {
                return listStations;
            }
            if (ids.isEmpty()) {
                return Nil$.MODULE$;
            }
            return (IterableOnce)listStations.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)ids.contains((Object)BoxesRunTime.boxToLong((long)s.stationLinkedId()))));
        });
    }

    public String addStationLink(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)StationLink$.MODULE$.stationLinkFormat()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate station link from json input.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)link -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.stationLinkDao.add(link)), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String deleteStationLink(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)StationLink$.MODULE$.stationLinkFormat()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate station link from json input.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)link -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.stationLinkDao.delete(link)), (Writes)Writes$.MODULE$.IntWrites()))})).toString());
    }

    public String getAllContributorLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.stationTypeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get stationType from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> StationLinkController.$anonfun$getAllContributorLinks$2(this, BoxesRunTime.unboxToInt((Object)params)));
    }

    public String getAllAccessiblitiesLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.stationTypeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get stationType from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> StationLinkController.$anonfun$getAllAccessiblitiesLinks$2(this, BoxesRunTime.unboxToInt((Object)params)));
    }

    public Reads<Tuple2<String, Object>> codeAndStationTypeRead() {
        return this.codeAndStationTypeRead;
    }

    public String getLinkedStationEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.codeAndStationTypeRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get code and/or stationType from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String code = (String)tuple2._1();
            int stationType = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)code, (Object)BoxesRunTime.boxToInteger((int)stationType));
            String code2 = (String)tuple22._1();
            int stationType2 = tuple22._2$mcI$sp();
            Tuple7 tuple7 = $this.stationLinkDao.getStationEvents(code2, (long)stationType2);
            if (tuple7 == null) {
                throw new MatchError((Object)tuple7);
            }
            Seq qualito = (Seq)tuple7._1();
            Seq piezo = (Seq)tuple7._2();
            Seq hydro = (Seq)tuple7._3();
            Seq pluvio = (Seq)tuple7._4();
            Seq instal = (Seq)tuple7._5();
            Seq unitProd = (Seq)tuple7._6();
            Seq distriUnit = (Seq)tuple7._7();
            Tuple7 tuple72 = new Tuple7((Object)qualito, (Object)piezo, (Object)hydro, (Object)pluvio, (Object)instal, (Object)unitProd, (Object)distriUnit);
            Seq qualito2 = (Seq)tuple72._1();
            Seq piezo2 = (Seq)tuple72._2();
            Seq hydro2 = (Seq)tuple72._3();
            Seq pluvio2 = (Seq)tuple72._4();
            Seq instal2 = (Seq)tuple72._5();
            Seq unitProd2 = (Seq)tuple72._6();
            Seq distriUnit2 = (Seq)tuple72._7();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"quality"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)qualito2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualitometerEventOutput$.MODULE$.qualitometerEvent()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"piezometry"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)piezo2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PiezometryEvent$.MODULE$.piezometryEventFormat()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hydrometry"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)hydro2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), HydrologicalEvent$.MODULE$.hydrologicalEventWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pluviometry"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)pluvio2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)PluviometryEvent$.MODULE$.format()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"installation"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)instal2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)InstallationEvent$.MODULE$.installationEventWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"productionUnit"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)unitProd2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)ProductionUnitEvent$.MODULE$.installationEventWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"distributionUnit"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)distriUnit2, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)DistributionUnitEvent$.MODULE$.format())))})).toString();
        });
    }

    public Reads<Tuple4<Object, Option<Seq<Object>>, String, String>> getAllProdReads() {
        return this.getAllProdReads;
    }

    public String getAllStationLinks(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.getAllProdReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get stationType from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple4 tuple4 = params;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            int stationType = BoxesRunTime.unboxToInt((Object)tuple4._1());
            Option ids = (Option)tuple4._2();
            String user = (String)tuple4._3();
            String module = (String)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)stationType), (Object)ids, (Object)user, (Object)module);
            int stationType2 = BoxesRunTime.unboxToInt((Object)tuple42._1());
            Option ids2 = (Option)tuple42._2();
            String user2 = (String)tuple42._3();
            String module2 = (String)tuple42._4();
            StationRights rights = $this.userStationDao.getAllAvailableStation(user2, module2);
            return new StringBuilder(2).append("[").append(((IterableOnceOps)$this.stationLinkDao.getAllStationLinks(stationType2, ids2, rights).map((Function1 & Serializable)l -> l.toStringLight())).mkString(",")).append("]").toString();
        });
    }

    public Reads<Tuple3<String, Object, Object>> prelDataExists() {
        return this.prelDataExists;
    }

    public String verifyPrelDataExists(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.prelDataExists()).fold((Function1 & Serializable)x$23 -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "bad input for verifyPrelDataExists", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String stationType = (String)tuple3._1();
            int idStation = BoxesRunTime.unboxToInt((Object)tuple3._2());
            int codepoint = BoxesRunTime.unboxToInt((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)stationType, (Object)BoxesRunTime.boxToInteger((int)idStation), (Object)BoxesRunTime.boxToInteger((int)codepoint));
            String stationType2 = (String)tuple32._1();
            int idStation2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int codepoint2 = BoxesRunTime.unboxToInt((Object)tuple32._3());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exists"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)$this.PointPrelDao.prelDataExists(stationType2, idStation2, codepoint2)), (Writes)Writes$.MODULE$.BooleanWrites()))})).toString();
        });
    }

    public static final /* synthetic */ int $anonfun$filterLinksWithAccessRights$5(StationLinkDetailed x$6) {
        return (int)x$6.stationLinkedId();
    }

    public static final /* synthetic */ int $anonfun$filterLinksWithAccessRights$7(StationLinkDetailed x$8) {
        return (int)x$8.stationLinkedId();
    }

    public static final /* synthetic */ int $anonfun$filterLinksWithAccessRights$9(StationLinkDetailed x$10) {
        return (int)x$10.stationLinkedId();
    }

    public static final /* synthetic */ int $anonfun$filterLinksWithAccessRights$12(StationLinkDetailed x$13) {
        return (int)x$13.stationLinkedId();
    }

    public static final /* synthetic */ int $anonfun$filterLinksWithAccessRights$14(StationLinkDetailed x$15) {
        return (int)x$15.stationLinkedId();
    }

    public static final /* synthetic */ int $anonfun$filterLinksWithAccessRights$16(StationLinkDetailed x$17) {
        return (int)x$17.stationLinkedId();
    }

    public static final /* synthetic */ String $anonfun$getAllContributorLinks$2(StationLinkController $this, int params) {
        return Json$.MODULE$.toJson((Object)$this.stationContributorDao.getAll(Integer.toString(params)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)StationContributorLink$.MODULE$.qualitometereContributorLinkFormat())).toString();
    }

    public static final /* synthetic */ String $anonfun$getAllAccessiblitiesLinks$2(StationLinkController $this, int params) {
        return Json$.MODULE$.toJson((Object)$this.stationAccessibilitiesDao.getAll(Integer.toString(params)), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Accessibilities$.MODULE$.accessibilitesWrites())).toString();
    }

    @Inject
    public StationLinkController(StationLinkDao stationLinkDao, StationContributorDao stationContributorDao, StationAccessibilitiesDao stationAccessibilitiesDao, UserStationDao userStationDao, PointPrelDao PointPrelDao2, LogUtil logUtil) {
        this.stationLinkDao = stationLinkDao;
        this.stationContributorDao = stationContributorDao;
        this.stationAccessibilitiesDao = stationAccessibilitiesDao;
        this.userStationDao = userStationDao;
        this.PointPrelDao = PointPrelDao2;
        this.logUtil = logUtil;
        this.stationTypeRead = JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.IntReads());
        this.stationLinkReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.LongReads())).and((Object)JsPath$.MODULE$.$bslash("lightMode").readNullable((Reads)Reads$.MODULE$.BooleanReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.codeAndStationTypeRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.getAllProdReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("ids").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.prelDataExists = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("idStation").read((Reads)Reads$.MODULE$.IntReads())).and((Object)JsPath$.MODULE$.$bslash("codepoint").read((Reads)Reads$.MODULE$.IntReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

