/*
 * Decompiled with CFR 0.152.
 */
package controllers.campaign;

import fr.aquasys.daeau.campaign.domain.CampaignQueryParams;
import fr.aquasys.daeau.campaign.domain.CampaignQueryParams$;
import fr.aquasys.daeau.campaign.domain.CampaignVisit$;
import fr.aquasys.daeau.campaign.domain.PlanningProgress$;
import fr.aquasys.daeau.campaign.domain.input.CampaignInput;
import fr.aquasys.daeau.campaign.domain.input.CampaignInput$;
import fr.aquasys.daeau.campaign.domain.input.QualityCampaignInput;
import fr.aquasys.daeau.campaign.domain.input.QualityCampaignInput$;
import fr.aquasys.daeau.campaign.domain.output.CampaignOutput;
import fr.aquasys.daeau.campaign.domain.output.CampaignOutput$;
import fr.aquasys.daeau.campaign.domain.output.CampaignProgressionOutput;
import fr.aquasys.daeau.campaign.domain.output.CampaignProgressionOutput$;
import fr.aquasys.daeau.campaign.itf.CampaignDao;
import fr.aquasys.daeau.campaign.itf.VisitDao;
import fr.aquasys.daeau.campaign.model.Campaign$;
import fr.aquasys.daeau.campaign.model.CampaignAction$;
import fr.aquasys.daeau.campaign.model.CampaignInstallationWithStats$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t%a\u0001\u0002\u0010 \u0001\u0011B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006Y\u0001\f\u0005\ts\u0001\u0011\t\u0011)A\u0006u!A!\t\u0001B\u0001B\u0003-1\tC\u0003G\u0001\u0011\u0005q\tC\u0003X\u0001\u0011\u0005\u0001\fC\u0003\u007f\u0001\u0011\u0005q\u0010C\u0004\u0002\n\u0001!\t!a\u0003\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0017\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000fBq!!\u0015\u0001\t\u0003\t\u0019\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005%\u0004\u0001\"\u0001\u0002l!I\u0011Q\u000f\u0001C\u0002\u0013\u0005\u0011q\u000f\u0005\t\u0003#\u0003\u0001\u0015!\u0003\u0002z!9\u00111\u0013\u0001\u0005\u0002\u0005U\u0005\"CAP\u0001\t\u0007I\u0011AAQ\u0011!\t)\u000b\u0001Q\u0001\n\u0005\r\u0006bBAT\u0001\u0011\u0005\u0011\u0011\u0016\u0005\n\u0003g\u0003!\u0019!C\u0001\u0003kC\u0001\"a/\u0001A\u0003%\u0011q\u0017\u0005\b\u0003{\u0003A\u0011AA`\u0011%\tI\r\u0001b\u0001\n\u0003\tY\r\u0003\u0005\u0002d\u0002\u0001\u000b\u0011BAg\u0011\u001d\t)\u000f\u0001C\u0001\u0003ODq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0002~\u0002!\t!a@\u0003%\r\u000bW\u000e]1jO:\u001cuN\u001c;s_2dWM\u001d\u0006\u0003A\u0005\n\u0001bY1na\u0006LwM\u001c\u0006\u0002E\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\u0013\u0011\u0005\u0019JS\"A\u0014\u000b\u0003!\nQa]2bY\u0006L!AK\u0014\u0003\r\u0005s\u0017PU3g\u0003-\u0019\u0017-\u001c9bS\u001etG)Y8\u0011\u00055:T\"\u0001\u0018\u000b\u0005=\u0002\u0014aA5uM*\u0011\u0001%\r\u0006\u0003eM\nQ\u0001Z1fCVT!\u0001N\u001b\u0002\u000f\u0005\fX/Y:zg*\ta'\u0001\u0002ge&\u0011\u0001H\f\u0002\f\u0007\u0006l\u0007/Y5h]\u0012\u000bw.A\u0004m_\u001e,F/\u001b7\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014\u0001B;uS2T!aP\u001a\u0002\u0011I\f'MY5u[FL!!\u0011\u001f\u0003\u000f1{w-\u0016;jY\u0006Aa/[:ji\u0012\u000bw\u000e\u0005\u0002.\t&\u0011QI\f\u0002\t-&\u001c\u0018\u000e\u001e#b_\u00061A(\u001b8jiz\"\u0012\u0001\u0013\u000b\u0005\u0013.cU\n\u0005\u0002K\u00015\tq\u0004C\u0003,\t\u0001\u000fA\u0006C\u0003:\t\u0001\u000f!\bC\u0003C\t\u0001\u000f1\t\u000b\u0002\u0005\u001fB\u0011\u0001+V\u0007\u0002#*\u0011!kU\u0001\u0007S:TWm\u0019;\u000b\u0003Q\u000bQA[1wCbL!AV)\u0003\r%s'.Z2u\u0003\u00199W\r^!mYR)\u0011\f\u001a:{yB\u0011!,\u0019\b\u00037~\u0003\"\u0001X\u0014\u000e\u0003uS!AX\u0012\u0002\rq\u0012xn\u001c;?\u0013\t\u0001w%\u0001\u0004Qe\u0016$WMZ\u0005\u0003E\u000e\u0014aa\u0015;sS:<'B\u00011(\u0011\u0015)W\u00011\u0001g\u0003\u001diWm]:bO\u0016\u0004\"a\u001a9\u000e\u0003!T!!\u001b6\u0002\t)\u001cxN\u001c\u0006\u0003W2\fA\u0001\\5cg*\u0011QN\\\u0001\u0004CBL'\"A8\u0002\tAd\u0017-_\u0005\u0003c\"\u0014qAS:WC2,X\rC\u0003t\u000b\u0001\u0007A/A\u0004iK\u0006$WM]:\u0011\ti+\u0018l^\u0005\u0003m\u000e\u00141!T1q!\t1\u00030\u0003\u0002zO\t\u0019\u0011I\\=\t\u000bm,\u0001\u0019A-\u0002\r5|G-\u001e7f\u0011\u0015iX\u00011\u0001Z\u0003\u0011)8/\u001a:\u0002\u0007\u001d,G\u000fF\u0005Z\u0003\u0003\t\u0019!!\u0002\u0002\b!)QM\u0002a\u0001M\")1O\u0002a\u0001i\")1P\u0002a\u00013\")QP\u0002a\u00013\u0006aq-\u001a;CsN#\u0018\r^5p]RI\u0011,!\u0004\u0002\u0010\u0005E\u00111\u0003\u0005\u0006K\u001e\u0001\rA\u001a\u0005\u0006g\u001e\u0001\r\u0001\u001e\u0005\u0006w\u001e\u0001\r!\u0017\u0005\u0006{\u001e\u0001\r!W\u0001\u0007S:\u001cXM\u001d;\u0015\u0013e\u000bI\"a\u0007\u0002\u001e\u0005}\u0001\"B3\t\u0001\u00041\u0007\"B:\t\u0001\u0004!\b\"B>\t\u0001\u0004I\u0006\"B?\t\u0001\u0004I\u0016!D5og\u0016\u0014H/U;bY&$\u0018\u0010F\u0005Z\u0003K\t9#!\u000b\u0002,!)Q-\u0003a\u0001M\")1/\u0003a\u0001i\")10\u0003a\u00013\")Q0\u0003a\u00013\u00061Q\u000f\u001d3bi\u0016$\u0012\"WA\u0019\u0003g\t)$a\u000e\t\u000b\u0015T\u0001\u0019\u00014\t\u000bMT\u0001\u0019\u0001;\t\u000bmT\u0001\u0019A-\t\u000buT\u0001\u0019A-\u0002\u001bU\u0004H-\u0019;f#V\fG.\u001b;z)%I\u0016QHA \u0003\u0003\n\u0019\u0005C\u0003f\u0017\u0001\u0007a\rC\u0003t\u0017\u0001\u0007A\u000fC\u0003|\u0017\u0001\u0007\u0011\fC\u0003~\u0017\u0001\u0007\u0011,\u0001\u0004eK2,G/\u001a\u000b\n3\u0006%\u00131JA'\u0003\u001fBQ!\u001a\u0007A\u0002\u0019DQa\u001d\u0007A\u0002QDQa\u001f\u0007A\u0002eCQ! \u0007A\u0002e\u000bAcZ3u\u0007\u0006l\u0007/Y5h]N\u0004&o\\4sKN\u001cH#C-\u0002V\u0005]\u0013\u0011LA.\u0011\u0015)W\u00021\u0001g\u0011\u0015\u0019X\u00021\u0001u\u0011\u0015YX\u00021\u0001Z\u0011\u0015iX\u00021\u0001Z\u0003M9W\r^\"b[B\f\u0017n\u001a8Qe><'/Z:t)%I\u0016\u0011MA2\u0003K\n9\u0007C\u0003f\u001d\u0001\u0007a\rC\u0003t\u001d\u0001\u0007A\u000fC\u0003|\u001d\u0001\u0007\u0011\fC\u0003~\u001d\u0001\u0007\u0011,\u0001\nhKR\fV/\u00197jif4u\u000e\u001c7poV\u0003H#C-\u0002n\u0005=\u0014\u0011OA:\u0011\u0015)w\u00021\u0001g\u0011\u0015\u0019x\u00021\u0001u\u0011\u0015Yx\u00021\u0001Z\u0011\u0015ix\u00021\u0001Z\u0003M\u0011X-\u00193DC6\u0004\u0018-[4o\u0003:$\u0007\u000b\\1o+\t\tI\bE\u0003h\u0003w\ny(C\u0002\u0002~!\u0014QAU3bIN\u0004rAJAA\u0003\u000b\u000bY)C\u0002\u0002\u0004\u001e\u0012a\u0001V;qY\u0016\u0014\u0004c\u0001\u0014\u0002\b&\u0019\u0011\u0011R\u0014\u0003\r\u0011{WO\u00197f!\r1\u0013QR\u0005\u0004\u0003\u001f;#\u0001\u0002'p]\u001e\fAC]3bI\u000e\u000bW\u000e]1jO:\fe\u000e\u001a)mC:\u0004\u0013aE4fiBc\u0017M\u001c8j]\u001e4u\u000e\u001c7poV\u0003H#C-\u0002\u0018\u0006e\u00151TAO\u0011\u0015)'\u00031\u0001g\u0011\u0015\u0019(\u00031\u0001u\u0011\u0015Y(\u00031\u0001Z\u0011\u0015i(\u00031\u0001Z\u0003)IGmQ1na\u0006LwM\\\u000b\u0003\u0003G\u0003RaZA>\u0003\u0017\u000b1\"\u001b3DC6\u0004\u0018-[4oA\u0005\tr-\u001a;DC6\u0004\u0018-[4o-&\u001c\u0018\u000e^:\u0015\u0013e\u000bY+!,\u00020\u0006E\u0006\"B3\u0016\u0001\u00041\u0007\"B:\u0016\u0001\u0004!\b\"B>\u0016\u0001\u0004I\u0006\"B?\u0016\u0001\u0004I\u0016!G5e\u0013:\u001cH/\u00197mCRLwN\\!oI\u000e\u000bW\u000e]1jO:,\"!a.\u0011\u000b\u001d\fY(!/\u0011\u000f\u0019\n\t)a#\u0002\f\u0006Q\u0012\u000eZ%ogR\fG\u000e\\1uS>t\u0017I\u001c3DC6\u0004\u0018-[4oA\u0005YA-\u001a7fi\u00164\u0016n]5u)%I\u0016\u0011YAb\u0003\u000b\f9\rC\u0003f1\u0001\u0007a\rC\u0003t1\u0001\u0007A\u000fC\u0003|1\u0001\u0007\u0011\fC\u0003~1\u0001\u0007\u0011,A\trk\u0016\u0014\u0018\u0010U1sC6\u001c(+Z1eKJ,\"!!4\u0011\u000b\u001d\fY(a4\u0011\r\u0019\n\t)!5Z!\u00151\u00131[Al\u0013\r\t)n\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005e\u0017q\\\u0007\u0003\u00037T1!!81\u0003\u0019!w.\\1j]&!\u0011\u0011]An\u0005M\u0019\u0015-\u001c9bS\u001et\u0017+^3ssB\u000b'/Y7t\u0003I\tX/\u001a:z!\u0006\u0014\u0018-\\:SK\u0006$WM\u001d\u0011\u0002'\u001d,GoQ1na\u0006LwM\\:BGRLwN\\:\u0015\u0013e\u000bI/a;\u0002n\u0006=\b\"B3\u001c\u0001\u00041\u0007\"B:\u001c\u0001\u0004!\b\"B>\u001c\u0001\u0004I\u0006\"B?\u001c\u0001\u0004I\u0016\u0001G4fi&s7\u000f^1mY\u0006$\u0018n\u001c8DC6\u0004\u0018-[4ogRI\u0011,!>\u0002x\u0006e\u00181 \u0005\u0006Kr\u0001\rA\u001a\u0005\u0006gr\u0001\r\u0001\u001e\u0005\u0006wr\u0001\r!\u0017\u0005\u0006{r\u0001\r!W\u0001\u0010k:d\u0017N\\6Pa\u0016\u0014\u0018\r^5p]RI\u0011L!\u0001\u0003\u0004\t\u0015!q\u0001\u0005\u0006Kv\u0001\rA\u001a\u0005\u0006gv\u0001\r\u0001\u001e\u0005\u0006wv\u0001\r!\u0017\u0005\u0006{v\u0001\r!\u0017")
public class CampaignController {
    private final CampaignDao campaignDao;
    private final LogUtil logUtil;
    private final VisitDao visitDao;
    private final Reads<Tuple2<Object, Object>> readCampaignAndPlan;
    private final Reads<Object> idCampaign;
    private final Reads<Tuple2<Object, Object>> idInstallationAndCampaign;
    private final Reads<Tuple2<Option<CampaignQueryParams>, String>> queryParamsReader;

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.stationTypeAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate Json to getAll campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long stationType = tuple2._1$mcJ$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)stationType), (Object)user);
            long stationType2 = tuple22._1$mcJ$sp();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.toJson((Object)$this.campaignDao.getAll(stationType2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Campaign$.MODULE$.formatCampaign())).toString();
        });
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to get campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)id), (Object)user);
            double id2 = tuple22._1$mcD$sp();
            String user2 = (String)tuple22._2();
            Option option = $this.campaignDao.get(id2, user2);
            if (option instanceof Some) {
                Some some = (Some)option;
                CampaignOutput campaign = (CampaignOutput)some.value();
                return Json$.MODULE$.toJson((Object)campaign, (Writes)CampaignOutput$.MODULE$.format()).toString();
            }
            $this.logUtil.error(new StringBuilder(29).append("Can't find campaign with id: ").append(read._1$mcD$sp()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getByStation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.stationTypeAndIdAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(38).append("Error validate Json to get campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            long stationType = BoxesRunTime.unboxToLong((Object)tuple3._1());
            double stationId = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            String user = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)stationType), (Object)BoxesRunTime.boxToDouble((double)stationId), (Object)user);
            long stationType2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
            double stationId2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            String user2 = (String)tuple32._3();
            return Json$.MODULE$.toJson((Object)$this.campaignDao.getByStation(stationId2, stationType2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Campaign$.MODULE$.formatCampaign())).toString();
        });
    }

    public String insert(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.campaignAndStationTypeAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate Json to insert campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            long stationType = BoxesRunTime.unboxToLong((Object)tuple3._1());
            CampaignInput campaign = (CampaignInput)tuple3._2();
            String user = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)stationType), (Object)campaign, (Object)user);
            long stationType2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
            CampaignInput campaign2 = (CampaignInput)tuple32._2();
            String user2 = (String)tuple32._3();
            Tuple2 tuple2 = $this.campaignDao.insert(stationType2, campaign2, user2);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            int res = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(id, res);
            double id2 = sp2._1$mcD$sp();
            int res2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id2), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
        });
    }

    public String insertQuality(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualityCampaignInput$.MODULE$.formatCampaign()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Error validate Json to insert quality campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)campaign -> {
            Tuple2 tuple2 = $this.campaignDao.insertQuality(campaign, user);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            int res = tuple2._2$mcI$sp();
            Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(id, res);
            double id2 = sp2._1$mcD$sp();
            int res2 = sp2._2$mcI$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res2), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id2), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
        });
    }

    public String update(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.campaignAndIdAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate Json to update campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            double id = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            CampaignInput campaign = (CampaignInput)tuple3._2();
            String user = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)id), (Object)campaign, (Object)user);
            double id2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            CampaignInput campaign2 = (CampaignInput)tuple32._2();
            String user2 = (String)tuple32._3();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.campaignDao.update(id2, campaign2, user2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateQuality(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(QualityCampaignInput$.MODULE$.updateRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Error validate Json to update quality campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double id = tuple2._1$mcD$sp();
            QualityCampaignInput campaign = (QualityCampaignInput)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)id), (Object)campaign);
            double id2 = tuple22._1$mcD$sp();
            QualityCampaignInput campaign2 = (QualityCampaignInput)tuple22._2();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.campaignDao.updateQuality(id2, campaign2, user)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(41).append("Error validate Json to delete campaign :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> CampaignController.$anonfun$delete$2(this, BoxesRunTime.unboxToDouble((Object)id)));
    }

    public String getCampaignsProgress(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.stationTypeAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to get campaign progression :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Seq seq;
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long stationType = tuple2._1$mcJ$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)stationType), (Object)user);
            long stationType2 = tuple22._1$mcJ$sp();
            String user2 = (String)tuple22._2();
            long l = stationType2;
            if (1L == l) {
                seq = $this.campaignDao.piezometryCampaignsProgression(stationType2, user2);
            } else if (2L == l) {
                seq = $this.campaignDao.pluviometryCampaignsProgression(stationType2, user2);
            } else if (3L == l) {
                seq = $this.campaignDao.qualityCampaignsProgression(stationType2, user2);
            } else if (4L == l) {
                seq = $this.campaignDao.hydrometryCampaignsProgression(stationType2, user2);
            } else if (7L == l) {
                seq = $this.campaignDao.installationCampaignsProgression(stationType2, user2);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            Seq campaignsProgress = seq;
            return Json$.MODULE$.toJson((Object)campaignsProgress, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignProgressionOutput$.MODULE$.formatCampaignStation())).toString();
        });
    }

    public String getCampaignProgress(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.stationTypeAndIdRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to get campaign progression :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            CampaignProgressionOutput campaignProgressionOutput;
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long stationType = tuple2._1$mcJ$sp();
            double id = tuple2._2$mcD$sp();
            Tuple2.mcJD.sp sp2 = new Tuple2.mcJD.sp(stationType, id);
            long stationType2 = sp2._1$mcJ$sp();
            double id2 = sp2._2$mcD$sp();
            long l = stationType2;
            if (1L == l) {
                campaignProgressionOutput = $this.campaignDao.piezometryCampaignProgression(id2);
            } else if (2L == l) {
                campaignProgressionOutput = $this.campaignDao.pluviometryCampaignProgression(id2);
            } else if (3L == l) {
                campaignProgressionOutput = $this.campaignDao.qualityCampaignProgression(id2);
            } else if (4L == l) {
                campaignProgressionOutput = $this.campaignDao.hydrometryCampaignProgression(id2);
            } else if (7L == l) {
                campaignProgressionOutput = $this.campaignDao.installationCampaignProgression(id2);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            CampaignProgressionOutput campaignProgress = campaignProgressionOutput;
            return Json$.MODULE$.toJson((Object)campaignProgress, (Writes)CampaignProgressionOutput$.MODULE$.formatCampaignStation()).toString();
        });
    }

    public String getQualityFollowUp(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get quality follow up :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> CampaignController.$anonfun$getQualityFollowUp$2(this, BoxesRunTime.unboxToDouble((Object)id)));
    }

    public Reads<Tuple2<Object, Object>> readCampaignAndPlan() {
        return this.readCampaignAndPlan;
    }

    public String getPlanningFollowUp(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.readCampaignAndPlan()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get quality follow up :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double campaignId = tuple2._1$mcD$sp();
            long planningId = tuple2._2$mcJ$sp();
            Tuple2.mcDJ.sp sp2 = new Tuple2.mcDJ.sp(campaignId, planningId);
            double campaignId2 = sp2._1$mcD$sp();
            long planningId2 = sp2._2$mcJ$sp();
            return Json$.MODULE$.toJson((Object)$this.campaignDao.planningFollowUp(campaignId2, planningId2), PlanningProgress$.MODULE$.localisationWrites()).toString();
        });
    }

    public Reads<Object> idCampaign() {
        return this.idCampaign;
    }

    public String getCampaignVisits(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idCampaign()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate id from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)idCampaign -> CampaignController.$anonfun$getCampaignVisits$2(this, BoxesRunTime.unboxToLong((Object)idCampaign)));
    }

    public Reads<Tuple2<Object, Object>> idInstallationAndCampaign() {
        return this.idInstallationAndCampaign;
    }

    public String deleteVisit(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.idInstallationAndCampaign()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate idinstallation and/or idCampaign from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long idInstallation = tuple2._1$mcJ$sp();
            long idCampaign = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(idInstallation, idCampaign);
            long idInstallation2 = sp2._1$mcJ$sp();
            long idCampaign2 = sp2._2$mcJ$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.visitDao.deleteVisit(idCampaign2, idInstallation2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple2<Option<CampaignQueryParams>, String>> queryParamsReader() {
        return this.queryParamsReader;
    }

    public String getCampaignsActions(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.queryParamsReader()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate queryParams from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option param = (Option)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)param, (Object)user);
            Option param2 = (Option)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.toJson((Object)$this.campaignDao.getCampaignsActions(param2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignAction$.MODULE$.formatCampaignParameter())).toString();
        });
    }

    public String getInstallationCampaigns(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.queryParamsReader()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't validate queryParams from path.", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option param = (Option)tuple2._1();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)param, (Object)user);
            Option param2 = (Option)tuple22._1();
            String user2 = (String)tuple22._2();
            return Json$.MODULE$.toJson((Object)$this.campaignDao.getInstallationCampaigns(param2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignInstallationWithStats$.MODULE$.formatCampaignParameter())).toString();
        });
    }

    public String unlinkOperation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(42).append("Error validate Json to unlink operation :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> CampaignController.$anonfun$unlinkOperation$2(this, BoxesRunTime.unboxToDouble((Object)id)));
    }

    public static final /* synthetic */ String $anonfun$delete$2(CampaignController $this, double id) {
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.campaignDao.delete(id)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getQualityFollowUp$2(CampaignController $this, double id) {
        return Json$.MODULE$.toJson((Object)$this.campaignDao.qualityFollowUp(id), PlanningProgress$.MODULE$.localisationWrites()).toString();
    }

    public static final /* synthetic */ String $anonfun$getCampaignVisits$2(CampaignController $this, long idCampaign) {
        return Json$.MODULE$.toJson((Object)$this.visitDao.getCampaignVisits(idCampaign), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignVisit$.MODULE$.accessibilitesWrites())).toString();
    }

    public static final /* synthetic */ String $anonfun$unlinkOperation$2(CampaignController $this, double id) {
        int resUnlink = $this.campaignDao.unlinkOperations(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)resUnlink), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public CampaignController(CampaignDao campaignDao, LogUtil logUtil, VisitDao visitDao) {
        this.campaignDao = campaignDao;
        this.logUtil = logUtil;
        this.visitDao = visitDao;
        this.readCampaignAndPlan = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("campaignId").read((Reads)Reads$.MODULE$.DoubleReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("planningId").read((Reads)Reads$.MODULE$.LongReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.idCampaign = JsPath$.MODULE$.$bslash("idCampaign").read((Reads)Reads$.MODULE$.LongReads());
        this.idInstallationAndCampaign = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("idInstallation").read((Reads)Reads$.MODULE$.LongReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("idCampaign").read((Reads)Reads$.MODULE$.LongReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.queryParamsReader = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("queryParams").readNullable((Reads)CampaignQueryParams$.MODULE$.format()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

