/*
 * Decompiled with CFR 0.152.
 */
package controllers.campaign;

import fr.aquasys.daeau.campaign.domain.input.CampaignInput$;
import fr.aquasys.daeau.campaign.domain.input.CampaignStationInput$;
import fr.aquasys.daeau.campaign.domain.output.CampaignStationOutput$;
import fr.aquasys.daeau.campaign.itf.CampaignStationDao;
import fr.aquasys.daeau.campaign.model.CampaignStation$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005m4A!\u0003\u0006\u0001\u001f!Aa\u0003\u0001B\u0001B\u0003%q\u0003\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015a\u0004\u0001\"\u0001>\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u0015I\u0007\u0001\"\u0001k\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0015)\b\u0001\"\u0001w\u0005e\u0019\u0015-\u001c9bS\u001et7\u000b^1uS>t7i\u001c8ue>dG.\u001a:\u000b\u0005-a\u0011\u0001C2b[B\f\u0017n\u001a8\u000b\u00035\t1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\u0006\u00112-Y7qC&<gn\u0015;bi&|g\u000eR1p!\tA\"%D\u0001\u001a\u0015\tQ2$A\u0002ji\u001aT!a\u0003\u000f\u000b\u0005uq\u0012!\u00023bK\u0006,(BA\u0010!\u0003\u001d\t\u0017/^1tsNT\u0011!I\u0001\u0003MJL!aI\r\u0003%\r\u000bW\u000e]1jO:\u001cF/\u0019;j_:$\u0015m\\\u0001\bY><W\u000b^5m!\t13&D\u0001(\u0015\tA\u0013&\u0001\u0003vi&d'B\u0001\u0016\u001f\u0003!\u0011\u0018M\u00192ji6\f\u0018B\u0001\u0017(\u0005\u001daunZ+uS2\fa\u0001P5oSRtDcA\u00182eA\u0011\u0001\u0007A\u0007\u0002\u0015!)ac\u0001a\u0001/!)Ae\u0001a\u0001K!\u00121\u0001\u000e\t\u0003kij\u0011A\u000e\u0006\u0003oa\na!\u001b8kK\u000e$(\"A\u001d\u0002\u000b)\fg/\u0019=\n\u0005m2$AB%oU\u0016\u001cG/\u0001\u0004hKR\fE\u000e\u001c\u000b\u0006}%;v,\u0019\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005\u0013R\"\u0001\"\u000b\u0005\rs\u0011A\u0002\u001fs_>$h(\u0003\u0002F%\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)%\u0003C\u0003K\t\u0001\u00071*A\u0004nKN\u001c\u0018mZ3\u0011\u00051+V\"A'\u000b\u00059{\u0015\u0001\u00026t_:T!\u0001U)\u0002\t1L'm\u001d\u0006\u0003%N\u000b1!\u00199j\u0015\u0005!\u0016\u0001\u00029mCfL!AV'\u0003\u000f)\u001bh+\u00197vK\")\u0001\f\u0002a\u00013\u00069\u0001.Z1eKJ\u001c\b\u0003B [}qK!a\u0017%\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u0012;&\u0011aL\u0005\u0002\u0004\u0003:L\b\"\u00021\u0005\u0001\u0004q\u0014AB7pIVdW\rC\u0003c\t\u0001\u0007a(\u0001\u0003vg\u0016\u0014\u0018aA4fiR)a(\u001a4hQ\")!*\u0002a\u0001\u0017\")\u0001,\u0002a\u00013\")\u0001-\u0002a\u0001}!)!-\u0002a\u0001}\u00051\u0011N\\:feR$RAP6m[:DQA\u0013\u0004A\u0002-CQ\u0001\u0017\u0004A\u0002eCQ\u0001\u0019\u0004A\u0002yBQA\u0019\u0004A\u0002y\na\u0001Z3mKR,G#\u0002 reN$\b\"\u0002&\b\u0001\u0004Y\u0005\"\u0002-\b\u0001\u0004I\u0006\"\u00021\b\u0001\u0004q\u0004\"\u00022\b\u0001\u0004q\u0014a\u00037j].\u001cF/\u0019;j_:$RAP<ysjDQA\u0013\u0005A\u0002-CQ\u0001\u0017\u0005A\u0002eCQ\u0001\u0019\u0005A\u0002yBQA\u0019\u0005A\u0002y\u0002")
public class CampaignStationController {
    private final CampaignStationDao campaignStationDao;
    private final LogUtil logUtil;

    public String getAll(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.stationTypeAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to getAll campaignStations : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Seq seq;
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long stationType = tuple2._1$mcJ$sp();
            String user = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)stationType), (Object)user);
            long stationType2 = tuple22._1$mcJ$sp();
            String user2 = (String)tuple22._2();
            String string = StationTypeUtil$.MODULE$.StationType((int)stationType2);
            String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                seq = $this.campaignStationDao.getAllCampaignPiezometer(user2);
            } else {
                String string4 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    seq = $this.campaignStationDao.getAllCampaignPluviometer(user2);
                } else {
                    String string6 = StationTypeUtil$.MODULE$.QUALITY();
                    String string7 = string;
                    if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                        seq = $this.campaignStationDao.getAllCampaignQualitometer(user2);
                    } else {
                        String string8 = StationTypeUtil$.MODULE$.HYDROMETRY();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            seq = $this.campaignStationDao.getAllCampaignHydrometer(user2);
                        } else {
                            String string10 = StationTypeUtil$.MODULE$.INSTALLATION();
                            String string11 = string;
                            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                seq = $this.campaignStationDao.getAllCampaignInstallation(user2);
                            } else {
                                throw new MatchError((Object)string);
                            }
                        }
                    }
                }
            }
            Seq campaignStations = seq;
            return Json$.MODULE$.toJson((Object)campaignStations, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignStation$.MODULE$.formatCampaignStation())).toString();
        });
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.stationTypeAndIdAndUserRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to get campaignStations : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Seq seq;
            Tuple3 tuple3 = read;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            long stationType = BoxesRunTime.unboxToLong((Object)tuple3._1());
            double id = BoxesRunTime.unboxToDouble((Object)tuple3._2());
            String user = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)stationType), (Object)BoxesRunTime.boxToDouble((double)id), (Object)user);
            long stationType2 = BoxesRunTime.unboxToLong((Object)tuple32._1());
            double id2 = BoxesRunTime.unboxToDouble((Object)tuple32._2());
            String user2 = (String)tuple32._3();
            if (stationType2 == 3L) {
                return Json$.MODULE$.toJson((Object)$this.campaignStationDao.getCampaignQualitometer(id2, user2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignStation$.MODULE$.formatCampaignStation())).toString();
            }
            long l = stationType2;
            if (1L == l) {
                seq = $this.campaignStationDao.getCampaignPiezometer(id2, user2);
            } else if (2L == l) {
                seq = $this.campaignStationDao.getCampaignPluviometer(id2, user2);
            } else if (4L == l) {
                seq = $this.campaignStationDao.getCampaignHydrometer(id2, user2);
            } else if (7L == l) {
                seq = $this.campaignStationDao.getCampaignInstallation(id2, user2);
            } else {
                throw new MatchError((Object)BoxesRunTime.boxToLong((long)l));
            }
            Seq campaignStations = seq;
            return Json$.MODULE$.toJson((Object)campaignStations, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)CampaignStationOutput$.MODULE$.formatCampaignStationOutput())).toString();
        });
    }

    public String insert(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignStationInput$.MODULE$.insertRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to insert campaignStations : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)read -> {
            Tuple4 tuple4 = read;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            double id = BoxesRunTime.unboxToDouble((Object)tuple4._2());
            long stationType = BoxesRunTime.unboxToLong((Object)tuple4._3());
            Seq campaignStations = (Seq)tuple4._4();
            Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)id), (Object)BoxesRunTime.boxToLong((long)stationType), (Object)campaignStations);
            double id2 = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            long stationType2 = BoxesRunTime.unboxToLong((Object)tuple3._2());
            Seq campaignStations2 = (Seq)tuple3._3();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)$this.campaignStationDao.updateAll(id2, stationType2, campaignStations2), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.LongWrites()))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id2), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(50).append("Error validate Json to delete campaignStations : \n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> CampaignStationController.$anonfun$delete$2(this, BoxesRunTime.unboxToDouble((Object)id)));
    }

    public String linkStation(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CampaignInput$.MODULE$.idRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to link operation :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)id -> CampaignStationController.$anonfun$linkStation$2(this, BoxesRunTime.unboxToDouble((Object)id)));
    }

    public static final /* synthetic */ String $anonfun$delete$2(CampaignStationController $this, double id) {
        return Json$.MODULE$.toJson((Object)BoxesRunTime.boxToInteger((int)$this.campaignStationDao.deleteAll(id)), (Writes)Writes$.MODULE$.IntWrites()).toString();
    }

    public static final /* synthetic */ String $anonfun$linkStation$2(CampaignStationController $this, double id) {
        int resLink = $this.campaignStationDao.linkOperation(id);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)resLink), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public CampaignStationController(CampaignStationDao campaignStationDao, LogUtil logUtil) {
        this.campaignStationDao = campaignStationDao;
        this.logUtil = logUtil;
    }
}

