/*
 * Decompiled with CFR 0.152.
 */
package controllers.event;

import dao.event.EventsDao;
import dao.rpc.dao.CmsDao;
import dao.rpc.dao.ContributorDao;
import dao.rpc.dao.MailDao;
import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.administration.model.SieauParameters;
import fr.aquasys.daeau.quality.domain.input.QualitometerEventInput$;
import fr.aquasys.daeau.quality.domain.output.QualitometerEventOutput$;
import fr.aquasys.daeau.quality.itf.QualitometerDao;
import fr.aquasys.daeau.quality.itf.QualitometerEventDao;
import fr.aquasys.daeau.quality.model.Qualitometer;
import fr.aquasys.daeau.quality.model.QualitometerEvent;
import fr.aquasys.daeau.quality.model.QualitometerEvent$;
import fr.aquasys.daeau.station.links.contributor.StationContributorDao;
import fr.aquasys.daeau.station.links.contributor.StationContributorLink;
import fr.aquasys.rabbitmq.util.DateUtil$;
import fr.aquasys.rabbitmq.util.ErrorUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.EventUtil$;
import java.io.Serializable;
import javax.inject.Inject;
import model.input.Contributor;
import model.input.EventInput;
import model.input.EventInput$;
import org.joda.time.DateTime;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.collection.parallel.CollectionConverters;
import scala.collection.parallel.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\ra\u0001\u0002\u000e\u001c\u0001\u0001B\u0001b\n\u0001\u0003\u0002\u0003\u0006Y\u0001\u000b\u0005\ti\u0001\u0011\t\u0011)A\u0006k!Aa\b\u0001B\u0001B\u0003-q\b\u0003\u0005L\u0001\t\u0005\t\u0015a\u0003M\u0011!y\u0005A!A!\u0002\u0017\u0001\u0006\u0002\u0003-\u0001\u0005\u0003\u0005\u000b1B-\t\u0011\u0001\u0004!\u0011!Q\u0001\f\u0005D\u0001\u0002\u001a\u0001\u0003\u0002\u0003\u0006Y!\u001a\u0005\tQ\u0002\u0011\t\u0011)A\u0006S\")a\u000e\u0001C\u0001_\"I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011q\u0006\u0001C\u0002\u0013\u0005\u0011\u0011\u0007\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00024!9\u0011Q\b\u0001\u0005\u0002\u0005}\u0002bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\t\n\u0001C\u0001\u0003'Cq!!(\u0001\t\u0003\ty\nC\u0004\u0002*\u0002!\t!a+\t\u000f\u0005U\u0006\u0001\"\u0001\u00028\"9\u0011\u0011\u0019\u0001\u0005\u0002\u0005\r\u0007\"CAh\u0001\t\u0007I\u0011AAi\u0011!\t)\u0010\u0001Q\u0001\n\u0005M\u0007bBA|\u0001\u0011\u0005\u0011\u0011 \u0002\u0010\u000bZ,g\u000e^\"p]R\u0014x\u000e\u001c7fe*\u0011A$H\u0001\u0006KZ,g\u000e\u001e\u0006\u0002=\u0005Y1m\u001c8ue>dG.\u001a:t\u0007\u0001\u0019\"\u0001A\u0011\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g\u0003\u001dawnZ+uS2\u0004\"!\u000b\u001a\u000e\u0003)R!a\u000b\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0003[9\n\u0001B]1cE&$X.\u001d\u0006\u0003_A\nq!Y9vCNL8OC\u00012\u0003\t1'/\u0003\u00024U\t9Aj\\4Vi&d\u0017AB2ng\u0012\u000bw\u000e\u0005\u00027y5\tqG\u0003\u00029s\u0005\u0019A-Y8\u000b\u0005iZ\u0014a\u0001:qG*\t\u0001(\u0003\u0002>o\t11)\\:EC>\fQc\u001d;bi&|gnQ8oiJL'-\u001e;pe\u0012\u000bw\u000e\u0005\u0002A\u00136\t\u0011I\u0003\u0002C\u0007\u0006Y1m\u001c8ue&\u0014W\u000f^8s\u0015\t!U)A\u0003mS:\\7O\u0003\u0002G\u000f\u000691\u000f^1uS>t'B\u0001%/\u0003\u0015!\u0017-Z1v\u0013\tQ\u0015IA\u000bTi\u0006$\u0018n\u001c8D_:$(/\u001b2vi>\u0014H)Y8\u0002\u001d\r|g\u000e\u001e:jEV$xN\u001d#b_B\u0011a'T\u0005\u0003\u001d^\u0012abQ8oiJL'-\u001e;pe\u0012\u000bw.\u0001\ntS\u0016\fW\u000fU1sC6,G/\u001a:t\t\u0006|\u0007CA)W\u001b\u0005\u0011&BA*U\u0003\rIGO\u001a\u0006\u0003+\u001e\u000ba\"\u00193nS:L7\u000f\u001e:bi&|g.\u0003\u0002X%\n\u00112+[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p\u0003=\tX/\u00197ji>lW\r^3s\t\u0006|\u0007C\u0001._\u001b\u0005Y&BA*]\u0015\tiv)A\u0004rk\u0006d\u0017\u000e^=\n\u0005}[&aD)vC2LGo\\7fi\u0016\u0014H)Y8\u0002\u000f5\f\u0017\u000e\u001c#b_B\u0011aGY\u0005\u0003G^\u0012q!T1jY\u0012\u000bw.\u0001\u000brk\u0006d\u0017\u000e^8nKR,'/\u0012<f]R$\u0015m\u001c\t\u00035\u001aL!aZ.\u0003)E+\u0018\r\\5u_6,G/\u001a:Fm\u0016tG\u000fR1p\u0003%)g/\u001a8ug\u0012\u000bw\u000e\u0005\u0002kY6\t1N\u0003\u0002\u001dw%\u0011Qn\u001b\u0002\n\u000bZ,g\u000e^:EC>\fa\u0001P5oSRtD#\u00019\u0015\u0015E\u001cH/\u001e<xqfT8\u0010\u0005\u0002s\u00015\t1\u0004C\u0003(\u0015\u0001\u000f\u0001\u0006C\u00035\u0015\u0001\u000fQ\u0007C\u0003?\u0015\u0001\u000fq\bC\u0003L\u0015\u0001\u000fA\nC\u0003P\u0015\u0001\u000f\u0001\u000bC\u0003Y\u0015\u0001\u000f\u0011\fC\u0003a\u0015\u0001\u000f\u0011\rC\u0003e\u0015\u0001\u000fQ\rC\u0003i\u0015\u0001\u000f\u0011\u000e\u000b\u0002\u000b{B\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u00051\u0011N\u001c6fGRT!!!\u0002\u0002\u000b)\fg/\u0019=\n\u0007\u0005%qP\u0001\u0004J]*,7\r^\u0001\u0012cV\fG.\u001b;p[\u0016$XM\u001d*fC\u0012\u001cXCAA\b!\u0019\t\t\"a\t\u0002(5\u0011\u00111\u0003\u0006\u0005\u0003+\t9\"\u0001\u0003kg>t'\u0002BA\r\u00037\tA\u0001\\5cg*!\u0011QDA\u0010\u0003\r\t\u0007/\u001b\u0006\u0003\u0003C\tA\u0001\u001d7bs&!\u0011QEA\n\u0005\u0015\u0011V-\u00193t!\r\u0011\u0013\u0011F\u0005\u0004\u0003W\u0019#A\u0002#pk\ndW-\u0001\nrk\u0006d\u0017\u000e^8nKR,'OU3bIN\u0004\u0013AF9vC2LGo\\7fi\u0016\u0014XI^3oiJ+\u0017\rZ:\u0016\u0005\u0005M\u0002CBA\t\u0003G\t)\u0004E\u0004#\u0003o\t9#a\n\n\u0007\u0005e2E\u0001\u0004UkBdWMM\u0001\u0018cV\fG.\u001b;p[\u0016$XM]#wK:$(+Z1eg\u0002\nAbZ3u\u00032dWI^3oiN$\"\"!\u0011\u0002X\u0005\u0005\u0014\u0011OA;!\u0011\t\u0019%!\u0015\u000f\t\u0005\u0015\u0013Q\n\t\u0004\u0003\u000f\u001aSBAA%\u0015\r\tYeH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=3%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003'\n)F\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003\u001f\u001a\u0003bBA-\u001f\u0001\u0007\u00111L\u0001\b[\u0016\u001c8/Y4f!\u0011\t\t\"!\u0018\n\t\u0005}\u00131\u0003\u0002\b\u0015N4\u0016\r\\;f\u0011\u001d\t\u0019g\u0004a\u0001\u0003K\nq\u0001[3bI\u0016\u00148\u000f\u0005\u0005\u0002D\u0005\u001d\u0014\u0011IA6\u0013\u0011\tI'!\u0016\u0003\u00075\u000b\u0007\u000fE\u0002#\u0003[J1!a\u001c$\u0005\r\te.\u001f\u0005\b\u0003gz\u0001\u0019AA!\u0003\u0019iw\u000eZ;mK\"9\u0011qO\bA\u0002\u0005\u0005\u0013\u0001B;tKJ\f\u0011bZ3u\u000bZ,g\u000e^:\u0015\u0015\u0005\u0005\u0013QPA@\u0003\u0003\u000b\u0019\tC\u0004\u0002ZA\u0001\r!a\u0017\t\u000f\u0005\r\u0004\u00031\u0001\u0002f!9\u00111\u000f\tA\u0002\u0005\u0005\u0003bBA<!\u0001\u0007\u0011\u0011I\u0001\tO\u0016$XI^3oiRQ\u0011\u0011IAE\u0003\u0017\u000bi)a$\t\u000f\u0005e\u0013\u00031\u0001\u0002\\!9\u00111M\tA\u0002\u0005\u0015\u0004bBA:#\u0001\u0007\u0011\u0011\t\u0005\b\u0003o\n\u0002\u0019AA!\u0003!\tG\rZ#wK:$HCCA!\u0003+\u000b9*!'\u0002\u001c\"9\u0011\u0011\f\nA\u0002\u0005m\u0003bBA2%\u0001\u0007\u0011Q\r\u0005\b\u0003g\u0012\u0002\u0019AA!\u0011\u001d\t9H\u0005a\u0001\u0003\u0003\nA\u0002];cY&\u001c\b.\u0012<f]R$\"\"!\u0011\u0002\"\u0006\r\u0016QUAT\u0011\u001d\tIf\u0005a\u0001\u00037Bq!a\u0019\u0014\u0001\u0004\t)\u0007C\u0004\u0002tM\u0001\r!!\u0011\t\u000f\u0005]4\u00031\u0001\u0002B\u0005YQ\u000f\u001d3bi\u0016,e/\u001a8u))\t\t%!,\u00020\u0006E\u00161\u0017\u0005\b\u00033\"\u0002\u0019AA.\u0011\u001d\t\u0019\u0007\u0006a\u0001\u0003KBq!a\u001d\u0015\u0001\u0004\t\t\u0005C\u0004\u0002xQ\u0001\r!!\u0011\u0002\u0017\u0011,G.\u001a;f\u000bZ,g\u000e\u001e\u000b\u000b\u0003\u0003\nI,a/\u0002>\u0006}\u0006bBA-+\u0001\u0007\u00111\f\u0005\b\u0003G*\u0002\u0019AA3\u0011\u001d\t\u0019(\u0006a\u0001\u0003\u0003Bq!a\u001e\u0016\u0001\u0004\t\t%\u0001\u0006tK:$')_'bS2$\"\"!\u0011\u0002F\u0006%\u00171ZAg\u0011\u001d\t9M\u0006a\u0001\u00037\nQA^1mk\u0016Dq!a\u0019\u0017\u0001\u0004\t)\u0007C\u0004\u0002tY\u0001\r!!\u0011\t\u000f\u0005]d\u00031\u0001\u0002B\u0005)2\u000b^1uS>tG+\u001f9f\u0003:$\u0017\nZ:SK\u0006$WCAAj!\u0019\t\t\"a\t\u0002VB9!%a\u000e\u0002X\u0006u\u0007c\u0001\u0012\u0002Z&\u0019\u00111\\\u0012\u0003\u0007%sG\u000fE\u0003#\u0003?\f\u0019/C\u0002\u0002b\u000e\u0012aa\u00149uS>t\u0007CBAs\u0003_\f9N\u0004\u0003\u0002h\u0006-h\u0002BA$\u0003SL\u0011\u0001J\u0005\u0004\u0003[\u001c\u0013a\u00029bG.\fw-Z\u0005\u0005\u0003c\f\u0019PA\u0002TKFT1!!<$\u0003Y\u0019F/\u0019;j_:$\u0016\u0010]3B]\u0012LEm\u001d*fC\u0012\u0004\u0013!F4fiN#\u0018\r^5p]\u00163XM\u001c;t\u0005fLEm\u001d\u000b\u000b\u0003\u0003\nY0!@\u0002\u0000\n\u0005\u0001bBA-3\u0001\u0007\u00111\f\u0005\b\u0003GJ\u0002\u0019AA3\u0011\u001d\t\u0019(\u0007a\u0001\u0003\u0003Bq!a\u001e\u001a\u0001\u0004\t\t\u0005")
public class EventController {
    private final LogUtil logUtil;
    private final CmsDao cmsDao;
    private final StationContributorDao stationContributorDao;
    private final ContributorDao contributorDao;
    private final SieauParametersDao sieauParametersDao;
    private final QualitometerDao qualitometerDao;
    private final MailDao mailDao;
    private final QualitometerEventDao qualitometerEventDao;
    private final EventsDao eventsDao;
    private final Reads<Object> qualitometerReads;
    private final Reads<Tuple2<Object, Object>> qualitometerEventReads;
    private final Reads<Tuple2<Object, Option<Seq<Object>>>> StationTypeAndIdsRead;

    public Reads<Object> qualitometerReads() {
        return this.qualitometerReads;
    }

    public Reads<Tuple2<Object, Object>> qualitometerEventReads() {
        return this.qualitometerEventReads;
    }

    public String getAllEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.qualitometerEventDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualitometerEventOutput$.MODULE$.qualitometerEvent())).toString();
    }

    public String getEvents(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.qualitometerReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(36).append("Error validate Json to get Events :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)code -> EventController.$anonfun$getEvents$2(this, BoxesRunTime.unboxToDouble((Object)code)));
    }

    public String getEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.qualitometerEventReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)codes -> {
            $this.logUtil.info(new StringBuilder(28).append("Get event ").append(codes._2$mcD$sp()).append(" for qualitometer ").append(codes._1$mcD$sp()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.toJson((Object)$this.qualitometerEventDao.find(codes._1$mcD$sp(), codes._2$mcD$sp()), Writes$.MODULE$.OptionWrites((Writes)QualitometerEvent$.MODULE$.qualitometerEventWrites())).toString();
        });
    }

    public String addEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(QualitometerEventInput$.MODULE$.reads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to add Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)eventInput -> {
            double id = $this.qualitometerEventDao.insert(eventInput);
            $this.logUtil.info(new StringBuilder(36).append("Insert new event for qualitometer : ").append(eventInput.code()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"eventId"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToDouble((double)id), (Writes)Writes$.MODULE$.DoubleWrites()))})).toString();
        });
    }

    public String publishEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(EventInput$.MODULE$.userRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(39).append("Error validate Json to publish Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)valid -> {
            String string;
            EventInput eventInput;
            block9: {
                Tuple2 tuple2;
                block8: {
                    tuple2 = valid;
                    if (tuple2 == null) break block8;
                    String user = (String)tuple2._1();
                    eventInput = (EventInput)tuple2._2();
                    if (user == null) break block8;
                    string = user;
                    if (eventInput != null) break block9;
                }
                throw new MatchError((Object)tuple2);
            }
            EventInput eventInput2 = eventInput;
            Tuple2 tuple2 = new Tuple2((Object)string, (Object)eventInput2);
            String user = (String)tuple2._1();
            EventInput eventInput3 = (EventInput)tuple2._2();
            Option option = $this.qualitometerEventDao.find(eventInput3.code(), eventInput3.number());
            if (option instanceof Some) {
                Some some;
                Tuple2 tuple22;
                Some some2 = (Some)option;
                QualitometerEvent event = (QualitometerEvent)some2.value();
                Seq contributors = (Seq)((Iterable)CollectionConverters.ImmutableSeqIsParallelizable$.MODULE$.par$extension(CollectionConverters$.MODULE$.ImmutableSeqIsParallelizable((Seq)$this.stationContributorDao.getContributorLinks("quality", (long)event.code()).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)EventController.$anonfun$publishEvent$3(x$2))))).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable)(a, link) -> {
                    Option<Contributor> option = $this.contributorDao.getContributor((int)BoxesRunTime.unboxToLong((Object)link.idContributor().get()));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        Contributor contributor = (Contributor)some.value();
                        return (Seq)a.$colon$plus((Object)new Tuple2(link, (Object)contributor));
                    }
                    return a;
                })).seq();
                Option option2 = contributors.find((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)EventController.$anonfun$publishEvent$5(x$3)));
                if (option2 instanceof Some && (tuple22 = (Tuple2)(some = (Some)option2).value()) != null) {
                    StationContributorLink fbLink = (StationContributorLink)tuple22._1();
                    Contributor fbContributor = (Contributor)tuple22._2();
                    Option option3 = fbLink.internalReference();
                    if (option3 instanceof Some) {
                        String string2;
                        Some some3 = (Some)option3;
                        String locationId = (String)some3.value();
                        Option option4 = event.date();
                        if (option4 instanceof Some) {
                            Some some4 = (Some)option4;
                            DateTime d = (DateTime)some4.value();
                            string2 = new StringBuilder(1).append(DateUtil$.MODULE$.format("dd/MM/yyyy", d)).append("\n").toString();
                        } else {
                            string2 = "";
                        }
                        String date = string2;
                        String content = new StringBuilder(131).append("\n                                            ").append(date).append("\n                                            ").append(event.comment().getOrElse((Function0 & Serializable)() -> "")).append("\n                                        ").toString();
                        $this.cmsDao.FacebookPublish(user, content, locationId);
                        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"Content sent", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
                    }
                    $this.logUtil.error(new StringBuilder(63).append("No internalReference defined on contributor ").append(fbContributor.id()).append(" linked to qualito ").append(event.code()).toString(), $this.logUtil.error$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(63).append("No internalReference defined on contributor ").append(fbContributor.id()).append(" linked to qualito ").append(event.code()).toString(), (Writes)Writes$.MODULE$.StringWrites()))})).toString();
                }
                $this.logUtil.error("No contributor found with name facebook", $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"No contributor found with name facebook", (Writes)Writes$.MODULE$.StringWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(47).append("Cannot find qualito event for code ").append(eventInput3.code()).append(" and number ").append(eventInput3.number()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate((Reads)QualitometerEvent$.MODULE$.qualitometerEventWrites()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to add Event :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)event -> {
            $this.qualitometerEventDao.update(event);
            $this.logUtil.info(new StringBuilder(33).append("Update event ").append(event.number()).append(" for qualitometer : ").append(event.code()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteEvent(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.qualitometerEventReads()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get installation id or event id", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)read -> {
            Tuple2 tuple2 = read;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            double stationId = tuple2._1$mcD$sp();
            double eventId = tuple2._2$mcD$sp();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(stationId, eventId);
            double stationId2 = sp2._1$mcD$sp();
            double eventId2 = sp2._2$mcD$sp();
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)$this.qualitometerEventDao.delete(stationId2, eventId2)), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String sendByMail(JsValue value, Map<String, Object> headers, String module, String user) {
        return (String)value.validate(EventUtil$.MODULE$.eventIdAndStationIdAndEmailRead()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(44).append("Error validate Json to send Event by mail :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple3 tuple3 = params;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            int eventId = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int stationId = BoxesRunTime.unboxToInt((Object)tuple3._2());
            Seq emails = (Seq)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)eventId), (Object)BoxesRunTime.boxToInteger((int)stationId), (Object)emails);
            int eventId2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int stationId2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
            Seq emails2 = (Seq)tuple32._3();
            Option option = $this.qualitometerEventDao.find((double)stationId2, (double)eventId2);
            if (option instanceof Some) {
                Some some = (Some)option;
                QualitometerEvent event = (QualitometerEvent)some.value();
                Option option2 = $this.qualitometerDao.get(stationId2);
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    Qualitometer qualito = (Qualitometer)some2.value();
                    Seq parameters = $this.sieauParametersDao.getAll($this.sieauParametersDao.getAll$default$1(), $this.sieauParametersDao.getAll$default$2());
                    emails2.foreach((Function1 & Serializable)email -> {
                        this.mailDao.sendMail(email, event, qualito, (Seq<SieauParameters>)parameters);
                        return BoxedUnit.UNIT;
                    });
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"success"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)200), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                $this.logUtil.debug(new StringBuilder(25).append("Error qualito: ").append(stationId2).append(" not found").toString(), $this.logUtil.debug$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.debug(new StringBuilder(37).append("Error event: ").append(eventId2).append(" not found for qualito: ").append(stationId2).toString(), $this.logUtil.debug$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public Reads<Tuple2<Object, Option<Seq<Object>>>> StationTypeAndIdsRead() {
        return this.StationTypeAndIdsRead;
    }

    public String getStationEventsByIds(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.StationTypeAndIdsRead()).fold((Function1 & Serializable)error -> ErrorUtil$.MODULE$.getJsonError($this.logUtil, "Can't get stationType or ids", ErrorUtil$.MODULE$.getJsonError$default$3(), ErrorUtil$.MODULE$.getJsonError$default$4(), ErrorUtil$.MODULE$.getJsonError$default$5()), (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int stationType = tuple2._1$mcI$sp();
            Option ids = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)stationType), (Object)ids);
            int stationType2 = tuple22._1$mcI$sp();
            Option ids2 = (Option)tuple22._2();
            return $this.eventsDao.getStationEventsByIds(stationType2, (Option<Seq<Object>>)ids2).toString();
        });
    }

    public static final /* synthetic */ String $anonfun$getEvents$2(EventController $this, double code) {
        $this.logUtil.info(new StringBuilder(28).append("Get Events for qualitometer ").append(code).toString(), $this.logUtil.info$default$2());
        return Json$.MODULE$.toJson((Object)$this.qualitometerEventDao.find(code), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)QualitometerEvent$.MODULE$.qualitometerEventWrites())).toString();
    }

    public static final /* synthetic */ boolean $anonfun$publishEvent$3(StationContributorLink x$2) {
        return x$2.idContributor().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$publishEvent$5(Tuple2 x$3) {
        String string = ((String)((Contributor)x$3._2()).name().getOrElse((Function0 & Serializable)() -> "")).toLowerCase();
        String string2 = "facebook";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    @Inject
    public EventController(LogUtil logUtil, CmsDao cmsDao, StationContributorDao stationContributorDao, ContributorDao contributorDao, SieauParametersDao sieauParametersDao, QualitometerDao qualitometerDao, MailDao mailDao, QualitometerEventDao qualitometerEventDao, EventsDao eventsDao) {
        this.logUtil = logUtil;
        this.cmsDao = cmsDao;
        this.stationContributorDao = stationContributorDao;
        this.contributorDao = contributorDao;
        this.sieauParametersDao = sieauParametersDao;
        this.qualitometerDao = qualitometerDao;
        this.mailDao = mailDao;
        this.qualitometerEventDao = qualitometerEventDao;
        this.eventsDao = eventsDao;
        this.qualitometerReads = JsPath$.MODULE$.$bslash("id").read((Reads)Reads$.MODULE$.DoubleReads());
        this.qualitometerEventReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("qualitometerId").read((Reads)Reads$.MODULE$.DoubleReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("eventId").read((Reads)Reads$.MODULE$.DoubleReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.StationTypeAndIdsRead = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.IntReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("ids").readNullable(Reads$.MODULE$.traversableReads(Seq$.MODULE$.iterableFactory(), (Reads)Reads$.MODULE$.IntReads()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

