/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import com.google.inject.Inject;
import dao.itf.ActionStatisticDao;
import dao.itf.CartoStatisticDao;
import dao.itf.CmsStatisticDao;
import dao.itf.ScreenStatisticDao;
import dao.itf.StationStatisticDao;
import dao.itf.UsageStatisticDao;
import domain.input.ActionStatisticInput;
import domain.input.ActionStatisticInput$;
import domain.input.CreateStatisticInput$;
import domain.input.ScreenStatisticInput;
import domain.input.ScreenStatisticInput$;
import fr.aquasys.daeau.cms.domain.input.DocumentStatisticInput;
import fr.aquasys.daeau.cms.itf.DocumentStatisticDao;
import fr.aquasys.daeau.user.itf.UserStatisticDao;
import fr.aquasys.daeau.user.model.UserStatistic$;
import fr.aquasys.daeau.user.model.input.StatisticInput;
import fr.aquasys.daeau.user.model.input.StatisticInput$;
import fr.aquasys.rabbitmq.api.application.constants.StatisticEventTypeConstants$;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Singleton;
import model.CmsStatistic$;
import model.ScreenStatistic$;
import model.StationStatistic$;
import model.UsageStatistic$;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.Format$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\tua\u0001\u0002\u0010 \u0001\tB\u0001\"\u000b\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aa\u0007\u0001B\u0001B\u0003%q\u0007\u0003\u0005E\u0001\t\u0005\t\u0015!\u0003F\u0011!A\u0005A!A!\u0002\u0013I\u0005\u0002\u0003'\u0001\u0005\u0003\u0005\u000b\u0011B'\t\u0011A\u0003!\u0011!Q\u0001\nEC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006I!\u0017\u0005\t9\u0002\u0011\t\u0011)A\u0005;\")Q\r\u0001C\u0001M\")Q\u0010\u0001C\u0001}\"9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0002\"CA\u001c\u0001\t\u0007I\u0011AA\u001d\u0011!\t9\u0005\u0001Q\u0001\n\u0005m\u0002bBA%\u0001\u0011\u0005\u00111\n\u0005\b\u0003K\u0002A\u0011AA4\u0011\u001d\tY\u0007\u0001C\u0001\u0003[Bq!! \u0001\t\u0003\ty\bC\u0004\u0002\n\u0002!\t!a#\t\u000f\u0005U\u0005\u0001\"\u0001\u0002\u0018\"9\u0011\u0011\u0015\u0001\u0005\u0002\u0005\r\u0006bBAW\u0001\u0011\u0005\u0011q\u0016\u0005\b\u0003s\u0003A\u0011AA^\u0011\u001d\t)\r\u0001C\u0001\u0003\u000fDq!!5\u0001\t\u0003\t\u0019\u000eC\u0004\u0002^\u0002!\t!a8\t\u000f\u0005%\b\u0001\"\u0001\u0002l\"9\u0011Q\u001f\u0001\u0005\u0002\u0005]\bb\u0002B\u0001\u0001\u0011\u0005!1\u0001\u0002\u0015'R\fG/[:uS\u000e\u001c8i\u001c8ue>dG.\u001a:\u000b\u0003\u0001\n1bY8oiJ|G\u000e\\3sg\u000e\u00011C\u0001\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u0006\u00112o\u0019:fK:\u001cF/\u0019;jgRL7\rR1p!\tY\u0003'D\u0001-\u0015\tic&A\u0002ji\u001aT\u0011aL\u0001\u0004I\u0006|\u0017BA\u0019-\u0005I\u00196M]3f]N#\u0018\r^5ti&\u001cG)Y8\u0002%\u0005\u001cG/[8o'R\fG/[:uS\u000e$\u0015m\u001c\t\u0003WQJ!!\u000e\u0017\u0003%\u0005\u001bG/[8o'R\fG/[:uS\u000e$\u0015m\\\u0001\u0011kN,'o\u0015;bi&\u001cH/[2EC>\u0004\"\u0001\u000f\"\u000e\u0003eR!!\f\u001e\u000b\u0005mb\u0014\u0001B;tKJT!!\u0010 \u0002\u000b\u0011\fW-Y;\u000b\u0005}\u0002\u0015aB1rk\u0006\u001c\u0018p\u001d\u0006\u0002\u0003\u0006\u0011aM]\u0005\u0003\u0007f\u0012\u0001#V:feN#\u0018\r^5ti&\u001cG)Y8\u0002#U\u001c\u0018mZ3Ti\u0006$\u0018n\u001d;jG\u0012\u000bw\u000e\u0005\u0002,\r&\u0011q\t\f\u0002\u0012+N\fw-Z*uCRL7\u000f^5d\t\u0006|\u0017aE:uCRLwN\\*uCRL7\u000f^5d\t\u0006|\u0007CA\u0016K\u0013\tYEFA\nTi\u0006$\u0018n\u001c8Ti\u0006$\u0018n\u001d;jG\u0012\u000bw.A\bd[N\u001cF/\u0019;jgRL7\rR1p!\tYc*\u0003\u0002PY\ty1)\\:Ti\u0006$\u0018n\u001d;jG\u0012\u000bw.\u0001\u000be_\u000e,X.\u001a8u'R\fG/[:uS\u000e$\u0015m\u001c\t\u0003%Zk\u0011a\u0015\u0006\u0003[QS!!\u0016\u001f\u0002\u0007\rl7/\u0003\u0002X'\n!Bi\\2v[\u0016tGo\u0015;bi&\u001cH/[2EC>\f\u0011cY1si>\u001cF/\u0019;jgRL7\rR1p!\tY#,\u0003\u0002\\Y\t\t2)\u0019:u_N#\u0018\r^5ti&\u001cG)Y8\u0002\u000f1|w-\u0016;jYB\u0011alY\u0007\u0002?*\u0011\u0001-Y\u0001\u0005kRLGN\u0003\u0002c}\u0005A!/\u00192cSRl\u0017/\u0003\u0002e?\n9Aj\\4Vi&d\u0017A\u0002\u001fj]&$h\b\u0006\u0006hS*\\G.\u001c8paF\u0004\"\u0001\u001b\u0001\u000e\u0003}AQ!\u000b\u0006A\u0002)BQA\r\u0006A\u0002MBQA\u000e\u0006A\u0002]BQ\u0001\u0012\u0006A\u0002\u0015CQ\u0001\u0013\u0006A\u0002%CQ\u0001\u0014\u0006A\u00025CQ\u0001\u0015\u0006A\u0002ECQ\u0001\u0017\u0006A\u0002eCQ\u0001\u0018\u0006A\u0002uC#AC:\u0011\u0005Q\\X\"A;\u000b\u0005Y<\u0018AB5oU\u0016\u001cGO\u0003\u0002ys\u00061qm\\8hY\u0016T\u0011A_\u0001\u0004G>l\u0017B\u0001?v\u0005\u0019IeN[3di\u0006\u00012M]3bi\u0016\u001cF/\u0019;jgRL7m\u001d\u000b\u0004\u007f\u0006U\u0001\u0003BA\u0001\u0003\u001fqA!a\u0001\u0002\fA\u0019\u0011QA\u0013\u000e\u0005\u0005\u001d!bAA\u0005C\u00051AH]8pizJ1!!\u0004&\u0003\u0019\u0001&/\u001a3fM&!\u0011\u0011CA\n\u0005\u0019\u0019FO]5oO*\u0019\u0011QB\u0013\t\u000f\u0005]1\u00021\u0001\u0002\u001a\u00059Q.Z:tC\u001e,\u0007\u0003BA\u000e\u0003[i!!!\b\u000b\t\u0005}\u0011\u0011E\u0001\u0005UN|gN\u0003\u0003\u0002$\u0005\u0015\u0012\u0001\u00027jENTA!a\n\u0002*\u0005\u0019\u0011\r]5\u000b\u0005\u0005-\u0012\u0001\u00029mCfLA!a\f\u0002\u001e\t9!j\u001d,bYV,\u0017AF2sK\u0006$XmU2sK\u0016t7\u000b^1uSN$\u0018nY:\u0015\u0007}\f)\u0004C\u0004\u0002\u00181\u0001\r!!\u0007\u0002#1|w-\u001b8B]\u0012\u001cu\u000eZ3FGJ\fg.\u0006\u0002\u0002<A1\u00111DA\u001f\u0003\u0003JA!a\u0010\u0002\u001e\t)!+Z1egB)A%a\u0011\u0000\u007f&\u0019\u0011QI\u0013\u0003\rQ+\b\u000f\\33\u0003IawnZ5o\u0003:$7i\u001c3f\u000b\u000e\u0014\u0018M\u001c\u0011\u0002-\u001d,G\u000fT1tiN\u001b'/Z3o'R\fG/[:uS\u000e$\u0012b`A'\u0003\u001f\ny&a\u0019\t\u000f\u0005]q\u00021\u0001\u0002\u001a!9\u0011\u0011K\bA\u0002\u0005M\u0013a\u00025fC\u0012,'o\u001d\t\b\u0003\u0003\t)f`A-\u0013\u0011\t9&a\u0005\u0003\u00075\u000b\u0007\u000fE\u0002%\u00037J1!!\u0018&\u0005\r\te.\u001f\u0005\u0007\u0003Cz\u0001\u0019A@\u0002\r5|G-\u001e7f\u0011\u0015Yt\u00021\u0001\u0000\u0003Y\u0019'/Z1uK\u0006\u001bG/[8o'R\fG/[:uS\u000e\u001cHcA@\u0002j!9\u0011q\u0003\tA\u0002\u0005e\u0011\u0001F2sK\u0006$X-V:feN#\u0018\r^5ti&\u001c7\u000f\u0006\u0006\u0002p\u0005U\u0014qOA=\u0003w\u00022\u0001JA9\u0013\r\t\u0019(\n\u0002\u0005+:LG\u000fC\u0004\u0002\u0018E\u0001\r!!\u0007\t\u000f\u0005E\u0013\u00031\u0001\u0002T!1\u0011\u0011M\tA\u0002}DQaO\tA\u0002}\fQc\u0019:fCR,Wk]1hKN#\u0018\r^5ti&\u001c7\u000f\u0006\u0006\u0002p\u0005\u0005\u00151QAC\u0003\u000fCq!a\u0006\u0013\u0001\u0004\tI\u0002C\u0004\u0002RI\u0001\r!a\u0015\t\r\u0005\u0005$\u00031\u0001\u0000\u0011\u0015Y$\u00031\u0001\u0000\u0003]\u0019'/Z1uKN#\u0018\r^5p]N#\u0018\r^5ti&\u001c7\u000f\u0006\u0006\u0002p\u00055\u0015qRAI\u0003'Cq!a\u0006\u0014\u0001\u0004\tI\u0002C\u0004\u0002RM\u0001\r!a\u0015\t\r\u0005\u00054\u00031\u0001\u0000\u0011\u0015Y4\u00031\u0001\u0000\u0003M\u0019'/Z1uK\u000ek7o\u0015;bi&\u001cH/[2t))\ty'!'\u0002\u001c\u0006u\u0015q\u0014\u0005\b\u0003/!\u0002\u0019AA\r\u0011\u001d\t\t\u0006\u0006a\u0001\u0003'Ba!!\u0019\u0015\u0001\u0004y\b\"B\u001e\u0015\u0001\u0004y\u0018!E4fiV\u001bXM]*uCRL7\u000f^5dgRIq0!*\u0002(\u0006%\u00161\u0016\u0005\b\u0003/)\u0002\u0019AA\r\u0011\u001d\t\t&\u0006a\u0001\u0003'Ba!!\u0019\u0016\u0001\u0004y\b\"B\u001e\u0016\u0001\u0004y\u0018AC4fi\u000e;U\u000bR1uKRIq0!-\u00024\u0006U\u0016q\u0017\u0005\b\u0003/1\u0002\u0019AA\r\u0011\u001d\t\tF\u0006a\u0001\u0003'Ba!!\u0019\u0017\u0001\u0004y\b\"B\u001e\u0017\u0001\u0004y\u0018\u0001G4fiV\u001bXM]*uCRLwN\\*uCRL7\u000f^5dgRIq0!0\u0002@\u0006\u0005\u00171\u0019\u0005\b\u0003/9\u0002\u0019AA\r\u0011\u001d\t\tf\u0006a\u0001\u0003'Ba!!\u0019\u0018\u0001\u0004y\b\"B\u001e\u0018\u0001\u0004y\u0018AF4fiV\u001bXM]+tC\u001e,7\u000b^1uSN$\u0018nY:\u0015\u0013}\fI-a3\u0002N\u0006=\u0007bBA\f1\u0001\u0007\u0011\u0011\u0004\u0005\b\u0003#B\u0002\u0019AA*\u0011\u0019\t\t\u0007\u0007a\u0001\u007f\")1\b\u0007a\u0001\u007f\u0006!r-\u001a;Vg\u0016\u00148)\\:Ti\u0006$\u0018n\u001d;jGN$\u0012b`Ak\u0003/\fI.a7\t\u000f\u0005]\u0011\u00041\u0001\u0002\u001a!9\u0011\u0011K\rA\u0002\u0005M\u0003BBA13\u0001\u0007q\u0010C\u0003<3\u0001\u0007q0\u0001\u000bhKR\fE\u000e\\+tKJ\u001cF/\u0019;jgRL7m\u001d\u000b\n\u007f\u0006\u0005\u00181]As\u0003ODq!a\u0006\u001b\u0001\u0004\tI\u0002C\u0004\u0002Ri\u0001\r!a\u0015\t\r\u0005\u0005$\u00041\u0001\u0000\u0011\u0015Y$\u00041\u0001\u0000\u0003]9W\r^!mYN#\u0018\r^5p]N#\u0018\r^5ti&\u001c7\u000fF\u0005\u0000\u0003[\fy/!=\u0002t\"9\u0011qC\u000eA\u0002\u0005e\u0001bBA)7\u0001\u0007\u00111\u000b\u0005\u0007\u0003CZ\u0002\u0019A@\t\u000bmZ\u0002\u0019A@\u0002+\u001d,G/\u00117m+N\fw-Z*uCRL7\u000f^5dgRIq0!?\u0002|\u0006u\u0018q \u0005\b\u0003/a\u0002\u0019AA\r\u0011\u001d\t\t\u0006\ba\u0001\u0003'Ba!!\u0019\u001d\u0001\u0004y\b\"B\u001e\u001d\u0001\u0004y\u0018aE4fi\u0006cGnQ7t'R\fG/[:uS\u000e\u001cH#C@\u0003\u0006\t\u001d!\u0011\u0002B\u0006\u0011\u001d\t9\"\ba\u0001\u00033Aq!!\u0015\u001e\u0001\u0004\t\u0019\u0006\u0003\u0004\u0002bu\u0001\ra \u0005\u0006wu\u0001\ra \u0015\u0004\u0001\t=\u0001\u0003\u0002B\t\u00053i!Aa\u0005\u000b\u0007Y\u0014)B\u0003\u0002\u0003\u0018\u0005)!.\u0019<bq&!!1\u0004B\n\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class StatisticsController {
    private final ScreenStatisticDao screenStatisticDao;
    private final ActionStatisticDao actionStatisticDao;
    private final UserStatisticDao userStatisticDao;
    private final UsageStatisticDao usageStatisticDao;
    private final StationStatisticDao stationStatisticDao;
    private final CmsStatisticDao cmsStatisticDao;
    private final DocumentStatisticDao documentStatisticDao;
    private final CartoStatisticDao cartoStatisticDao;
    private final LogUtil logUtil;
    private final Reads<Tuple2<String, String>> loginAndCodeEcran;

    public String createStatistics(JsValue message) {
        return (String)message.validate((Reads)Format$.MODULE$.GenericFormat(CreateStatisticInput$.MODULE$.format(), CreateStatisticInput$.MODULE$.format())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)createStatisticInput -> {
            if (!createStatisticInput.login().contains("_service")) {
                boolean bl;
                StatisticInput statisticInput = new StatisticInput(createStatisticInput.login(), createStatisticInput.eventType(), createStatisticInput.module(), createStatisticInput.value());
                String string = createStatisticInput.eventType();
                String string2 = StatisticEventTypeConstants$.MODULE$.LOGIN();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    bl = true;
                } else {
                    String string4 = StatisticEventTypeConstants$.MODULE$.LOGOUT();
                    String string5 = string;
                    if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                        bl = true;
                    } else {
                        String string6 = StatisticEventTypeConstants$.MODULE$.CGU();
                        String string7 = string;
                        bl = !(string6 != null ? !string6.equals(string7) : string7 != null);
                    }
                }
                if (bl) {
                    return $this.userStatisticDao.create(statisticInput).toString();
                }
                String string8 = StatisticEventTypeConstants$.MODULE$.USAGE();
                String string9 = string;
                if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                    return $this.usageStatisticDao.create(statisticInput).toString();
                }
                String string10 = StatisticEventTypeConstants$.MODULE$.STATION();
                String string11 = string;
                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                    return $this.stationStatisticDao.create(statisticInput).toString();
                }
                String string12 = StatisticEventTypeConstants$.MODULE$.DOCUMENT();
                String string13 = string;
                if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                    return Integer.toString($this.documentStatisticDao.create(new DocumentStatisticInput(createStatisticInput.login(), createStatisticInput.module(), createStatisticInput.value(), (Option)None$.MODULE$)));
                }
                String string14 = StatisticEventTypeConstants$.MODULE$.CMS();
                String string15 = string;
                if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                    return $this.cmsStatisticDao.create(statisticInput).toString();
                }
                String string16 = StatisticEventTypeConstants$.MODULE$.CARTO();
                String string17 = string;
                if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                    return $this.cartoStatisticDao.create(statisticInput).toString();
                }
                throw new MatchError((Object)string);
            }
            $this.logUtil.info(new StringBuilder(33).append("Can't create statistic for user: ").append(createStatisticInput.login()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        });
    }

    public String createScreenStatistics(JsValue message) {
        return (String)message.validate((Reads)Format$.MODULE$.GenericFormat(ScreenStatisticInput$.MODULE$.format(), ScreenStatisticInput$.MODULE$.format())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)screenStatisticInput -> {
            if (!screenStatisticInput.login().contains("_service")) {
                return $this.screenStatisticDao.create((ScreenStatisticInput)screenStatisticInput).toString();
            }
            $this.logUtil.info(new StringBuilder(33).append("Can't create statistic for user: ").append(screenStatisticInput.login()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        });
    }

    public Reads<Tuple2<String, String>> loginAndCodeEcran() {
        return this.loginAndCodeEcran;
    }

    public String getLastScreenStatistic(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.loginAndCodeEcran()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)screenStatisticInput -> {
            Tuple2 tuple2 = screenStatisticInput;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            String screenCode = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)screenCode);
            String login2 = (String)tuple22._1();
            String screenCode2 = (String)tuple22._2();
            if (!login2.contains("_service")) {
                return Json$.MODULE$.toJson($this.screenStatisticDao.getLast(login2, screenCode2), Writes$.MODULE$.OptionWrites((Writes)Format$.MODULE$.GenericFormat(ScreenStatistic$.MODULE$.format(), ScreenStatistic$.MODULE$.format()))).toString();
            }
            $this.logUtil.info(new StringBuilder(35).append("Can't get last statistic for user: ").append(login2).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        });
    }

    public String createActionStatistics(JsValue message) {
        return (String)message.validate((Reads)Format$.MODULE$.GenericFormat(ActionStatisticInput$.MODULE$.format(), ActionStatisticInput$.MODULE$.format())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)actionStatisticInput -> {
            if (!actionStatisticInput.login().contains("_service")) {
                return $this.actionStatisticDao.create((ActionStatisticInput)actionStatisticInput).toString();
            }
            $this.logUtil.info(new StringBuilder(33).append("Can't create statistic for user: ").append(actionStatisticInput.login()).toString(), $this.logUtil.info$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        });
    }

    public void createUserStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        message.validate((Reads)Format$.MODULE$.GenericFormat((Reads)StatisticInput$.MODULE$.telecomFormat(), (Writes)StatisticInput$.MODULE$.telecomFormat())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> {
            if (!input.login().contains("_service")) {
                return $this.userStatisticDao.create(input);
            }
            return BoxedUnit.UNIT;
        });
    }

    public void createUsageStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        message.validate((Reads)Format$.MODULE$.GenericFormat((Reads)StatisticInput$.MODULE$.telecomFormat(), (Writes)StatisticInput$.MODULE$.telecomFormat())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> {
            if (!input.login().contains("_service")) {
                return $this.usageStatisticDao.create((StatisticInput)input);
            }
            return BoxedUnit.UNIT;
        });
    }

    public void createStationStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        message.validate((Reads)Format$.MODULE$.GenericFormat((Reads)StatisticInput$.MODULE$.telecomFormat(), (Writes)StatisticInput$.MODULE$.telecomFormat())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> {
            if (!input.login().contains("_service")) {
                return $this.stationStatisticDao.create((StatisticInput)input);
            }
            return BoxedUnit.UNIT;
        });
    }

    public void createCmsStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        message.validate((Reads)Format$.MODULE$.GenericFormat((Reads)StatisticInput$.MODULE$.telecomFormat(), (Writes)StatisticInput$.MODULE$.telecomFormat())).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> {
            if (!input.login().contains("_service")) {
                return $this.cmsStatisticDao.create((StatisticInput)input);
            }
            return BoxedUnit.UNIT;
        });
    }

    public String getUserStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStatistic$.MODULE$.read()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> Json$.MODULE$.toJson((Object)$this.userStatisticDao.get(input), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UserStatistic$.MODULE$.userStatisticWrite())).toString());
    }

    public String getCGUDate(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStatistic$.MODULE$.read()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"date"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)$this.userStatisticDao.getCGUDate(input), Writes$.MODULE$.OptionWrites((Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites()))))})).toString());
    }

    public String getUserStationStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStatistic$.MODULE$.read()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> Json$.MODULE$.toJson($this.stationStatisticDao.get((String)input), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), StationStatistic$.MODULE$.userStatisticWrite())).toString());
    }

    public String getUserUsageStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStatistic$.MODULE$.read()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> Json$.MODULE$.toJson($this.usageStatisticDao.get((String)input), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UsageStatistic$.MODULE$.userStatisticWrite())).toString());
    }

    public String getUserCmsStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStatistic$.MODULE$.read()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(error.toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.IntReads(), (Writes)Writes$.MODULE$.IntWrites())))})).toString();
        }, (Function1 & Serializable)input -> Json$.MODULE$.toJson($this.cmsStatisticDao.get((String)input), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), CmsStatistic$.MODULE$.userStatisticWrite())).toString());
    }

    public String getAllUserStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson((Object)this.userStatisticDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UserStatistic$.MODULE$.userStatisticWrite())).toString();
    }

    public String getAllStationStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.stationStatisticDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), StationStatistic$.MODULE$.userStatisticWrite())).toString();
    }

    public String getAllUsageStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.usageStatisticDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UsageStatistic$.MODULE$.userStatisticWrite())).toString();
    }

    public String getAllCmsStatistics(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.cmsStatisticDao.getAll(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), CmsStatistic$.MODULE$.userStatisticWrite())).toString();
    }

    @Inject
    public StatisticsController(ScreenStatisticDao screenStatisticDao, ActionStatisticDao actionStatisticDao, UserStatisticDao userStatisticDao, UsageStatisticDao usageStatisticDao, StationStatisticDao stationStatisticDao, CmsStatisticDao cmsStatisticDao, DocumentStatisticDao documentStatisticDao, CartoStatisticDao cartoStatisticDao, LogUtil logUtil) {
        this.screenStatisticDao = screenStatisticDao;
        this.actionStatisticDao = actionStatisticDao;
        this.userStatisticDao = userStatisticDao;
        this.usageStatisticDao = usageStatisticDao;
        this.stationStatisticDao = stationStatisticDao;
        this.cmsStatisticDao = cmsStatisticDao;
        this.documentStatisticDao = documentStatisticDao;
        this.cartoStatisticDao = cartoStatisticDao;
        this.logUtil = logUtil;
        this.loginAndCodeEcran = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("login").read((Reads)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites())), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("codeEcran").read((Reads)Format$.MODULE$.GenericFormat((Reads)Reads$.MODULE$.StringReads(), (Writes)Writes$.MODULE$.StringWrites()))).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

