/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import fr.aquasys.daeau.administration.itf.SieauParametersDao;
import fr.aquasys.daeau.referentials.contact.Contact;
import fr.aquasys.daeau.referentials.contact.ContactDao;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.itf.UserMessageDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.daeau.user.model.chat.UserMessage;
import fr.aquasys.daeau.user.model.chat.UserMessage$;
import fr.aquasys.daeau.user.model.chat.input.UserMessageInput;
import fr.aquasys.daeau.user.model.chat.input.UserMessageInput$;
import fr.aquasys.rabbitmq.api.constant.MailRouting$;
import fr.aquasys.rabbitmq.util.JobLogUtil$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import java.io.File;
import java.io.Serializable;
import javax.inject.Inject;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Properties$;

@ScalaSignature(bytes="\u0006\u0005\u00055d\u0001\u0002\n\u0014\u0001YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006YA\b\u0005\tY\u0001\u0011\t\u0011)A\u0006[!A\u0001\u0007\u0001B\u0001B\u0003-\u0011\u0007\u0003\u0005:\u0001\t\u0005\t\u0015a\u0003;\u0011!\t\u0005A!A!\u0002\u0017\u0011\u0005\"\u0002&\u0001\t\u0003Y\u0005bB/\u0001\u0005\u0004%\tA\u0018\u0005\u0007U\u0002\u0001\u000b\u0011B0\t\u000b-\u0004A\u0011\u00017\t\u000f\u00055\u0001\u0001\"\u0001\u0002\u0010!9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\ti\u0004\u0001C\u0001\u0003\u007fAq!!\u0013\u0001\t\u0003\tY\u0005C\u0004\u0002V\u0001!\t!a\u0016\t\u000f\u0005\u0005\u0004\u0001\"\u0001\u0002d\t1Rk]3s\u001b\u0016\u001c8/Y4fg\u000e{g\u000e\u001e:pY2,'OC\u0001\u0015\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001a\u0006\t\u00031mi\u0011!\u0007\u0006\u00025\u0005)1oY1mC&\u0011A$\u0007\u0002\u0007\u0003:L(+\u001a4\u0002\u001dU\u001cXM]'fgN\fw-\u001a#b_B\u0011qDK\u0007\u0002A)\u0011\u0011EI\u0001\u0004SR4'BA\u0012%\u0003\u0011)8/\u001a:\u000b\u0005\u00152\u0013!\u00023bK\u0006,(BA\u0014)\u0003\u001d\t\u0017/^1tsNT\u0011!K\u0001\u0003MJL!a\u000b\u0011\u0003\u001dU\u001bXM]'fgN\fw-\u001a#b_\u00069Qo]3s\t\u0006|\u0007CA\u0010/\u0013\ty\u0003EA\u0004Vg\u0016\u0014H)Y8\u0002\u0015\r|g\u000e^1di\u0012\u000bw\u000e\u0005\u00023o5\t1G\u0003\u00025k\u000591m\u001c8uC\u000e$(B\u0001\u001c%\u00031\u0011XMZ3sK:$\u0018.\u00197t\u0013\tA4G\u0001\u0006D_:$\u0018m\u0019;EC>\f!c]5fCV\u0004\u0016M]1nKR,'o\u001d#b_B\u00111hP\u0007\u0002y)\u0011\u0011%\u0010\u0006\u0003}\u0011\na\"\u00193nS:L7\u000f\u001e:bi&|g.\u0003\u0002Ay\t\u00112+[3bkB\u000b'/Y7fi\u0016\u00148\u000fR1p\u0003\u001dawnZ+uS2\u0004\"a\u0011%\u000e\u0003\u0011S!!\u0012$\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f\u001a\n\u0001B]1cE&$X.]\u0005\u0003\u0013\u0012\u0013q\u0001T8h+RLG.\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019R1Qj\u0014)R%N\u0003\"A\u0014\u0001\u000e\u0003MAQ!\b\u0004A\u0004yAQ\u0001\f\u0004A\u00045BQ\u0001\r\u0004A\u0004EBQ!\u000f\u0004A\u0004iBQ!\u0011\u0004A\u0004\tC#AB+\u0011\u0005Y[V\"A,\u000b\u0005aK\u0016AB5oU\u0016\u001cGOC\u0001[\u0003\u0015Q\u0017M^1y\u0013\tavK\u0001\u0004J]*,7\r^\u0001\rI&\u0014Xm\u0019;pef,eN^\u000b\u0002?B\u0011\u0001m\u001a\b\u0003C\u0016\u0004\"AY\r\u000e\u0003\rT!\u0001Z\u000b\u0002\rq\u0012xn\u001c;?\u0013\t1\u0017$\u0001\u0004Qe\u0016$WMZ\u0005\u0003Q&\u0014aa\u0015;sS:<'B\u00014\u001a\u00035!\u0017N]3di>\u0014\u00180\u00128wA\u0005\u0019q-\u001a;\u0015\u000f}k70a\u0002\u0002\f!)a.\u0003a\u0001_\u00069Q.Z:tC\u001e,\u0007C\u00019z\u001b\u0005\t(B\u0001:t\u0003\u0011Q7o\u001c8\u000b\u0005Q,\u0018\u0001\u00027jENT!A^<\u0002\u0007\u0005\u0004\u0018NC\u0001y\u0003\u0011\u0001H.Y=\n\u0005i\f(a\u0002&t-\u0006dW/\u001a\u0005\u0006y&\u0001\r!`\u0001\bQ\u0016\fG-\u001a:t!\u0015\u0001gpXA\u0001\u0013\ty\u0018NA\u0002NCB\u00042\u0001GA\u0002\u0013\r\t)!\u0007\u0002\u0004\u0003:L\bBBA\u0005\u0013\u0001\u0007q,\u0001\u0004n_\u0012,H.\u001a\u0005\u0006G%\u0001\raX\u0001\u000bO\u0016$()\u001f'pO&tG#C0\u0002\u0012\u0005M\u0011QCA\f\u0011\u0015q'\u00021\u0001p\u0011\u0015a(\u00021\u0001~\u0011\u0019\tIA\u0003a\u0001?\")1E\u0003a\u0001?\u0006yq-\u001a;MCN$X*Z:tC\u001e,7\u000fF\u0005`\u0003;\ty\"!\t\u0002$!)an\u0003a\u0001_\")Ap\u0003a\u0001{\"1\u0011\u0011B\u0006A\u0002}CQaI\u0006A\u0002}\u000b\u0001bZ3u\u0005f\u001cUn\u001d\u000b\n?\u0006%\u00121FA\u0017\u0003_AQA\u001c\u0007A\u0002=DQ\u0001 \u0007A\u0002uDa!!\u0003\r\u0001\u0004y\u0006\"B\u0012\r\u0001\u0004y\u0016!D2sK\u0006$X-T3tg\u0006<W\rF\u0005`\u0003k\t9$!\u000f\u0002<!)a.\u0004a\u0001_\")A0\u0004a\u0001{\"1\u0011\u0011B\u0007A\u0002}CQaI\u0007A\u0002}\u000bQ\"\u001e9eCR,W*Z:tC\u001e,G#C0\u0002B\u0005\r\u0013QIA$\u0011\u0015qg\u00021\u0001p\u0011\u0015ah\u00021\u0001~\u0011\u0019\tIA\u0004a\u0001?\")1E\u0004a\u0001?\u00061A-\u001a7fi\u0016$\u0012bXA'\u0003\u001f\n\t&a\u0015\t\u000b9|\u0001\u0019A8\t\u000bq|\u0001\u0019A?\t\r\u0005%q\u00021\u0001`\u0011\u0015\u0019s\u00021\u0001`\u00035!W\r\\3uK\nKHj\\4j]RIq,!\u0017\u0002\\\u0005u\u0013q\f\u0005\u0006]B\u0001\ra\u001c\u0005\u0006yB\u0001\r! \u0005\u0007\u0003\u0013\u0001\u0002\u0019A0\t\u000b\r\u0002\u0002\u0019A0\u0002\u0017\u0011,G.\u001a;f\u0005f\u001cUn\u001d\u000b\n?\u0006\u0015\u0014qMA5\u0003WBQA\\\tA\u0002=DQ\u0001`\tA\u0002uDa!!\u0003\u0012\u0001\u0004y\u0006\"B\u0012\u0012\u0001\u0004y\u0006")
public class UserMessagesController {
    private final UserMessageDao userMessageDao;
    private final UserDao userDao;
    private final ContactDao contactDao;
    private final SieauParametersDao sieauParametersDao;
    private final LogUtil logUtil;
    private final String directoryEnv;

    public String directoryEnv() {
        return this.directoryEnv;
    }

    public String get(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to get message id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)idMessage -> UserMessagesController.$anonfun$get$2(this, BoxesRunTime.unboxToInt((Object)idMessage)));
    }

    public String getByLogin(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.loginReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(35).append("Error validate Json to get login :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)login -> {
            Seq messagesByLogin = $this.userMessageDao.getByLogin(login);
            return Json$.MODULE$.toJson((Object)messagesByLogin, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)UserMessage$.MODULE$.format())).toString();
        });
    }

    public String getLastMessages(JsValue message, Map<String, Object> headers, String module, String user) {
        Seq lastMessages = this.userMessageDao.getLastMessages();
        return Json$.MODULE$.toJson((Object)lastMessages, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)UserMessage$.MODULE$.format())).toString();
    }

    public String getByCms(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(36).append("Error validate Json to get cms id :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)idCms -> UserMessagesController.$anonfun$getByCms$2(this, BoxesRunTime.unboxToInt((Object)idCms)));
    }

    public String createMessage(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserMessageInput$.MODULE$.readUserAndMessage()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to create message :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            String login = (String)validate._1();
            UserMessageInput messageInput = (UserMessageInput)validate._2();
            Option option = $this.userMessageDao.insert(messageInput, login);
            if (option instanceof Some) {
                Some some = (Some)option;
                long id = BoxesRunTime.unboxToLong((Object)some.value());
                Option option2 = $this.userDao.get(messageInput.login());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    User user = (User)some2.value();
                    String mailTemplateFile = new StringBuilder(30).append((String)package$.MODULE$.env().getOrElse((Object)this.directoryEnv(), (Function0 & Serializable)() -> {
                        throw new Exception("UPLOAD_DIRECTORY is not in .env");
                    })).append("MODELES/MAIL/contact-user.html").toString();
                    String file = new File(mailTemplateFile).exists() ? mailTemplateFile : this.getClass().getResource("/contact-user.html").toURI().toString();
                    String message = Source$.MODULE$.fromFile(file, Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString("");
                    String supportAdress = (String)$this.sieauParametersDao.getString("supportMailAddress", "SIEAU").getOrElse((Function0 & Serializable)() -> "support@aquasys.fr");
                    if (login.equals(messageInput.login())) {
                        JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(38).append("[").append(Properties$.MODULE$.envOrElse("CUSTOMER", (Function0 & Serializable)() -> "")).append("] Notification de message utilisateur").toString(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"noreply@aquasys.fr", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)supportAdress, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
                        JobLogUtil$.MODULE$.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
                        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)id), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mail"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                    }
                    if (user.contactCode().isDefined()) {
                        Option contact = $this.contactDao.get((int)BoxesRunTime.unboxToDouble((Object)user.contactCode().get()));
                        if (contact.isDefined() && ((Contact)contact.get()).email().isDefined()) {
                            JsObject body = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)message, (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"subject"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)new StringBuilder(38).append("[").append(Properties$.MODULE$.envOrElse("CUSTOMER", (Function0 & Serializable)() -> "")).append("] Notification de message utilisateur").toString(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"from"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)"noreply@aquasys.fr", (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"to"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper(((Contact)contact.get()).email().get(), (Writes)Writes$.MODULE$.StringWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"isHtml"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)true), (Writes)Writes$.MODULE$.BooleanWrites()))}));
                            JobLogUtil$.MODULE$.sendTopic(MailRouting$.MODULE$.MAIL_SEND(), body.toString());
                            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)id), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mail"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                        }
                        $this.logUtil.error("Contact or email is not defined", $this.logUtil.error$default$2());
                        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"create"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)1), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"id"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToLong((long)id), (Writes)Writes$.MODULE$.LongWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mail"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                    }
                    $this.logUtil.error("User has no contact", $this.logUtil.error$default$2());
                    return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
                }
                $this.logUtil.error("User not found", $this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error("Error on create message", $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)500), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String updateMessage(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserMessage$.MODULE$.readUserAndIdAndMessage()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to update message :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            String login = (String)validate._1();
            int idMessage = BoxesRunTime.unboxToInt((Object)validate._2());
            UserMessage messageUpdate = (UserMessage)validate._3();
            Option option = $this.userMessageDao.get((long)idMessage);
            if (option instanceof Some) {
                int res = $this.userMessageDao.update(messageUpdate, login);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            $this.logUtil.error(new StringBuilder(27).append("Message not found for id : ").append(idMessage).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String delete(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(40).append("Error validate Json to delete message :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)idMessage -> UserMessagesController.$anonfun$delete$2(this, BoxesRunTime.unboxToInt((Object)idMessage)));
    }

    public String deleteByLogin(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.loginReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(49).append("Error validate Json to delete message by login :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)login -> {
            int res = $this.userMessageDao.deleteByLogin(login);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteByCms(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(CommonReadUtil$.MODULE$.idReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(47).append("Error validate Json to delete message by cms :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)idCms -> UserMessagesController.$anonfun$deleteByCms$2(this, BoxesRunTime.unboxToInt((Object)idCms)));
    }

    public static final /* synthetic */ String $anonfun$get$2(UserMessagesController $this, int idMessage) {
        Option option = $this.userMessageDao.get((long)idMessage);
        if (option instanceof Some) {
            Some some = (Some)option;
            UserMessage message = (UserMessage)some.value();
            return Json$.MODULE$.toJson((Object)message, (Writes)UserMessage$.MODULE$.format()).toString();
        }
        $this.logUtil.error(new StringBuilder(27).append("Message not found for id : ").append(idMessage).toString(), $this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$getByCms$2(UserMessagesController $this, int idCms) {
        Seq messagesByCms = $this.userMessageDao.getByCms((long)idCms);
        return Json$.MODULE$.toJson((Object)messagesByCms, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)UserMessage$.MODULE$.format())).toString();
    }

    public static final /* synthetic */ String $anonfun$delete$2(UserMessagesController $this, int idMessage) {
        Option option = $this.userMessageDao.get((long)idMessage);
        if (option instanceof Some) {
            int res = $this.userMessageDao.delete((long)idMessage);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }
        $this.logUtil.error(new StringBuilder(27).append("Message not found for id : ").append(idMessage).toString(), $this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public static final /* synthetic */ String $anonfun$deleteByCms$2(UserMessagesController $this, int idCms) {
        int res = $this.userMessageDao.deleteByCms((long)idCms);
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"delete"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)res), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    @Inject
    public UserMessagesController(UserMessageDao userMessageDao, UserDao userDao, ContactDao contactDao, SieauParametersDao sieauParametersDao, LogUtil logUtil) {
        this.userMessageDao = userMessageDao;
        this.userDao = userDao;
        this.contactDao = contactDao;
        this.sieauParametersDao = sieauParametersDao;
        this.logUtil = logUtil;
        this.directoryEnv = "UPLOAD_DIRECTORY";
    }
}

