/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import dao.itf.UserModuleDao;
import dao.itf.UserParameterDao;
import fr.aquasys.rabbitmq.util.LogUtil;
import java.io.Serializable;
import javax.inject.Inject;
import model.UserParameter;
import model.UserParameter$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult;
import play.api.libs.json.JsSuccess;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import util.UserParameterUtil$;

@ScalaSignature(bytes="\u0006\u0005\u0005-b\u0001\u0002\b\u0010\u0001IA\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006YA\u0007\u0005\tE\u0001\u0011\t\u0011)A\u0006G!Aa\u0005\u0001B\u0001B\u0003-q\u0005C\u00034\u0001\u0011\u0005A\u0007C\u0003E\u0001\u0011\u0005Q\tC\u0003l\u0001\u0011\u0005A\u000eC\u0003r\u0001\u0011\u0005!\u000fC\u0003x\u0001\u0011\u0005\u0001\u0010C\u0004~\u0001\t\u0007I\u0011\u0001@\t\u000f\u0005\u0015\u0001\u0001)A\u0005\u007f\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\n\u0001\u0011\u0005\u0011Q\u0003\u0005\b\u0003?\u0001A\u0011AA\u0011\u0005])6/\u001a:QCJ\fW.\u001a;fe\u000e{g\u000e\u001e:pY2,'OC\u0001\u0011\u0003-\u0019wN\u001c;s_2dWM]:\u0004\u0001M\u0011\u0001a\u0005\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0002!U\u001cXM\u001d)be\u0006lW\r^3s\t\u0006|\u0007CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\rIGO\u001a\u0006\u0002?\u0005\u0019A-Y8\n\u0005\u0005b\"\u0001E+tKJ\u0004\u0016M]1nKR,'\u000fR1p\u00035)8/\u001a:N_\u0012,H.\u001a#b_B\u00111\u0004J\u0005\u0003Kq\u0011Q\"V:fe6{G-\u001e7f\t\u0006|\u0017a\u00027pOV#\u0018\u000e\u001c\t\u0003QEj\u0011!\u000b\u0006\u0003U-\nA!\u001e;jY*\u0011A&L\u0001\te\u0006\u0014'-\u001b;nc*\u0011afL\u0001\bCF,\u0018m]=t\u0015\u0005\u0001\u0014A\u00014s\u0013\t\u0011\u0014FA\u0004M_\u001e,F/\u001b7\u0002\rqJg.\u001b;?)\u0005)D\u0003\u0002\u001c9si\u0002\"a\u000e\u0001\u000e\u0003=AQ!\u0007\u0003A\u0004iAQA\t\u0003A\u0004\rBQA\n\u0003A\u0004\u001dB#\u0001\u0002\u001f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015AB5oU\u0016\u001cGOC\u0001B\u0003\u0015Q\u0017M^1y\u0013\t\u0019eH\u0001\u0004J]*,7\r^\u0001\u0010GJ,\u0017\r^3QCJ\fW.\u001a;feR)a)U0hSB\u0011qI\u0014\b\u0003\u00112\u0003\"!S\u000b\u000e\u0003)S!aS\t\u0002\rq\u0012xn\u001c;?\u0013\tiU#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001fB\u0013aa\u0015;sS:<'BA'\u0016\u0011\u0015\u0011V\u00011\u0001T\u0003\u001diWm]:bO\u0016\u0004\"\u0001V/\u000e\u0003US!AV,\u0002\t)\u001cxN\u001c\u0006\u00031f\u000bA\u0001\\5cg*\u0011!lW\u0001\u0004CBL'\"\u0001/\u0002\tAd\u0017-_\u0005\u0003=V\u0013qAS:WC2,X\rC\u0003a\u000b\u0001\u0007\u0011-A\u0004iK\u0006$WM]:\u0011\t\u001d\u0013g\tZ\u0005\u0003GB\u00131!T1q!\t!R-\u0003\u0002g+\t\u0019\u0011I\\=\t\u000b!,\u0001\u0019\u0001$\u0002\r5|G-\u001e7f\u0011\u0015QW\u00011\u0001G\u0003\u0011)8/\u001a:\u0002\u001fU\u0004H-\u0019;f!\u0006\u0014\u0018-\\3uKJ$RAR7o_BDQA\u0015\u0004A\u0002MCQ\u0001\u0019\u0004A\u0002\u0005DQ\u0001\u001b\u0004A\u0002\u0019CQA\u001b\u0004A\u0002\u0019\u000b\u0001#\u001e9eCR,\u0007+\u0019:b[\u0016$XM]:\u0015\u000b\u0019\u001bH/\u001e<\t\u000bI;\u0001\u0019A*\t\u000b\u0001<\u0001\u0019A1\t\u000b!<\u0001\u0019\u0001$\t\u000b)<\u0001\u0019\u0001$\u0002\u001f\u0011,G.\u001a;f!\u0006\u0014\u0018-\\3uKJ$RAR={wrDQA\u0015\u0005A\u0002MCQ\u0001\u0019\u0005A\u0002\u0005DQ\u0001\u001b\u0005A\u0002\u0019CQA\u001b\u0005A\u0002\u0019\u000bA#^:fe6{G-\u001e7f\u0005f,&\u000f\u001c*fC\u0012\u001cX#A@\u0011\tQ\u000b\tAR\u0005\u0004\u0003\u0007)&!\u0002*fC\u0012\u001c\u0018!F;tKJlu\u000eZ;mK\nKXK\u001d7SK\u0006$7\u000fI\u0001\u0019O\u0016$Xj\u001c3vY\u0016\u0014\u00150\u0016:m!\u0006\u0014\u0018-\\3uKJ\u001cH#\u0003$\u0002\f\u00055\u0011qBA\t\u0011\u0015\u00116\u00021\u0001T\u0011\u0015\u00017\u00021\u0001b\u0011\u0015A7\u00021\u0001G\u0011\u0015Q7\u00021\u0001G\u0003m9W\r^!mY\u0006\u0003\b\u000f\\5dCRLg/\u001a)be\u0006lW\r^3sgRIa)a\u0006\u0002\u001a\u0005m\u0011Q\u0004\u0005\u0006%2\u0001\ra\u0015\u0005\u0006A2\u0001\r!\u0019\u0005\u0006Q2\u0001\rA\u0012\u0005\u0006U2\u0001\rAR\u0001\u0012O\u0016$Xk]3s!\u0006\u0014\u0018-\\3uKJ\u001cH#\u0003$\u0002$\u0005\u0015\u0012qEA\u0015\u0011\u0015\u0011V\u00021\u0001T\u0011\u0015\u0001W\u00021\u0001b\u0011\u0015AW\u00021\u0001G\u0011\u0015QW\u00021\u0001G\u0001")
public class UserParameterController {
    private final UserParameterDao userParameterDao;
    private final UserModuleDao userModuleDao;
    private final LogUtil logUtil;
    private final Reads<String> userModuleByUrlReads;

    public String createParameter(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(UserParameter$.MODULE$.userReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String login = (String)((Tuple3)jsSuccess.get())._1();
            String parameter = (String)((Tuple3)jsSuccess.get())._2();
            String value = (String)((Tuple3)jsSuccess.get())._3();
            Option<UserParameter> option = this.userParameterDao.get(login, parameter);
            if (None$.MODULE$.equals(option)) {
                UserParameter userParameter = new UserParameter(login, parameter, (Option<String>)Option$.MODULE$.apply((Object)value), UserParameter$.MODULE$.$lessinit$greater$default$4());
                int n = this.userParameterDao.create(userParameter);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (option instanceof Some) {
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)401), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        }
        this.logUtil.error("Error on create parameter", this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String updateParameter(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(UserParameter$.MODULE$.userReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String login = (String)((Tuple3)jsSuccess.get())._1();
            String parameter = (String)((Tuple3)jsSuccess.get())._2();
            String value = (String)((Tuple3)jsSuccess.get())._3();
            Option<UserParameter> option = this.userParameterDao.get(login, parameter);
            if (option instanceof Some) {
                UserParameter userParameter = new UserParameter(login, parameter, (Option<String>)Option$.MODULE$.apply((Object)value), UserParameter$.MODULE$.$lessinit$greater$default$4());
                int n = this.userParameterDao.update(userParameter);
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                return this.createParameter(message, headers, module, user);
            }
            throw new MatchError(option);
        }
        this.logUtil.error("Error on update parameter", this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public String updateParameters(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserParameter$.MODULE$.userParametersReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(61).append("Error validate Json to update parameters for specific user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateRead -> {
            String login = (String)validateRead._1();
            Seq parameters = (Seq)validateRead._2();
            $this.userParameterDao.delete(login);
            $this.userParameterDao.insert((Seq<UserParameter>)parameters);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)parameters.length()), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)parameters.length()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String deleteParameter(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(UserParameter$.MODULE$.userParamReads());
        if (jsResult instanceof JsSuccess) {
            String parameter;
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String login = (String)((Tuple2)jsSuccess.get())._1();
            Option<UserParameter> option = this.userParameterDao.get(login, parameter = (String)((Tuple2)jsSuccess.get())._2());
            if (option instanceof Some) {
                Some some = (Some)option;
                UserParameter userParam = (UserParameter)some.value();
                int n = this.userParameterDao.delete(userParam.login(), userParam.parameter());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)n), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)0), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            if (None$.MODULE$.equals(option)) {
                this.logUtil.error(new StringBuilder(22).append("Parameter not found : ").append(parameter).toString(), this.logUtil.error$default$2());
                return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)404), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
            }
            throw new MatchError(option);
        }
        this.logUtil.error("Error on delete parameter", this.logUtil.error$default$2());
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
    }

    public Reads<String> userModuleByUrlReads() {
        return this.userModuleByUrlReads;
    }

    public String getModuleByUrlParameters(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userModuleByUrlReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(30).append("Can't get module parameters :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)url -> Json$.MODULE$.toJson($this.userModuleDao.getModuleParametersByUrl((String)url), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UserParameter$.MODULE$.userHabilitationFormat())).toString());
    }

    public String getAllApplicativeParameters(JsValue message, Map<String, Object> headers, String module, String user) {
        return Json$.MODULE$.toJson(this.userModuleDao.getApplicativeUsersParameters(), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UserParameter$.MODULE$.userHabilitationFormat())).toString();
    }

    public String getUserParameters(JsValue message, Map<String, Object> headers, String module, String user) {
        JsResult jsResult = message.validate(UserParameter$.MODULE$.userParameterReads());
        if (jsResult instanceof JsSuccess) {
            JsSuccess jsSuccess = (JsSuccess)jsResult;
            String login = (String)jsSuccess.get();
            Seq<UserParameter> listUserParameterDao = this.userParameterDao.get(login);
            Seq<UserParameter> listUserParameter = UserParameterUtil$.MODULE$.getParams();
            Seq listUserParameterCommon = (Seq)((IterableOps)((IterableOps)listUserParameterDao.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UserParameterController.$anonfun$getUserParameters$1(p)))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UserParameterController.$anonfun$getUserParameters$3(listUserParameter, p)))).$plus$plus((IterableOnce)((IterableOps)listUserParameter.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UserParameterController.$anonfun$getUserParameters$5(p)))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UserParameterController.$anonfun$getUserParameters$7(listUserParameterDao, p))));
            Seq listParamString = (Seq)listUserParameterCommon.map((Function1 & Serializable)up -> up.parameter());
            Seq listUserParameterDaoWithoutCommon = (Seq)listUserParameterDao.filter((Function1 & Serializable)pDao -> BoxesRunTime.boxToBoolean((boolean)UserParameterController.$anonfun$getUserParameters$11(listParamString, pDao)));
            Seq listUserParameterWithoutCommon = (Seq)listUserParameter.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UserParameterController.$anonfun$getUserParameters$12(listParamString, p)));
            Seq listParams = (Seq)((IterableOps)listUserParameterCommon.$plus$plus((IterableOnce)listUserParameterDaoWithoutCommon)).$plus$plus((IterableOnce)listUserParameterWithoutCommon);
            return Json$.MODULE$.toJson((Object)listParams, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), UserParameter$.MODULE$.userHabilitationFormat())).toString();
        }
        throw new MatchError((Object)jsResult);
    }

    public static final /* synthetic */ boolean $anonfun$getUserParameters$1(UserParameter p) {
        return !((String)p.value().getOrElse((Function0 & Serializable)() -> "")).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$getUserParameters$4(BooleanRef continue$1, BooleanRef result$1, UserParameter p$1, UserParameter u) {
        if (continue$1.elem) {
            result$1.elem = u.parameter().equalsIgnoreCase(p$1.parameter());
            if (result$1.elem) {
                continue$1.elem = false;
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getUserParameters$3(Seq listUserParameter$1, UserParameter p) {
        BooleanRef result = BooleanRef.create((boolean)false);
        BooleanRef booleanRef = BooleanRef.create((boolean)true);
        listUserParameter$1.map((Function1 & Serializable)u -> {
            UserParameterController.$anonfun$getUserParameters$4(booleanRef, result, p, u);
            return BoxedUnit.UNIT;
        });
        return result.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getUserParameters$5(UserParameter p) {
        return !((String)p.value().getOrElse((Function0 & Serializable)() -> "")).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$getUserParameters$8(BooleanRef continue$2, BooleanRef result$2, UserParameter p$2, UserParameter u) {
        if (continue$2.elem) {
            boolean bl = result$2.elem = u.parameter().equalsIgnoreCase(p$2.parameter()) && ((String)u.value().getOrElse((Function0 & Serializable)() -> "")).isEmpty();
            if (result$2.elem) {
                continue$2.elem = false;
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getUserParameters$7(Seq listUserParameterDao$1, UserParameter p) {
        BooleanRef result = BooleanRef.create((boolean)false);
        BooleanRef booleanRef = BooleanRef.create((boolean)true);
        listUserParameterDao$1.map((Function1 & Serializable)u -> {
            UserParameterController.$anonfun$getUserParameters$8(booleanRef, result, p, u);
            return BoxedUnit.UNIT;
        });
        return result.elem;
    }

    public static final /* synthetic */ boolean $anonfun$getUserParameters$11(Seq listParamString$1, UserParameter pDao) {
        return !listParamString$1.contains((Object)pDao.parameter());
    }

    public static final /* synthetic */ boolean $anonfun$getUserParameters$12(Seq listParamString$1, UserParameter p) {
        return !listParamString$1.contains((Object)p.parameter());
    }

    @Inject
    public UserParameterController(UserParameterDao userParameterDao, UserModuleDao userModuleDao, LogUtil logUtil) {
        this.userParameterDao = userParameterDao;
        this.userModuleDao = userModuleDao;
        this.logUtil = logUtil;
        this.userModuleByUrlReads = JsPath$.MODULE$.$bslash("url").read((Reads)Reads$.MODULE$.StringReads());
    }
}

