/*
 * Decompiled with CFR 0.152.
 */
package controllers;

import anorm.Column$;
import anorm.ParameterValue;
import anorm.ParameterValue$;
import anorm.SqlParser$;
import anorm.ToParameterValue$;
import anorm.ToStatement;
import anorm.ToStatement$;
import anorm.ToStatementPriority0;
import anorm.package;
import com.google.inject.Inject;
import constants.HabilitationConstants$;
import constants.UserStationConstant$;
import dao.rpc.DistributionStationLinkDao;
import dao.rpc.PiezometerNetworkLinkDao;
import dao.rpc.ProductionStationLinkDao;
import dao.rpc.QualitometerNetworkLinkDao;
import domain.input.LinkStation;
import fr.aquasys.constants.StationTypeConstants$;
import fr.aquasys.daeau.station.domain.StationRights;
import fr.aquasys.daeau.station.domain.StationRights$;
import fr.aquasys.daeau.user.itf.UserDao;
import fr.aquasys.daeau.user.itf.UserHabilitationDao;
import fr.aquasys.daeau.user.itf.UserStationDao;
import fr.aquasys.daeau.user.model.User;
import fr.aquasys.daeau.user.model.UserHabilitation;
import fr.aquasys.daeau.user.model.UserStation;
import fr.aquasys.daeau.user.model.UserStation$;
import fr.aquasys.rabbitmq.util.LogUtil;
import fr.aquasys.utils.CommonReadUtil$;
import fr.aquasys.utils.StationTypeUtil$;
import java.io.Serializable;
import javax.inject.Singleton;
import model.GenericStation;
import play.api.db.Database;
import play.api.libs.functional.FunctionalCanBuild$;
import play.api.libs.functional.VariantExtractor;
import play.api.libs.functional.VariantExtractor$;
import play.api.libs.functional.syntax.package$;
import play.api.libs.json.JsError$;
import play.api.libs.json.JsPath$;
import play.api.libs.json.JsResult$;
import play.api.libs.json.JsValue;
import play.api.libs.json.Json$;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import play.api.libs.json.Writes;
import play.api.libs.json.Writes$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Singleton
@ScalaSignature(bytes="\u0006\u0005\t=f\u0001B\u0011#\u0001\u0015B\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006Y!\f\u0005\tw\u0001\u0011\t\u0011)A\u0006y!Aq\b\u0001B\u0001B\u0003-\u0001\t\u0003\u0005D\u0001\t\u0005\t\u0015a\u0003E\u0011!a\u0005A!A!\u0002\u0017i\u0005\u0002\u0003)\u0001\u0005\u0003\u0005\u000b1B)\t\u0011Q\u0003!\u0011!Q\u0001\fUC\u0001\u0002\u0017\u0001\u0003\u0002\u0003\u0006Y!\u0017\u0005\tC\u0002\u0011\t\u0011)A\u0006E\")A\u000e\u0001C\u0001[\"I\u00111\u0002\u0001C\u0002\u0013\u0005\u0011Q\u0002\u0005\t\u0003_\u0001\u0001\u0015!\u0003\u0002\u0010!I\u0011\u0011\u0007\u0001C\u0002\u0013\u0005\u00111\u0007\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u00026!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBAC\u0001\u0011\u0005\u0011q\u0011\u0005\b\u0003#\u0003A\u0011AAJ\u0011\u001d\ty\n\u0001C\u0001\u0003CC\u0011\"a2\u0001\u0005\u0004%\t!!3\t\u0011\u0005M\u0007\u0001)A\u0005\u0003\u0017Dq!!6\u0001\t\u0003\t9\u000eC\u0004\u0002b\u0002!I!a9\t\u0013\u0005u\bA1A\u0005\u0002\u0005}\b\u0002\u0003B\u0005\u0001\u0001\u0006IA!\u0001\t\u000f\t-\u0001\u0001\"\u0001\u0003\u000e!9\u0011\u0011\u001d\u0001\u0005\u0002\t]\u0001b\u0002B\u0011\u0001\u0011\u0005!1\u0005\u0005\b\u0005\u0013\u0002A\u0011\u0001B&\u0011\u001d\u0011i\u0006\u0001C\u0001\u0005?BqA!\u001a\u0001\t\u0003\u00119\u0007C\u0004\u0003v\u0001!\tAa\u001e\t\u000f\tM\u0005\u0001\"\u0001\u0003\u0016\n)Rk]3s'R\fG/[8o\u0007>tGO]8mY\u0016\u0014(\"A\u0012\u0002\u0017\r|g\u000e\u001e:pY2,'o]\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u000fkN,'o\u0015;bi&|g\u000eR1p!\tq\u0013(D\u00010\u0015\t\u0001\u0014'A\u0002ji\u001aT!AM\u001a\u0002\tU\u001cXM\u001d\u0006\u0003iU\nQ\u0001Z1fCVT!AN\u001c\u0002\u000f\u0005\fX/Y:zg*\t\u0001(\u0001\u0002ge&\u0011!h\f\u0002\u000f+N,'o\u0015;bi&|g\u000eR1p\u0003\u001d)8/\u001a:EC>\u0004\"AL\u001f\n\u0005yz#aB+tKJ$\u0015m\\\u0001\u0014kN,'\u000fS1cS2LG/\u0019;j_:$\u0015m\u001c\t\u0003]\u0005K!AQ\u0018\u0003'U\u001bXM\u001d%bE&d\u0017\u000e^1uS>tG)Y8\u00021ALWM_8nKR,'OT3uo>\u00148\u000eT5oW\u0012\u000bw\u000e\u0005\u0002F\u00156\taI\u0003\u0002H\u0011\u0006\u0019!\u000f]2\u000b\u0003%\u000b1\u0001Z1p\u0013\tYeI\u0001\rQS\u0016Tx.\\3uKJtU\r^<pe.d\u0015N\\6EC>\f!$];bY&$x.\\3uKJtU\r^<pe.d\u0015N\\6EC>\u0004\"!\u0012(\n\u0005=3%AG)vC2LGo\\7fi\u0016\u0014h*\u001a;x_J\\G*\u001b8l\t\u0006|\u0017\u0001\u00079s_\u0012,8\r^5p]N#\u0018\r^5p]2Kgn\u001b#b_B\u0011QIU\u0005\u0003'\u001a\u0013\u0001\u0004\u0015:pIV\u001cG/[8o'R\fG/[8o\u0019&t7\u000eR1p\u0003i!\u0017n\u001d;sS\n,H/[8o'R\fG/[8o\u0019&t7\u000eR1p!\t)e+\u0003\u0002X\r\nQB)[:ue&\u0014W\u000f^5p]N#\u0018\r^5p]2Kgn\u001b#b_\u00069An\\4Vi&d\u0007C\u0001.`\u001b\u0005Y&B\u0001/^\u0003\u0011)H/\u001b7\u000b\u0005y+\u0014\u0001\u0003:bE\nLG/\\9\n\u0005\u0001\\&a\u0002'pOV#\u0018\u000e\\\u0001\tI\u0006$\u0018MY1tKB\u00111M[\u0007\u0002I*\u0011QMZ\u0001\u0003I\nT!a\u001a5\u0002\u0007\u0005\u0004\u0018NC\u0001j\u0003\u0011\u0001H.Y=\n\u0005-$'\u0001\u0003#bi\u0006\u0014\u0017m]3\u0002\rqJg.\u001b;?)\u0005qGCC8reN$XO^<ysB\u0011\u0001\u000fA\u0007\u0002E!)AF\u0003a\u0002[!)1H\u0003a\u0002y!)qH\u0003a\u0002\u0001\")1I\u0003a\u0002\t\")AJ\u0003a\u0002\u001b\")\u0001K\u0003a\u0002#\")AK\u0003a\u0002+\")\u0001L\u0003a\u00023\")\u0011M\u0003a\u0002E\"\u0012!b\u001f\t\u0004y\u0006\u001dQ\"A?\u000b\u0005y|\u0018AB5oU\u0016\u001cGO\u0003\u0003\u0002\u0002\u0005\r\u0011AB4p_\u001edWM\u0003\u0002\u0002\u0006\u0005\u00191m\\7\n\u0007\u0005%QP\u0001\u0004J]*,7\r^\u0001\u0013[>$W\u000f\\3t\u0003\u000e\u001cWm]:BI6Lg.\u0006\u0002\u0002\u0010A1\u0011\u0011CA\u000e\u0003?i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\nS6lW\u000f^1cY\u0016T1!!\u0007)\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003;\t\u0019BA\u0002TKF\u0004B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0003mC:<'BAA\u0015\u0003\u0011Q\u0017M^1\n\t\u00055\u00121\u0005\u0002\u0007'R\u0014\u0018N\\4\u0002'5|G-\u001e7fg\u0006\u001b7-Z:t\u0003\u0012l\u0017N\u001c\u0011\u0002\u001dU\u001cXM]!mY><(+Z1egV\u0011\u0011Q\u0007\t\u0007\u0003o\t\t%!\u0012\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\tAA[:p]*\u0019\u0011q\b4\u0002\t1L'm]\u0005\u0005\u0003\u0007\nIDA\u0003SK\u0006$7\u000fE\u0005(\u0003\u000f\nY%a\u0013\u0002L%\u0019\u0011\u0011\n\u0015\u0003\rQ+\b\u000f\\34!\u0011\ti%a\u0017\u000f\t\u0005=\u0013q\u000b\t\u0004\u0003#BSBAA*\u0015\r\t)\u0006J\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005e\u0003&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tiFC\u0002\u0002Z!\nq\"^:fe\u0006cGn\\<SK\u0006$7\u000fI\u0001\fO\u0016$8\u000b^1uS>t7\u000f\u0006\u0006\u0002L\u0005\u0015\u0014qNA@\u0003\u0007Cq!a\u001a\u0010\u0001\u0004\tI'A\u0004nKN\u001c\u0018mZ3\u0011\t\u0005]\u00121N\u0005\u0005\u0003[\nIDA\u0004KgZ\u000bG.^3\t\u000f\u0005Et\u00021\u0001\u0002t\u00059\u0001.Z1eKJ\u001c\b\u0003CA'\u0003k\nY%!\u001f\n\t\u0005]\u0014Q\f\u0002\u0004\u001b\u0006\u0004\bcA\u0014\u0002|%\u0019\u0011Q\u0010\u0015\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002\u0002>\u0001\r!a\u0013\u0002\r5|G-\u001e7f\u0011\u0019\u0011t\u00021\u0001\u0002L\u0005qQ\u000f\u001d3bi\u0016\u001cF/\u0019;j_:\u001cHCCA&\u0003\u0013\u000bY)!$\u0002\u0010\"9\u0011q\r\tA\u0002\u0005%\u0004bBA9!\u0001\u0007\u00111\u000f\u0005\b\u0003\u0003\u0003\u0002\u0019AA&\u0011\u0019\u0011\u0004\u00031\u0001\u0002L\u0005Ar-\u001a;BgN|7-[1uK\u0012\u001cF/\u0019;j_:$\u0016\u0010]3\u0015\t\u0005-\u0013Q\u0013\u0005\b\u0003/\u000b\u0002\u0019AAM\u0003\u0005!\bcA\u0014\u0002\u001c&\u0019\u0011Q\u0014\u0015\u0003\u0007%sG/A\u000bhKR\f5o]8dS\u0006$X\rZ*uCRLwN\\:\u0015\r\u0005\r\u0016qXAb!\u0019\t)+a,\u00024:!\u0011qUAV\u001d\u0011\t\t&!+\n\u0003%J1!!,)\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\b\u00022*\u0019\u0011Q\u0016\u0015\u0011\t\u0005U\u00161X\u0007\u0003\u0003oS1!!/2\u0003\u0015iw\u000eZ3m\u0013\u0011\ti,a.\u0003\u0017U\u001bXM]*uCRLwN\u001c\u0005\b\u0003\u0003\u0014\u0002\u0019AA&\u0003\u0015awnZ5o\u0011\u001d\t)M\u0005a\u0001\u0003G\u000b\u0001b\u001d;bi&|gn]\u0001\u0011Y><\u0017N\\'pIVdWMU3bIN,\"!a3\u0011\r\u0005]\u0012\u0011IAg!\u001d9\u0013qZA&\u0003\u0017J1!!5)\u0005\u0019!V\u000f\u001d7fe\u0005\tBn\\4j]6{G-\u001e7f%\u0016\fGm\u001d\u0011\u00025\u001d,G/V:fe\u0006cGn\u0015;bi&|g.\u0011<bS2\f'\r\\3\u0015\u0015\u0005-\u0013\u0011\\An\u0003;\fy\u000eC\u0004\u0002hU\u0001\r!!\u001b\t\u000f\u0005ET\u00031\u0001\u0002t!9\u0011\u0011Q\u000bA\u0002\u0005-\u0003B\u0002\u001a\u0016\u0001\u0004\tY%A\fhKR,6/\u001a:Ti\u0006$\u0018n\u001c8Bm\u0006LG.\u00192mKRQ\u0011Q]At\u0003S\fi/a?\u0011\r\u0005\u0015\u0016qVA&\u0011\u001d\t\tM\u0006a\u0001\u0003\u0017Bq!a;\u0017\u0001\u0004\tY%A\u0006ti\u0006$\u0018n\u001c8UsB,\u0007B\u0002\u001a\u0017\u0001\u0004\ty\u000fE\u0003(\u0003c\f)0C\u0002\u0002t\"\u0012aa\u00149uS>t\u0007\u0003BA[\u0003oLA!!?\u00028\n!Qk]3s\u0011\u001d\t\tI\u0006a\u0001\u0003\u0017\nQ#^:feN#\u0018\r^5p]\u0006cGn\\<SK\u0006$7/\u0006\u0002\u0003\u0002A1\u0011qGA!\u0005\u0007\u00012b\nB\u0003\u0003\u0017\nY%a\u0013\u0002L%\u0019!q\u0001\u0015\u0003\rQ+\b\u000f\\35\u0003Y)8/\u001a:Ti\u0006$\u0018n\u001c8BY2|wOU3bIN\u0004\u0013\u0001F4fiV\u001bXM]*uCRLwN\u001c*jO\"$8\u000f\u0006\u0006\u0002L\t=!\u0011\u0003B\n\u0005+Aq!a\u001a\u001a\u0001\u0004\tI\u0007C\u0004\u0002re\u0001\r!a\u001d\t\u000f\u0005\u0005\u0015\u00041\u0001\u0002L!1!'\u0007a\u0001\u0003\u0017\"\"\"a\u0013\u0003\u001a\tm!Q\u0004B\u0010\u0011\u001d\t9G\u0007a\u0001\u0003SBq!!\u001d\u001b\u0001\u0004\t\u0019\bC\u0004\u0002\u0002j\u0001\r!a\u0013\t\rIR\u0002\u0019AA&\u0003U9W\r^!vi\"|'/\u001b>fIN#\u0018\r^5p]N$b\"!:\u0003&\t%\"1\u0006B\u0018\u0005w\u0011y\u0004C\u0004\u0003(m\u0001\r!!>\u0002\u001f\u0005\u0004\b\u000f\\5dCRLg/Z+tKJDq!a;\u001c\u0001\u0004\tY\u0005C\u0004\u0003.m\u0001\r!!:\u0002\u0019U\u001cXM]*uCRLwN\\:\t\u000f\tE2\u00041\u0001\u00034\u0005Y\u0002.\u00192jY&$\u0018\r^5p]N\fE\u000e\\!qa2L7-\u0019;jm\u0016\u0004b!!*\u00020\nU\u0002\u0003BA[\u0005oIAA!\u000f\u00028\n\u0001Rk]3s\u0011\u0006\u0014\u0017\u000e\\5uCRLwN\u001c\u0005\b\u0005{Y\u0002\u0019AA&\u0003!\tG\u000e\u001c,bYV,\u0007b\u0002B!7\u0001\u0007!1I\u0001\u000bkN,'\u000fS1t\u00032d\u0007cA\u0014\u0003F%\u0019!q\t\u0015\u0003\u000f\t{w\u000e\\3b]\u0006!r-\u001a;Ti\u0006$\u0018n\u001c8Bm\u0006LG.Y5cY\u0016$b\"!:\u0003N\t=#1\u000bB,\u00053\u0012Y\u0006C\u0004\u0002Br\u0001\r!a\u0013\t\u000f\tEC\u00041\u0001\u00034\u0005i\u0001.\u00192jY&$\u0018\r^5p]NDqA!\u0016\u001d\u0001\u0004\tY%\u0001\tusB,\u0007*\u00192jY&$\u0018\r^5p]\"9!Q\b\u000fA\u0002\u0005-\u0003bBAv9\u0001\u0007\u00111\n\u0005\b\u0003\u0003c\u0002\u0019AA&\u0003Q9W\r^*qY&$\b*\u00192jY&$\u0018\r^5p]R!\u0011Q\u001dB1\u0011\u001d\u0011\u0019'\ba\u0001\u0005k\tQA^1mk\u0016\f\u0011c\u0019:fCR,Wk]3s'R\fG/[8o))\t\u0019L!\u001b\u0003l\t5$\u0011\u000f\u0005\b\u0003\u0003t\u0002\u0019AA&\u0011\u001d\tYO\ba\u0001\u0003\u0017BqAa\u001c\u001f\u0001\u0004\tY%A\u0006ti\u0006$\u0018n\u001c8D_\u0012,\u0007b\u0002B:=\u0001\u0007\u00111J\u0001\rg\u0016dWm\u0019;fI6{G-Z\u0001\u000fO\u0016$Xk]3s'R\fG/[8o)!\t\u0019K!\u001f\u0003|\tu\u0004bBAa?\u0001\u0007\u00111\n\u0005\b\u0005gz\u0002\u0019AA&\u0011\u001d\u0011yh\ba\u0001\u0005\u0003\u000bAb\u001d;bi&|g\u000eT5oWN\u0004b!!*\u00020\n\r\u0005\u0003\u0002BC\u0005\u001fk!Aa\"\u000b\t\t%%1R\u0001\u0006S:\u0004X\u000f\u001e\u0006\u0003\u0005\u001b\u000ba\u0001Z8nC&t\u0017\u0002\u0002BI\u0005\u000f\u00131\u0002T5oWN#\u0018\r^5p]\u0006ir-\u001a;Vg\u0016\u00148\u000b^1uS>t')\u001f'j].,Gm\u0015;bi&|g\u000e\u0006\u0005\u00024\n]%\u0011\u0014BN\u0011\u001d\t\t\r\ta\u0001\u0003\u0017BqAa\u001d!\u0001\u0004\tY\u0005C\u0004\u0003\u001e\u0002\u0002\rAa!\u0002\u00171Lgn[*uCRLwN\u001c\u0015\u0004\u0001\t\u0005\u0006\u0003\u0002BR\u0005Wk!A!*\u000b\u0007y\u00149K\u0003\u0002\u0003*\u0006)!.\u0019<bq&!!Q\u0016BS\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class UserStationController {
    private final UserStationDao userStationDao;
    private final UserDao userDao;
    private final UserHabilitationDao userHabilitationDao;
    private final ProductionStationLinkDao productionStationLinkDao;
    private final DistributionStationLinkDao distributionStationLinkDao;
    private final LogUtil logUtil;
    private final Database database;
    private final Seq<String> modulesAccessAdmin;
    private final Reads<Tuple3<String, String, String>> userAllowReads;
    private final Reads<Tuple2<String, String>> loginModuleReads;
    private final Reads<Tuple4<String, String, String, String>> userStationAllowReads;

    public Seq<String> modulesAccessAdmin() {
        return this.modulesAccessAdmin;
    }

    public Reads<Tuple3<String, String, String>> userAllowReads() {
        return this.userAllowReads;
    }

    public String getStations(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStation$.MODULE$.userLoginReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(55).append("Error validate Json to get station for specific user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateLogin -> Json$.MODULE$.toJson((Object)$this.userStationDao.get(validateLogin), Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)UserStation$.MODULE$.userStationFormat())).toString());
    }

    public String updateStations(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(UserStation$.MODULE$.userStationsReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(55).append("Error validate Json to get station for specific user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validateLogin -> {
            String login = (String)validateLogin._1();
            Seq stations = (Seq)validateLogin._2();
            Seq associations = (Seq)stations.$plus$plus(this.getAssociatedStations(login, (Seq<UserStation>)stations));
            Seq newObjs = (Seq)associations.map((Function1 & Serializable)a -> new Tuple2(a, (Object)new StringBuilder(1).append(a.stationType()).append(":").append(a.stationCode()).toString()));
            Seq uniqStations = (Seq)((IterableOps)((SeqOps)associations.map((Function1 & Serializable)a -> new StringBuilder(1).append(a.stationType()).append(":").append(a.stationCode()).toString())).distinct()).map((Function1 & Serializable)a -> (UserStation)((Tuple2)newObjs.find((Function1 & Serializable)a2 -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$updateStations$6(a, a2))).get())._1());
            $this.userStationDao.delete(login);
            $this.userStationDao.insert(uniqStations);
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"insert"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)stations.length()), (Writes)Writes$.MODULE$.IntWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"update"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)stations.length()), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        });
    }

    public String getAssociatedStationType(int t) {
        int n = t;
        switch (n) {
            case 1: {
                return UserStationConstant$.MODULE$.TYPE_STATION_PIEZO();
            }
            case 2: {
                return UserStationConstant$.MODULE$.TYPE_STATION_HYDRO();
            }
            case 3: {
                return UserStationConstant$.MODULE$.TYPE_STATION_QUALITO();
            }
        }
        return UserStationConstant$.MODULE$.TYPE_STATION_PLUVIO();
    }

    public Seq<UserStation> getAssociatedStations(String login, Seq<UserStation> stations) {
        if (stations.exists((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$1(s)))) {
            Seq productions = (Seq)stations.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$2(s)));
            Seq distributions = (Seq)stations.filter((Function1 & Serializable)s -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$3(s)));
            Seq<GenericStation> allProductions = this.productionStationLinkDao.getAll(login);
            Seq<GenericStation> allDistributions = this.distributionStationLinkDao.getAll(login);
            Seq productionsAssociations = (Seq)productions.flatMap((Function1 & Serializable)p -> {
                Option option = allProductions.find((Function1 & Serializable)p2 -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$5(p, p2)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    GenericStation prod = (GenericStation)some.value();
                    Seq<LinkStation> res = $this.productionStationLinkDao.getStationLink(prod.id(), login, (Option<Object>)new Some((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                    return (Seq)((IterableOps)res.filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$6(a)))).map((Function1 & Serializable)a -> new UserStation(login, this.getAssociatedStationType(BoxesRunTime.unboxToInt((Object)a.childrenStationType().get())), (String)a.childrenStationId().get(), (Option)new Some((Object)UserStationConstant$.MODULE$.SINGLE())));
                }
                if (None$.MODULE$.equals(option)) {
                    return (Seq)Nil$.MODULE$;
                }
                throw new MatchError((Object)option);
            });
            Seq distributionAssociations = (Seq)distributions.flatMap((Function1 & Serializable)p -> {
                Option option = allDistributions.find((Function1 & Serializable)p2 -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$9(p, p2)));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    GenericStation prod = (GenericStation)some.value();
                    return (Seq)((IterableOps)$this.distributionStationLinkDao.getStationLink(prod.id(), login).filter((Function1 & Serializable)a -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAssociatedStations$10(a)))).map((Function1 & Serializable)a -> new UserStation(login, this.getAssociatedStationType(BoxesRunTime.unboxToInt((Object)a.childrenStationType().get())), (String)a.childrenStationId().get(), (Option)new Some((Object)UserStationConstant$.MODULE$.SINGLE())));
                }
                if (None$.MODULE$.equals(option)) {
                    return (Seq)Nil$.MODULE$;
                }
                throw new MatchError((Object)option);
            });
            return (Seq)productionsAssociations.$plus$plus((IterableOnce)distributionAssociations);
        }
        return (Seq)Nil$.MODULE$;
    }

    public Reads<Tuple2<String, String>> loginModuleReads() {
        return this.loginModuleReads;
    }

    public String getUserAllStationAvailable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.loginModuleReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(55).append("Error validate Json to get station for specific user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)params -> {
            Tuple2 tuple2 = params;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String login = (String)tuple2._1();
            String module = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)login, (Object)module);
            String login2 = (String)tuple22._1();
            String module2 = (String)tuple22._2();
            Option user = $this.userDao.get(login2);
            StationRights result = new StationRights(this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_PIEZO(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_PLUVIO(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_QUALITO(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_HYDRO(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_PRODUCTION(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_DISTRIBUTION(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_INSTALLATION(), (Option<User>)user, module2), this.getUserStationAvailable(login2, UserStationConstant$.MODULE$.TYPE_STATION_RESOURCE(), (Option<User>)user, module2));
            return Json$.MODULE$.toJson((Object)result, (Writes)StationRights$.MODULE$.stationRightsFormat()).toString();
        });
    }

    private Seq<String> getUserStationAvailable(String login, String stationType, Option<User> user, String module) {
        Seq habilitations = this.userHabilitationDao.getAll(login);
        Option<User> option = user;
        if (option instanceof Some) {
            Some some = (Some)option;
            User existUser = (User)some.value();
            if (existUser.isAdmin().isDefined()) {
                Object object = existUser.isAdmin().get();
                String string = "1";
                if (!(object != null ? !object.equals(string) : string != null)) {
                    if (this.modulesAccessAdmin().contains((Object)module) && habilitations.exists((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getUserStationAvailable$1(stationType, x$2)))) {
                        return new .colon.colon((Object)UserStationConstant$.MODULE$.ALL(), (List)Nil$.MODULE$);
                    }
                }
            }
            String string = stationType;
            String string2 = UserStationConstant$.MODULE$.TYPE_STATION_PIEZO();
            String string3 = string;
            if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.PIEZO(), HabilitationConstants$.MODULE$.PIEZO_ALL(), stationType, module);
            }
            String string4 = UserStationConstant$.MODULE$.TYPE_STATION_QUALITO();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.QUALITO(), HabilitationConstants$.MODULE$.QUALITO_ALL(), stationType, module);
            }
            String string6 = UserStationConstant$.MODULE$.TYPE_STATION_HYDRO();
            String string7 = string;
            if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.HYDRO(), HabilitationConstants$.MODULE$.HYDRO_ALL(), stationType, module);
            }
            String string8 = UserStationConstant$.MODULE$.TYPE_STATION_PLUVIO();
            String string9 = string;
            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.PLUVIO(), HabilitationConstants$.MODULE$.PLUVIO_ALL(), stationType, module);
            }
            String string10 = UserStationConstant$.MODULE$.TYPE_STATION_INSTALLATION();
            String string11 = string;
            if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.INSTALLATION(), HabilitationConstants$.MODULE$.INSTALLATION_ALL(), stationType, module);
            }
            String string12 = UserStationConstant$.MODULE$.TYPE_STATION_PRODUCTION();
            String string13 = string;
            if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.PRODUCTION(), HabilitationConstants$.MODULE$.PRODUCTION_ALL(), stationType, module);
            }
            String string14 = UserStationConstant$.MODULE$.TYPE_STATION_DISTRIBUTION();
            String string15 = string;
            if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.DISTRIBUTION(), HabilitationConstants$.MODULE$.DISTRIBUTION_ALL(), stationType, module);
            }
            String string16 = UserStationConstant$.MODULE$.TYPE_STATION_RESOURCE();
            String string17 = string;
            if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.RESOURCE(), HabilitationConstants$.MODULE$.RESOURCE_ALL(), stationType, module);
            }
            String string18 = UserStationConstant$.MODULE$.TYPE_STATION_CATCHMENT();
            String string19 = string;
            if (!(string18 != null ? !string18.equals(string19) : string19 != null)) {
                return this.getStationAvailaible(login, (Seq<UserHabilitation>)habilitations, HabilitationConstants$.MODULE$.CATCHMENT(), HabilitationConstants$.MODULE$.CATCHMENT_ALL(), stationType, module);
            }
            return new .colon.colon((Object)UserStationConstant$.MODULE$.FORBIDEN(), (List)Nil$.MODULE$);
        }
        if (None$.MODULE$.equals(option)) {
            return new .colon.colon((Object)UserStationConstant$.MODULE$.FORBIDEN(), (List)Nil$.MODULE$);
        }
        throw new MatchError(option);
    }

    public Reads<Tuple4<String, String, String, String>> userStationAllowReads() {
        return this.userStationAllowReads;
    }

    public String getUserStationRights(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userStationAllowReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(55).append("Error validate Json to get station for specific user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            boolean bl;
            String allowStation;
            Option option;
            String stationTypeHab;
            Option user;
            String module;
            String login;
            block11: {
                Tuple2 tuple2;
                block10: {
                    Tuple4 tuple4 = validate;
                    if (tuple4 == null) {
                        throw new MatchError((Object)tuple4);
                    }
                    String login2 = (String)tuple4._1();
                    String stationType = (String)tuple4._2();
                    String module2 = (String)tuple4._3();
                    String code = (String)tuple4._4();
                    Tuple4 tuple42 = new Tuple4((Object)login2, (Object)stationType, (Object)module2, (Object)code);
                    login = (String)tuple42._1();
                    String stationType2 = (String)tuple42._2();
                    module = (String)tuple42._3();
                    String code2 = (String)tuple42._4();
                    user = $this.userDao.get(login);
                    tuple2 = (Tuple2)$this.database.withTransaction((Function1 & Serializable)c -> {
                        String string = StationTypeUtil$.MODULE$.StationType(stationType2);
                        String string2 = StationTypeUtil$.MODULE$.PIEZOMETRY();
                        String string3 = string;
                        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$3 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$42 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$3));
                            return new Tuple2((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codepiezometre from piezometres where codebss like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$4 -> x$4), (Object)UserStationConstant$.MODULE$.TYPE_STATION_PIEZO());
                        }
                        String string4 = StationTypeUtil$.MODULE$.QUALITY();
                        String string5 = string;
                        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$72 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$82 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$72));
                            return new Tuple2(package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codequalitometre from qualitometres where codebss like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToDouble()).singleOpt(), c), (Object)UserStationConstant$.MODULE$.TYPE_STATION_QUALITO());
                        }
                        String string6 = StationTypeUtil$.MODULE$.HYDROMETRY();
                        String string7 = string;
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$11 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$12 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$11));
                            return new Tuple2(package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codestation from stations_hydro where codehydro like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToDouble()).singleOpt(), c), (Object)UserStationConstant$.MODULE$.TYPE_STATION_HYDRO());
                        }
                        String string8 = StationTypeUtil$.MODULE$.PLUVIOMETRY();
                        String string9 = string;
                        if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$15 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$16 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$15));
                            return new Tuple2((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codepluviometre from pluviometres where identifiant like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$5 -> x$5), (Object)UserStationConstant$.MODULE$.TYPE_STATION_PLUVIO());
                        }
                        String string10 = StationTypeUtil$.MODULE$.INSTALLATION();
                        String string11 = string;
                        if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$19 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$20 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$19));
                            return new Tuple2((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codeinstallation from aep_installations where identifiant like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$6 -> x$6), (Object)UserStationConstant$.MODULE$.TYPE_STATION_INSTALLATION());
                        }
                        String string12 = StationTypeUtil$.MODULE$.PRODUCTION();
                        String string13 = string;
                        if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$23 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$24 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$23));
                            return new Tuple2((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codeinstallation from aep_unites_prod where identifiant like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$7 -> x$7), (Object)UserStationConstant$.MODULE$.TYPE_STATION_PRODUCTION());
                        }
                        String string14 = StationTypeUtil$.MODULE$.DISTRIBUTION();
                        String string15 = string;
                        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$27 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$28 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$27));
                            return new Tuple2((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select codeinstallation from aep_udi where identifiant like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$8 -> x$8), (Object)UserStationConstant$.MODULE$.TYPE_STATION_DISTRIBUTION());
                        }
                        String string16 = StationTypeUtil$.MODULE$.RESOURCE();
                        String string17 = string;
                        if (!(string16 != null ? !string16.equals(string17) : string17 != null)) {
                            ParameterValue[] parameterValueArray = new ParameterValue[1];
                            ToStatementPriority0.stringToStatement$ x$31 = ToStatement$.MODULE$.stringToStatement();
                            Null$ x$32 = ToParameterValue$.MODULE$.apply$default$1();
                            parameterValueArray[0] = ParameterValue$.MODULE$.from((Object)code2, ToParameterValue$.MODULE$.apply(null, (ToStatement)x$31));
                            return new Tuple2((Object)((Option)package.SqlStringInterpolation$.MODULE$.SQL$extension(anorm.package$.MODULE$.SqlStringInterpolation(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"select id from ressources where code like ", " limit 1"}))), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])parameterValueArray)).as(SqlParser$.MODULE$.scalar(Column$.MODULE$.columnToInt()).singleOpt(), c)).map((Function1)(JFunction1.mcDI.sp & Serializable)x$9 -> x$9), (Object)UserStationConstant$.MODULE$.TYPE_STATION_RESOURCE());
                        }
                        return new Tuple2((Object)new Some((Object)BoxesRunTime.boxToInteger((int)-100)), (Object)"");
                    });
                    if (tuple2 == null) break block10;
                    Option idStation = (Option)tuple2._1();
                    stationTypeHab = (String)tuple2._2();
                    if (!(idStation instanceof Option)) break block10;
                    option = idStation;
                    if (stationTypeHab != null) break block11;
                }
                throw new MatchError((Object)tuple2);
            }
            String string = stationTypeHab;
            Tuple2 tuple2 = new Tuple2((Object)option, (Object)string);
            Option idStation = (Option)tuple2._1();
            String stationTypeHab2 = (String)tuple2._2();
            Seq<String> allowStations = this.getUserStationAvailable(login, stationTypeHab2, (Option<User>)user, module);
            String string2 = allowStation = CommonReadUtil$.MODULE$.getAllowedStations(allowStations);
            String string3 = StationTypeConstants$.MODULE$.FORBIDEN();
            String string4 = string2;
            if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                bl = false;
            } else {
                String string5 = StationTypeConstants$.MODULE$.ALL();
                String string6 = string2;
                if (!(string5 != null ? !string5.equals(string6) : string6 != null)) {
                    bl = true;
                } else if (idStation.isDefined()) {
                    Seq allowStationsIds = (Seq)allowStations.map((Function1 & Serializable)x$11 -> BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(x$11))));
                    bl = allowStationsIds.contains(idStation.get());
                } else {
                    bl = true;
                }
            }
            boolean hasRights = bl;
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hasRights"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((boolean)hasRights), (Writes)Writes$.MODULE$.BooleanWrites())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exists"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToBoolean((!BoxesRunTime.equals((Object)idStation.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> -100), (Object)BoxesRunTime.boxToInteger((int)-100)) ? 1 : 0) != 0), (Writes)Writes$.MODULE$.BooleanWrites()))})).toString();
        });
    }

    public String getUserStationAvailable(JsValue message, Map<String, Object> headers, String module, String user) {
        return (String)message.validate(this.userAllowReads()).fold((Function1 & Serializable)error -> {
            $this.logUtil.error(new StringBuilder(55).append("Error validate Json to get station for specific user :\n").append(JsError$.MODULE$.toJson(error).toString()).toString(), $this.logUtil.error$default$2());
            return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error"), (Object)Json$.MODULE$.toJsFieldJsValueWrapper((Object)BoxesRunTime.boxToInteger((int)400), (Writes)Writes$.MODULE$.IntWrites()))})).toString();
        }, (Function1 & Serializable)validate -> {
            Tuple3 tuple3 = validate;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            String login = (String)tuple3._1();
            String stationType = (String)tuple3._2();
            String module = (String)tuple3._3();
            Tuple3 tuple32 = new Tuple3((Object)login, (Object)stationType, (Object)module);
            String login2 = (String)tuple32._1();
            String stationType2 = (String)tuple32._2();
            String module2 = (String)tuple32._3();
            Option user = $this.userDao.get(login2);
            Seq<String> result = this.getUserStationAvailable(login2, stationType2, (Option<User>)user, module2);
            return Json$.MODULE$.toJson(result, Writes$.MODULE$.iterableWrites2((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Writes)Writes$.MODULE$.StringWrites())).toString();
        });
    }

    public Seq<String> getAuthorizedStations(User applicativeUser, String stationType, Seq<String> userStations, Seq<UserHabilitation> habilitationsAllApplicative, String allValue, boolean userHasAll) {
        Seq applicativeStationsAuthorized = (Seq)this.userStationDao.get(applicativeUser.login(), stationType).map((Function1 & Serializable)x$13 -> x$13.stationCode());
        boolean applicativeHasAll = habilitationsAllApplicative.exists((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getAuthorizedStations$2(allValue, h)));
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(userHasAll, applicativeHasAll);
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl2 = sp2._2$mcZ$sp();
            if (bl && bl2) {
                return new .colon.colon((Object)UserStationConstant$.MODULE$.ALL(), (List)Nil$.MODULE$);
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl && !bl3) {
                return applicativeStationsAuthorized;
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl4 = sp2._2$mcZ$sp();
            if (!bl && bl4) {
                return userStations;
            }
        }
        if (sp2 != null) {
            boolean bl = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (!bl && !bl5) {
                return (Seq)applicativeStationsAuthorized.intersect(userStations);
            }
        }
        throw new MatchError((Object)sp2);
    }

    public Seq<String> getStationAvailaible(String login, Seq<UserHabilitation> habilitations, String typeHabilitation, String allValue, String stationType, String module) {
        boolean moduleIsAuthorized;
        boolean needCheckApplicative;
        Option user = this.userDao.get(login);
        boolean userIsApplicative = user.isDefined() ? BoxesRunTime.unboxToBoolean((Object)((User)user.get()).isApplicative().getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false)) : false;
        Option applicativeUserModuleAccess = this.userDao.getApplicativeUserModuleIfAccess(login, module);
        Seq habilitationsAllApplicative = applicativeUserModuleAccess.isDefined() ? this.userHabilitationDao.getAll(((User)applicativeUserModuleAccess.get()).login()) : (Seq)Nil$.MODULE$;
        boolean bl = needCheckApplicative = module != null && !this.modulesAccessAdmin().contains((Object)module);
        boolean bl2 = !userIsApplicative && needCheckApplicative ? habilitations.exists((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getStationAvailaible$2(typeHabilitation, h))) && habilitationsAllApplicative.exists((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getStationAvailaible$3(typeHabilitation, h))) : (moduleIsAuthorized = habilitations.exists((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getStationAvailaible$4(typeHabilitation, h))));
        if (moduleIsAuthorized) {
            Seq userStations = (Seq)((SeqOps)((IterableOps)((IterableOps)((IterableOps)this.userStationDao.get(login, stationType).map((Function1 & Serializable)x$14 -> x$14.stationCode())).$plus$plus((IterableOnce)this.userStationDao.getContributorStations(login, stationType).map((Function1 & Serializable)x$15 -> UserStationController.$anonfun$getStationAvailaible$6(BoxesRunTime.unboxToInt((Object)x$15))))).$plus$plus((IterableOnce)this.userStationDao.getStationAuthorizeContributor(login, stationType).map((Function1 & Serializable)x$16 -> UserStationController.$anonfun$getStationAvailaible$7(BoxesRunTime.unboxToInt((Object)x$16))))).$plus$plus((IterableOnce)this.userStationDao.getStationAuthorizeNetwork(login, stationType).map((Function1 & Serializable)x$17 -> UserStationController.$anonfun$getStationAvailaible$8(BoxesRunTime.unboxToInt((Object)x$17))))).distinct();
            Option option = habilitations.find((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getStationAvailaible$9(allValue, p)));
            if (option instanceof Some) {
                if (needCheckApplicative) {
                    if (habilitationsAllApplicative.exists((Function1 & Serializable)h -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getStationAvailaible$10(allValue, h))) || login.toLowerCase().contains("widget")) {
                        return new .colon.colon((Object)UserStationConstant$.MODULE$.ALL(), (List)Nil$.MODULE$);
                    }
                    if (applicativeUserModuleAccess.isDefined()) {
                        return this.getAuthorizedStations((User)applicativeUserModuleAccess.getOrElse((Function0 & Serializable)() -> (User)user.get()), stationType, (Seq<String>)userStations, (Seq<UserHabilitation>)habilitationsAllApplicative, allValue, true);
                    }
                    return new .colon.colon((Object)UserStationConstant$.MODULE$.FORBIDEN(), (List)Nil$.MODULE$);
                }
                return new .colon.colon((Object)UserStationConstant$.MODULE$.ALL(), (List)Nil$.MODULE$);
            }
            if (needCheckApplicative) {
                if (applicativeUserModuleAccess.isDefined() || login.toLowerCase().contains("widget")) {
                    return this.getAuthorizedStations((User)applicativeUserModuleAccess.getOrElse((Function0 & Serializable)() -> (User)user.get()), stationType, (Seq<String>)userStations, (Seq<UserHabilitation>)habilitationsAllApplicative, allValue, false);
                }
                return new .colon.colon((Object)UserStationConstant$.MODULE$.FORBIDEN(), (List)Nil$.MODULE$);
            }
            return userStations;
        }
        return new .colon.colon((Object)UserStationConstant$.MODULE$.FORBIDEN(), (List)Nil$.MODULE$);
    }

    public Seq<String> getSplitHabilitation(UserHabilitation value) {
        return Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)value.habilitation().split("_"));
    }

    public UserStation createUserStation(String login, String stationType, String stationCode, String selectedMode) {
        return new UserStation(login, stationType, Integer.toString(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(stationCode))), (Option)new Some((Object)selectedMode));
    }

    public Seq<UserStation> getUserStation(String login, String selectedMode, Seq<LinkStation> stationLinks) {
        return (Seq)((IterableOps)stationLinks.filter((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)UserStationController.$anonfun$getUserStation$1(o)))).map((Function1 & Serializable)station -> this.getUserStationByLinkedStation(login, selectedMode, (LinkStation)station));
    }

    public UserStation getUserStationByLinkedStation(String login, String selectedMode, LinkStation linkStation) {
        Option<Object> option = linkStation.childrenStationType();
        if (option instanceof Some) {
            int typeStation;
            Some some = (Some)option;
            int n = typeStation = BoxesRunTime.unboxToInt((Object)some.value());
            switch (n) {
                case 1: {
                    return this.createUserStation(login, UserStationConstant$.MODULE$.TYPE_STATION_PIEZO(), (String)linkStation.childrenStationId().get(), selectedMode);
                }
                case 3: {
                    return this.createUserStation(login, UserStationConstant$.MODULE$.TYPE_STATION_QUALITO(), (String)linkStation.childrenStationId().get(), selectedMode);
                }
            }
            return null;
        }
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$updateStations$6(String a$1, Tuple2 a2) {
        String string = a$1;
        Object object = a2._2();
        return !(string != null ? !string.equals(object) : object != null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$1(UserStation s) {
        String string = s.stationType();
        String string2 = UserStationConstant$.MODULE$.TYPE_STATION_DISTRIBUTION();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = s.stationType();
        String string4 = UserStationConstant$.MODULE$.TYPE_STATION_PRODUCTION();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$2(UserStation s) {
        String string = s.stationType();
        String string2 = UserStationConstant$.MODULE$.TYPE_STATION_PRODUCTION();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$3(UserStation s) {
        String string = s.stationType();
        String string2 = UserStationConstant$.MODULE$.TYPE_STATION_DISTRIBUTION();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$5(UserStation p$1, GenericStation p2) {
        String string = Integer.toString(p2.id());
        String string2 = p$1.stationCode();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$6(LinkStation a) {
        return a.childrenStationType().isDefined() && BoxesRunTime.unboxToInt((Object)a.childrenStationType().get()) <= 4;
    }

    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$9(UserStation p$2, GenericStation p2) {
        String string = Integer.toString(p2.id());
        String string2 = p$2.stationCode();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAssociatedStations$10(LinkStation a) {
        return a.childrenStationType().isDefined() && BoxesRunTime.unboxToInt((Object)a.childrenStationType().get()) <= 4;
    }

    public static final /* synthetic */ boolean $anonfun$getUserStationAvailable$1(String stationType$1, UserHabilitation x$2) {
        String string = x$2.habilitation();
        String string2 = stationType$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAuthorizedStations$2(String allValue$1, UserHabilitation h) {
        String string = h.habilitation();
        String string2 = allValue$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStationAvailaible$2(String typeHabilitation$1, UserHabilitation h) {
        String string = h.habilitation();
        String string2 = typeHabilitation$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStationAvailaible$3(String typeHabilitation$1, UserHabilitation h) {
        String string = h.habilitation();
        String string2 = typeHabilitation$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStationAvailaible$4(String typeHabilitation$1, UserHabilitation h) {
        String string = h.habilitation();
        String string2 = typeHabilitation$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ String $anonfun$getStationAvailaible$6(int x$15) {
        return Integer.toString(x$15);
    }

    public static final /* synthetic */ String $anonfun$getStationAvailaible$7(int x$16) {
        return Integer.toString(x$16);
    }

    public static final /* synthetic */ String $anonfun$getStationAvailaible$8(int x$17) {
        return Integer.toString(x$17);
    }

    public static final /* synthetic */ boolean $anonfun$getStationAvailaible$9(String allValue$2, UserHabilitation p) {
        String string = p.habilitation();
        String string2 = allValue$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getStationAvailaible$10(String allValue$2, UserHabilitation h) {
        String string = h.habilitation();
        String string2 = allValue$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getUserStation$1(LinkStation o) {
        return o.childrenStationId().isDefined() && o.error().isEmpty();
    }

    @Inject
    public UserStationController(UserStationDao userStationDao, UserDao userDao, UserHabilitationDao userHabilitationDao, PiezometerNetworkLinkDao piezometerNetworkLinkDao, QualitometerNetworkLinkDao qualitometerNetworkLinkDao, ProductionStationLinkDao productionStationLinkDao, DistributionStationLinkDao distributionStationLinkDao, LogUtil logUtil, Database database) {
        this.userStationDao = userStationDao;
        this.userDao = userDao;
        this.userHabilitationDao = userHabilitationDao;
        this.productionStationLinkDao = productionStationLinkDao;
        this.distributionStationLinkDao = distributionStationLinkDao;
        this.logUtil = logUtil;
        this.database = database;
        this.modulesAccessAdmin = new .colon.colon((Object)"WEB", (List)new .colon.colon((Object)"QAPTYS", (List)new .colon.colon((Object)"PORTAIL", (List)new .colon.colon((Object)"IRYQUA", (List)Nil$.MODULE$))));
        this.userAllowReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("login").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.loginModuleReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("login").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
        this.userStationAllowReads = (Reads)package$.MODULE$.toFunctionalBuilderOps((Object)JsPath$.MODULE$.$bslash("user").read((Reads)Reads$.MODULE$.StringReads()), FunctionalCanBuild$.MODULE$.functionalCanBuildApplicative(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))).and((Object)JsPath$.MODULE$.$bslash("stationType").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("module").read((Reads)Reads$.MODULE$.StringReads())).and((Object)JsPath$.MODULE$.$bslash("code").read((Reads)Reads$.MODULE$.StringReads())).tupled((VariantExtractor)VariantExtractor$.MODULE$.functor(Reads$.MODULE$.functorReads(Reads$.MODULE$.applicative(JsResult$.MODULE$.applicativeJsResult()))));
    }
}

